/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.util.Random;
import pixelitor.tools.AbstractBrushTool;
import pixelitor.tools.BrushTool;
import pixelitor.tools.ColorPickerTool;
import pixelitor.tools.EraseTool;
import pixelitor.tools.GradientTool;
import pixelitor.tools.HandTool;
import pixelitor.tools.MoveTool;
import pixelitor.tools.PaintBucketTool;
import pixelitor.tools.SelectionTool;
import pixelitor.tools.ShapesTool;
import pixelitor.tools.Tool;
import pixelitor.tools.ToolSettingsPanelContainer;

public class Tools {
    public static final SelectionTool SELECTION = new SelectionTool();
    public static final MoveTool MOVE = new MoveTool();
    public static final GradientTool GRADIENT = new GradientTool();
    public static final BrushTool BRUSH = new BrushTool();
    public static final EraseTool ERASER = new EraseTool();
    public static final ColorPickerTool COLOR_PICKER = new ColorPickerTool();
    public static final ShapesTool SHAPES = new ShapesTool();
    public static final HandTool HAND = new HandTool();
    public static final PaintBucketTool PAINT_BUCKET = new PaintBucketTool();
    static Tool currentTool = BRUSH;
    private static Tool[] allTools = new Tool[]{MOVE, SELECTION, BRUSH, ERASER, GRADIENT, PAINT_BUCKET, COLOR_PICKER, SHAPES, HAND};

    private Tools() {
    }

    public static Tool[] getTools() {
        return allTools;
    }

    public static Tool getCurrentTool() {
        return currentTool;
    }

    public static void setCurrentTool(Tool tool) {
        tool.toolEnded();
        currentTool = tool;
        tool.toolStarted();
        ToolSettingsPanelContainer.INSTANCE.showSettingsFor(tool);
    }

    public static boolean isShapesDrawing() {
        if (currentTool != SHAPES) {
            return false;
        }
        return SHAPES.isDrawing();
    }

    public static void increaseActiveBrushSize() {
        if (currentTool instanceof AbstractBrushTool) {
            AbstractBrushTool abstractBrushTool = (AbstractBrushTool)currentTool;
            abstractBrushTool.increaseBrushSize();
        }
    }

    public static void decreaseActiveBrushSize() {
        if (currentTool instanceof AbstractBrushTool) {
            AbstractBrushTool abstractBrushTool = (AbstractBrushTool)currentTool;
            abstractBrushTool.decreaseBrushSize();
        }
    }

    public static Tool getRandomTool(Random random) {
        int n = random.nextInt(allTools.length);
        return allTools[n];
    }
}

