/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import pixelitor.GlobalKeyboardWatch;
import pixelitor.filters.painters.TextFilter;
import pixelitor.tools.Tool;
import pixelitor.tools.ToolButton;
import pixelitor.tools.Tools;

public class ToolsPanel
extends JPanel {
    public ToolsPanel() {
        Tool[] toolArray;
        Box box = Box.createVerticalBox();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Tool tool : toolArray = Tools.getTools()) {
            ToolButton toolButton = new ToolButton(tool);
            box.add(toolButton);
            buttonGroup.add(toolButton);
            ToolsPanel.setupKeyboardShortcut(tool);
        }
        this.add(box);
        ToolsPanel.setDefaultTool();
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextFilter.INSTANCE.actionPerformed(actionEvent);
            }
        };
        GlobalKeyboardWatch.addKeyboardShortCut('t', true, "text", abstractAction);
    }

    private static void setupKeyboardShortcut(final Tool tool) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Tools.currentTool != tool) {
                    tool.getButton().doClick();
                }
            }
        };
        String string = tool.getName();
        char c = tool.getActivationKeyChar();
        GlobalKeyboardWatch.addKeyboardShortCut(c, true, string, abstractAction);
    }

    private static void setDefaultTool() {
        Tools.setCurrentTool(Tools.BRUSH);
        Tools.currentTool.getButton().setSelected(true);
    }
}

