/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools.brushes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import pixelitor.tools.brushes.Brush;
import pixelitor.tools.brushes.ImageBrushType;
import pixelitor.utils.ImageUtils;

public class ImageBrush
implements Brush {
    private BufferedImage templateImage;
    private BufferedImage coloredBrushImage;
    private BufferedImage finalScaledImage;
    private Color lastColor;

    public ImageBrush(ImageBrushType imageBrushType) {
        this.templateImage = imageBrushType.createTemplateBrush(50);
    }

    private void resizeBrushImage(float f, boolean bl) {
        if (!bl && this.finalScaledImage != null && (float)this.finalScaledImage.getWidth() == f) {
            return;
        }
        if (this.finalScaledImage != null) {
            this.finalScaledImage.flush();
        }
        int n = (int)f;
        this.finalScaledImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = this.finalScaledImage.createGraphics();
        graphics2D.drawImage(this.coloredBrushImage, 0, 0, n, n, null);
        graphics2D.dispose();
    }

    @Override
    public void drawPoint(Graphics2D graphics2D, int n, int n2, float f) {
        this.updateStateBeforeDrawing(graphics2D, f);
        this.drawPointNoCheck(graphics2D, n, n2);
    }

    private void updateStateBeforeDrawing(Graphics2D graphics2D, float f) {
        Color color = graphics2D.getColor();
        if (!color.equals(this.lastColor)) {
            this.colorizeBrushImage(color);
            this.lastColor = color;
            this.resizeBrushImage(f, true);
        } else {
            this.resizeBrushImage(f, false);
        }
    }

    private void drawPointNoCheck(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawImage((Image)this.finalScaledImage, n, n2, null);
    }

    @Override
    public void drawLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, float f) {
        this.updateStateBeforeDrawing(graphics2D, f);
        double d = n3 - n;
        double d2 = n4 - n2;
        double d3 = Math.max(Math.abs(d), Math.abs(d2));
        double d4 = d / d3;
        double d5 = d2 / d3;
        double d6 = n;
        double d7 = n2;
        float f2 = f / 2.0f;
        int n5 = 0;
        while ((double)n5 < d3) {
            int n6 = (int)(d6 - (double)f2);
            int n7 = (int)(d7 - (double)f2);
            this.drawPointNoCheck(graphics2D, n6, n7);
            d6 += d4;
            d7 += d5;
            ++n5;
        }
    }

    private void colorizeBrushImage(Color color) {
        this.coloredBrushImage = new BufferedImage(this.templateImage.getWidth(), this.templateImage.getHeight(), 2);
        int[] nArray = ImageUtils.getPixelsAsArray(this.templateImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(this.coloredBrushImage);
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        for (int i = 0; i < nArray2.length; ++i) {
            int n4 = nArray[i];
            int n5 = n4 >>> 16 & 0xFF;
            int n6 = n4 >>> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            int n8 = (n5 + n6 + n7) / 3;
            nArray2[i] = 255 - n8 << 24 | n << 16 | n2 << 8 | n3;
        }
    }
}

