/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools.gradientpaints;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import pixelitor.tools.UserDrag;

public class DiamondGradientPaint
implements Paint {
    private UserDrag userDrag;
    private Color startColor;
    private Color endColor;
    private MultipleGradientPaint.CycleMethod cycleMethod;

    public DiamondGradientPaint(UserDrag userDrag, Color color, Color color2, MultipleGradientPaint.CycleMethod cycleMethod) {
        this.userDrag = userDrag;
        this.startColor = color;
        this.endColor = color2;
        this.cycleMethod = cycleMethod;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new DiamondGradientPaintContext(this.userDrag, this.startColor, this.endColor, colorModel, this.cycleMethod);
    }

    @Override
    public int getTransparency() {
        int n;
        int n2 = this.startColor.getAlpha();
        return (n2 & (n = this.endColor.getAlpha())) == 255 ? 1 : 3;
    }

    static class DiamondGradientPaintContext
    implements PaintContext {
        private UserDrag userDrag;
        private MultipleGradientPaint.CycleMethod cycleMethod;
        private int startAlpha;
        private int startRed;
        private int startGreen;
        private int startBlue;
        private int endAlpha;
        private int endRed;
        private int endGreen;
        private int endBlue;
        private ColorModel cm;
        private float proportionalXDiff;
        private float proportionalYDiff;

        private DiamondGradientPaintContext(UserDrag userDrag, Color color, Color color2, ColorModel colorModel, MultipleGradientPaint.CycleMethod cycleMethod) {
            this.userDrag = userDrag;
            this.cycleMethod = cycleMethod;
            this.startAlpha = color.getAlpha();
            this.startRed = color.getRed();
            this.startGreen = color.getGreen();
            this.startBlue = color.getBlue();
            this.endAlpha = color2.getAlpha();
            this.endRed = color2.getRed();
            this.endGreen = color2.getGreen();
            this.endBlue = color2.getBlue();
            this.cm = colorModel;
            double d = userDrag.getDistance();
            double d2 = d * d;
            this.proportionalXDiff = (float)((double)userDrag.getHorizontalDifference() / d2);
            this.proportionalYDiff = (float)((double)userDrag.getVerticalDifference() / d2);
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return this.cm;
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            WritableRaster writableRaster = this.cm.createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n5 = (i * n3 + j) * 4;
                    float f = n + j - this.userDrag.getStartX();
                    float f2 = n2 + i - this.userDrag.getStartY();
                    float f3 = Math.abs(f * this.proportionalXDiff + f2 * this.proportionalYDiff);
                    float f4 = Math.abs(f * this.proportionalYDiff - f2 * this.proportionalXDiff);
                    float f5 = f3 + f4;
                    if (this.cycleMethod == MultipleGradientPaint.CycleMethod.NO_CYCLE) {
                        if ((double)f5 > 1.0) {
                            f5 = 1.0f;
                        }
                    } else if (this.cycleMethod == MultipleGradientPaint.CycleMethod.REFLECT) {
                        f5 = (double)(f5 = (float)((double)f5 % 1.0)) < 0.5 ? 2.0f * f5 : 2.0f * (1.0f - f5);
                    } else if (this.cycleMethod == MultipleGradientPaint.CycleMethod.REPEAT) {
                        f5 = (double)(f5 = (float)((double)f5 % 1.0)) < 0.5 ? 2.0f * f5 : 2.0f * (f5 - 0.5f);
                    }
                    int n6 = (int)((float)this.startAlpha + f5 * (float)(this.endAlpha - this.startAlpha));
                    int n7 = (int)((float)this.startRed + f5 * (float)(this.endRed - this.startRed));
                    int n8 = (int)((float)this.startGreen + f5 * (float)(this.endGreen - this.startGreen));
                    int n9 = (int)((float)this.startBlue + f5 * (float)(this.endBlue - this.startBlue));
                    nArray[n5] = n7;
                    nArray[n5 + 1] = n8;
                    nArray[n5 + 2] = n9;
                    nArray[n5 + 3] = n6;
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }
}

