/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import pixelitor.NewImage;
import pixelitor.PixelitorWindow;
import pixelitor.TipsOfTheDay;
import pixelitor.history.History;
import pixelitor.io.OpenSaveManager;
import pixelitor.menus.RecentFileInfo;
import pixelitor.menus.RecentFilesMenu;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.IntTextField;
import pixelitor.utils.OKCancelDialog;
import pixelitor.utils.Utils;

public final class AppPreferences {
    private static final String FRAME_X_KEY = "window_x";
    private static final String FRAME_Y_KEY = "window_y";
    private static final String FRAME_WIDTH_KEY = "window_width";
    private static final String FRAME_HEIGHT_KEY = "window_height";
    private static final String NEW_IMAGE_WIDTH = "new_image_width";
    private static final String NEW_IMAGE_HEIGHT = "new_image_height";
    private static Dimension newImageSize = null;
    private static final String RECENT_FILE_PREFS_KEY = "recent_file_";
    private static Preferences mainUserNode = Preferences.userNodeForPackage(PixelitorWindow.class);
    private static Preferences recentFilesUserNode = Preferences.userNodeForPackage(RecentFilesMenu.class);
    private static final String FG_COLOR_KEY = "fg_color";
    private static final String BG_COLOR_KEY = "bg_color";
    private static final String LAST_OPEN_DIR_KEY = "last_open_dir";
    private static final String LAST_SAVE_DIR_KEY = "last_save_dir";
    private static final String HISTOGRAMS_SHOWN_KEY = "histograms_shown";
    private static final String LAYERS_SHOWN_KEY = "layers_shown";
    private static final String TOOLS_SHOWN_KEY = "tools_shown";
    private static final String STATUS_BAR_SHOWN_KEY = "status_bar_shown";
    private static final String UNDO_LEVELS_KEY = "undo_levels";

    private AppPreferences() {
    }

    private static void saveFramePosition(Window window) {
        int n = window.getX();
        int n2 = window.getY();
        int n3 = window.getWidth();
        int n4 = window.getHeight();
        mainUserNode.putInt(FRAME_X_KEY, n);
        mainUserNode.putInt(FRAME_Y_KEY, n2);
        mainUserNode.putInt(FRAME_WIDTH_KEY, n3);
        mainUserNode.putInt(FRAME_HEIGHT_KEY, n4);
    }

    public static Dimension loadNewImageSize() {
        if (newImageSize == null) {
            int n = mainUserNode.getInt(NEW_IMAGE_WIDTH, 600);
            int n2 = mainUserNode.getInt(NEW_IMAGE_HEIGHT, 400);
            newImageSize = new Dimension(n, n2);
        }
        return newImageSize;
    }

    private static void saveNewImageSize() {
        Dimension dimension = NewImage.getLastNew();
        mainUserNode.putInt(NEW_IMAGE_WIDTH, dimension.width);
        mainUserNode.putInt(NEW_IMAGE_HEIGHT, dimension.height);
    }

    public static void loadFramePosition(Window window) {
        int n = mainUserNode.getInt(FRAME_X_KEY, 0);
        int n2 = mainUserNode.getInt(FRAME_Y_KEY, 0);
        int n3 = mainUserNode.getInt(FRAME_WIDTH_KEY, 0);
        int n4 = mainUserNode.getInt(FRAME_HEIGHT_KEY, 0);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (n3 <= 0 || n4 <= 0) {
            n3 = rectangle.width;
            n4 = rectangle.height;
        }
        if (n3 > rectangle.width) {
            n3 = rectangle.width;
        }
        if (n4 > rectangle.height) {
            n4 = rectangle.height;
        }
        if (n < 0 || n2 < 0) {
            n = 0;
            n2 = 0;
        }
        window.setLocation(new Point(n, n2));
        window.setSize(n3, n4);
    }

    public static List<RecentFileInfo> loadRecentFiles(int n) {
        String string;
        String string2;
        ArrayList<RecentFileInfo> arrayList = new ArrayList<RecentFileInfo>();
        for (int i = 0; i < n && (string2 = recentFilesUserNode.get(string = RECENT_FILE_PREFS_KEY + i, null)) != null; ++i) {
            RecentFileInfo recentFileInfo;
            File file = new File(string2);
            if (!file.exists() || arrayList.contains(recentFileInfo = new RecentFileInfo(file))) continue;
            arrayList.add(recentFileInfo);
        }
        return arrayList;
    }

    private static void saveRecentFiles(List<RecentFileInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = RECENT_FILE_PREFS_KEY + i;
            String string2 = list.get(i).getSavedName();
            recentFilesUserNode.put(string, string2);
        }
    }

    public static void removeRecentFiles(int n) {
        for (int i = 0; i < n; ++i) {
            recentFilesUserNode.remove(RECENT_FILE_PREFS_KEY + i);
        }
    }

    public static File loadLastOpenDir() {
        return AppPreferences.loadDir(LAST_OPEN_DIR_KEY);
    }

    public static File loadLastSaveDir() {
        return AppPreferences.loadDir(LAST_SAVE_DIR_KEY);
    }

    private static File loadDir(String string) {
        String string2 = mainUserNode.get(string, null);
        if (string2 == null) {
            return AppPreferences.getDocumentsDir();
        }
        File file = new File(string2);
        if (!file.exists()) {
            return AppPreferences.getDocumentsDir();
        }
        if (!file.isDirectory()) {
            return AppPreferences.getDocumentsDir();
        }
        return file;
    }

    private static File getDocumentsDir() {
        return FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    private static void saveLastOpenDir() {
        AppPreferences.saveDir(OpenSaveManager.getLastOpenDir(), LAST_OPEN_DIR_KEY);
    }

    private static void saveLastSaveDir() {
        AppPreferences.saveDir(OpenSaveManager.getLastSaveDir(), LAST_SAVE_DIR_KEY);
    }

    private static void saveDir(File file, String string) {
        if (file != null) {
            mainUserNode.put(string, file.getAbsolutePath());
        } else {
            mainUserNode.put(string, null);
        }
    }

    public static int loadUndoLevels() {
        int n = mainUserNode.getInt(UNDO_LEVELS_KEY, -1);
        if (n == -1) {
            return AppPreferences.getDefaultUndoLevels();
        }
        return n;
    }

    private static void saveUndoLevels() {
        mainUserNode.putInt(UNDO_LEVELS_KEY, History.getUndoLevels());
    }

    public static void savePreferencesBeforeExit() {
        AppPreferences.saveRecentFiles(RecentFilesMenu.getInstance().getRecentFileNamesForSaving());
        AppPreferences.saveFramePosition(PixelitorWindow.getInstance());
        AppPreferences.saveLastOpenDir();
        AppPreferences.saveLastSaveDir();
        AppPreferences.saveFgBgColors();
        WorkSpace.saveVisibility();
        AppPreferences.saveUndoLevels();
        TipsOfTheDay.saveNextTipNr();
        AppPreferences.saveNewImageSize();
    }

    public static Color loadFgColor() {
        int n = mainUserNode.getInt(FG_COLOR_KEY, -16777216);
        return new Color(n);
    }

    public static Color loadBgColor() {
        int n = mainUserNode.getInt(BG_COLOR_KEY, -1);
        return new Color(n);
    }

    private static void saveFgBgColors() {
        Color color;
        Color color2 = FgBgColorSelector.getFG();
        if (color2 != null) {
            mainUserNode.putInt(FG_COLOR_KEY, color2.getRGB());
        }
        if ((color = FgBgColorSelector.getBG()) != null) {
            mainUserNode.putInt(BG_COLOR_KEY, color.getRGB());
        }
    }

    public static String getDefaultLookAndFeelClass() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getName().equals("Nimbus")) continue;
            return lookAndFeelInfo.getClassName();
        }
        return UIManager.getSystemLookAndFeelClassName();
    }

    public static Preferences getMainUserNode() {
        return mainUserNode;
    }

    private static int getDefaultUndoLevels() {
        int n = Utils.getMaxHeapInMegabytes();
        int n2 = 1 + n / 50;
        return n2;
    }

    public static class Panel
    extends JPanel {
        private JTextField undoLevelsTF;

        Panel() {
            this.setLayout(new GridBagLayout());
            GridBagHelper.addLabel((Container)this, "Undo/Redo Levels: ", 0, 0);
            this.undoLevelsTF = new IntTextField(3);
            this.undoLevelsTF.setText(String.valueOf(History.getUndoLevels()));
            GridBagHelper.addControl(this, this.undoLevelsTF);
        }

        private int getUndoLevels() {
            String string = this.undoLevelsTF.getText();
            int n = Integer.parseInt(string);
            return n;
        }

        public static void showInDialog() {
            final Panel panel = new Panel();
            OKCancelDialog oKCancelDialog = new OKCancelDialog((JComponent)panel, "Preferences"){

                @Override
                protected void dialogAccepted() {
                    super.dialogAccepted();
                    int n = panel.getUndoLevels();
                    History.setUndoLevels(n);
                    this.dispose();
                }

                @Override
                protected void dialogCancelled() {
                    super.dialogCancelled();
                    this.dispose();
                }
            };
            oKCancelDialog.setVisible(true);
        }
    }

    public static class WorkSpace {
        private static boolean DEFAULT_HISTOGRAMS_VISIBILITY = false;
        private static boolean DEFAULT_TOOLS_VISIBILITY = true;
        private static boolean DEFAULT_LAYERS_VISIBILITY = true;
        private static boolean DEFAULT_STATUS_BAR_VISIBILITY = true;
        static boolean loaded = false;
        private static boolean histogramsVisibility;
        private static boolean toolsVisibility;
        private static boolean layersVisibility;
        private static boolean statusBarVisibility;

        private WorkSpace() {
        }

        private static void load() {
            if (loaded) {
                return;
            }
            histogramsVisibility = mainUserNode.getBoolean(AppPreferences.HISTOGRAMS_SHOWN_KEY, DEFAULT_HISTOGRAMS_VISIBILITY);
            toolsVisibility = mainUserNode.getBoolean(AppPreferences.TOOLS_SHOWN_KEY, DEFAULT_TOOLS_VISIBILITY);
            layersVisibility = mainUserNode.getBoolean(AppPreferences.LAYERS_SHOWN_KEY, DEFAULT_LAYERS_VISIBILITY);
            statusBarVisibility = mainUserNode.getBoolean(AppPreferences.STATUS_BAR_SHOWN_KEY, DEFAULT_STATUS_BAR_VISIBILITY);
            loaded = true;
        }

        public static void setDefault() {
            PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
            pixelitorWindow.setHistogramsVisibility(DEFAULT_HISTOGRAMS_VISIBILITY, false);
            pixelitorWindow.setToolsVisibility(DEFAULT_TOOLS_VISIBILITY, false);
            pixelitorWindow.setLayersVisibility(DEFAULT_LAYERS_VISIBILITY, false);
            pixelitorWindow.setStatusBarVisibility(DEFAULT_STATUS_BAR_VISIBILITY, false);
            ((JComponent)pixelitorWindow.getContentPane()).revalidate();
            histogramsVisibility = DEFAULT_HISTOGRAMS_VISIBILITY;
            toolsVisibility = DEFAULT_TOOLS_VISIBILITY;
            layersVisibility = DEFAULT_LAYERS_VISIBILITY;
            statusBarVisibility = DEFAULT_STATUS_BAR_VISIBILITY;
        }

        public static boolean getHistogramsVisibility() {
            WorkSpace.load();
            return histogramsVisibility;
        }

        public static boolean getLayersVisibility() {
            WorkSpace.load();
            return layersVisibility;
        }

        public static boolean getStatusBarVisibility() {
            WorkSpace.load();
            return statusBarVisibility;
        }

        public static boolean getToolsVisibility() {
            WorkSpace.load();
            return toolsVisibility;
        }

        private static void saveVisibility() {
            mainUserNode.putBoolean(AppPreferences.HISTOGRAMS_SHOWN_KEY, histogramsVisibility);
            mainUserNode.putBoolean(AppPreferences.LAYERS_SHOWN_KEY, layersVisibility);
            mainUserNode.putBoolean(AppPreferences.TOOLS_SHOWN_KEY, toolsVisibility);
            mainUserNode.putBoolean(AppPreferences.STATUS_BAR_SHOWN_KEY, statusBarVisibility);
        }

        public static void setLayersVisibility(boolean bl) {
            layersVisibility = bl;
            PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
            pixelitorWindow.setLayersVisibility(bl, true);
        }

        public static void setHistogramsVisibility(boolean bl) {
            histogramsVisibility = bl;
            PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
            pixelitorWindow.setHistogramsVisibility(bl, true);
        }

        public static void setToolsVisibility(boolean bl) {
            toolsVisibility = bl;
            PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
            pixelitorWindow.setToolsVisibility(bl, true);
        }

        public static void setStatusBarVisibility(boolean bl) {
            statusBarVisibility = bl;
            PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
            pixelitorWindow.setStatusBarVisibility(bl, true);
        }
    }
}

