/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Composite;
import java.awt.FlowLayout;
import java.util.Random;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pixelitor.layers.BlendingMode;
import pixelitor.utils.DropDownSlider;
import pixelitor.utils.GUIUtils;

public class BlendingModePanel
extends JPanel {
    protected DropDownSlider opacityDDSlider;
    protected JComboBox blendingModeCombo;

    public BlendingModePanel(boolean bl) {
        this.setLayout(new FlowLayout(0));
        this.add(new JLabel("Opacity:"));
        this.opacityDDSlider = new DropDownSlider(100, 0, 100, true);
        this.add(this.opacityDDSlider);
        if (bl) {
            this.add(new JLabel("%, Blending Mode:", 2));
        } else {
            this.add(new JLabel("%", 2));
        }
        this.blendingModeCombo = new JComboBox<BlendingMode>(BlendingMode.values());
        this.add(this.blendingModeCombo);
    }

    protected float getOpacity() {
        return (float)this.opacityDDSlider.getValue() / 100.0f;
    }

    protected BlendingMode getBlendingMode() {
        return (BlendingMode)((Object)this.blendingModeCombo.getSelectedItem());
    }

    public Composite getComposite() {
        Composite composite = this.getBlendingMode().getComposite(this.getOpacity());
        return composite;
    }

    public void randomize() {
        BlendingMode[] blendingModeArray = BlendingMode.values();
        Random random = new Random();
        int n = random.nextInt(blendingModeArray.length);
        this.blendingModeCombo.setSelectedIndex(n);
        int n2 = random.nextInt(100);
        this.opacityDDSlider.setValue(n2);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.opacityDDSlider.setEnabled(bl);
        this.blendingModeCombo.setEnabled(bl);
    }

    public void setOpacity(float f) {
        int n = (int)(f * 100.0f);
        this.opacityDDSlider.setValue(n);
    }

    public static void main(String[] stringArray) {
        GUIUtils.testJComponent(new BlendingModePanel(true));
    }
}

