/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.OKCancelDialog;
import pixelitor.utils.Utils;

public final class GUIUtils {
    private GUIUtils() {
    }

    public static void testJDialog(JDialog jDialog) {
        JComponent jComponent = (JComponent)jDialog.getContentPane();
        GUIUtils.testJComponent(jComponent);
    }

    public static void testJComponent(final JComponent jComponent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object;
                try {
                    object = AppPreferences.getDefaultLookAndFeelClass();
                    UIManager.setLookAndFeel((String)object);
                }
                catch (Exception exception) {
                    ExceptionHandler.showExceptionDialog(exception);
                }
                object = new JFrame("Test");
                ((JFrame)object).setDefaultCloseOperation(3);
                ((JFrame)object).setLayout(new BorderLayout());
                ((Container)object).add((Component)jComponent, "Center");
                SwingUtilities.updateComponentTreeUI((Component)object);
                ((Window)object).pack();
                GUIUtils.centerOnScreen((Component)object);
                ((Window)object).setVisible(true);
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public static void centerOnScreen(Component component) {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int n = rectangle.height;
        int n2 = rectangle.width;
        Dimension dimension = component.getSize();
        if (dimension.height > n) {
            dimension.height = n;
        }
        if (dimension.width > n2) {
            dimension.width = n2;
        }
        component.setLocation((n2 - dimension.width) / 2, (n - dimension.height) / 2);
        component.setSize(dimension);
    }

    public static boolean appIsActive() {
        Window[] windowArray;
        for (Window window : windowArray = Window.getWindows()) {
            if (!window.isActive()) continue;
            return true;
        }
        return false;
    }

    public static void showTextDialog(JComponent jComponent, String string, final String string2) {
        OKCancelDialog oKCancelDialog = new OKCancelDialog(jComponent, (Frame)PixelitorWindow.getInstance(), string, "Copy as Text to the Clipboard", "Close"){

            @Override
            protected void dialogAccepted() {
                super.dialogAccepted();
                Utils.copyStringToClipboard(string2);
            }

            @Override
            protected void dialogCancelled() {
                super.dialogCancelled();
                this.dispose();
            }
        };
        oKCancelDialog.setVisible(true);
    }
}

