/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;

public class HistogramPainter
extends JComponent {
    private static final int PREFERRED_HEIGHT = 100;
    private int[] values = null;
    private int maxValue = 0;
    private Color color = null;
    private Insets insets;

    public HistogramPainter(Color color) {
        this.color = color;
        this.insets = this.getInsets();
        this.setPreferredSize(new Dimension(256 + this.insets.left + this.insets.right, 100 + this.insets.top + this.insets.bottom));
    }

    public void updateData(int[] nArray) {
        this.values = nArray;
        this.maxValue = 0;
        for (int n : nArray) {
            if (this.maxValue >= n) continue;
            this.maxValue = n;
        }
    }

    public void updateWithNothing() {
        this.maxValue = 0;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.maxValue == 0) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(Color.BLACK);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        if (this.values == null) {
            return;
        }
        int n3 = this.insets.left;
        for (int n4 : this.values) {
            int n5 = (int)((double)n2 * ((double)n4 / (double)this.maxValue));
            graphics.setColor(this.color);
            graphics.drawLine(n3, n2 - n5, n3, n2);
            ++n3;
        }
    }
}

