/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.gui.Resettable;
import pixelitor.utils.DefaultButton;
import pixelitor.utils.GradientBorder;

public class SliderSpinner
extends JPanel
implements ChangeListener {
    private JLabel label;
    private Resettable resettableParam;
    private JSlider slider;
    private JSpinner spinner;
    private DefaultButton defaultButton;
    private RangeParam model;
    private Color leftColor;
    private Color rightColor;
    private boolean colorsUsed;
    private boolean sliderMoved = false;
    private boolean spinnerMoved = false;

    public SliderSpinner(RangeParam rangeParam, boolean bl, TextPosition textPosition) {
        this(null, null, rangeParam, bl, textPosition);
    }

    public SliderSpinner(Color color, Color color2, RangeParam rangeParam) {
        this(color, color2, rangeParam, true, TextPosition.BORDER);
    }

    private SliderSpinner(Color color, Color color2, RangeParam rangeParam, boolean bl, TextPosition textPosition) {
        this.setLayout(new BorderLayout());
        this.model = rangeParam;
        this.leftColor = color;
        this.rightColor = color2;
        boolean bl2 = this.colorsUsed = color != null;
        if (textPosition == TextPosition.BORDER) {
            if (color != null && color2 != null) {
                GradientBorder gradientBorder = new GradientBorder(color, color2);
                this.setBorder(BorderFactory.createTitledBorder(gradientBorder, rangeParam.getName()));
            } else {
                this.setBorder(BorderFactory.createTitledBorder(rangeParam.getName()));
                this.leftColor = Color.GRAY;
                this.rightColor = Color.GRAY;
            }
        }
        this.slider = new JSlider(rangeParam);
        if (textPosition == TextPosition.BORDER) {
            this.setupTicks();
        }
        this.slider.addChangeListener(this);
        this.spinner = new JSpinner(new SpinnerNumberModel(rangeParam.getValue(), rangeParam.getMinimum(), rangeParam.getMaximum(), 1));
        this.spinner.addChangeListener(this);
        int n = (int)this.spinner.getPreferredSize().getHeight();
        this.label = new JLabel(rangeParam.getName() + ": ");
        if (textPosition == TextPosition.WEST) {
            this.add((Component)this.label, "West");
        } else if (textPosition == TextPosition.NORTH) {
            this.add((Component)this.label, "North");
        }
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.add((Component)this.slider, "Center");
        jPanel.add(this.spinner);
        if (bl) {
            this.defaultButton = new DefaultButton(this.resettableParam == null ? rangeParam : this.resettableParam);
            this.defaultButton.setPreferredSize(new Dimension(n, n));
            if (this.colorsUsed) {
                this.defaultButton.setBackground(Color.GRAY);
            }
            jPanel.add(this.defaultButton);
        }
        this.add((Component)jPanel, "East");
    }

    public void setupTicks() {
        int n;
        int n2;
        int n3 = this.model.getMaximum() - this.model.getMinimum();
        if (n3 == 100) {
            n2 = 0;
            n = 25;
        } else if (n3 >= 7) {
            n2 = (n3 + 1) / 8;
            n = 2 * n2;
        } else {
            n2 = 0;
            n = 1;
        }
        this.setupTicks(n, n2);
    }

    public void setupTicks(int n, int n2) {
        if (n > 0) {
            this.slider.setMajorTickSpacing(n);
        }
        if (n2 > 0) {
            this.slider.setMinorTickSpacing(n2);
        }
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
    }

    public void showTicksAsFloat() {
        this.slider.createStandardLabels(10);
        Dictionary dictionary = this.slider.getLabelTable();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            ((JLabel)dictionary.get(n)).setText(String.valueOf((float)n.intValue() / 100.0f));
        }
    }

    public int getCurrentValue() {
        return this.model.getValue();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.slider) {
            if (this.spinnerMoved) {
                return;
            }
            int n = this.slider.getValue();
            this.sliderMoved = true;
            this.spinner.setValue(n);
            this.sliderMoved = false;
        } else if (object == this.spinner) {
            if (this.sliderMoved) {
                return;
            }
            int n = (Integer)this.spinner.getValue();
            this.spinnerMoved = true;
            this.model.setValue(n);
            this.spinnerMoved = false;
        }
        if (this.defaultButton != null) {
            this.defaultButton.updateState();
        }
        if (this.colorsUsed) {
            if (this.model.isSetToDefault()) {
                this.defaultButton.setBackground(Color.GRAY);
            } else if (this.model.getValue() > this.model.getDefaultValue()) {
                this.defaultButton.setBackground(this.rightColor);
            } else {
                this.defaultButton.setBackground(this.leftColor);
            }
        }
    }

    public void resetToDefaultSettings() {
        this.model.reset(false);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public RangeParam getModel() {
        return this.model;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.spinner.setEnabled(bl);
        if (this.label != null) {
            this.label.setEnabled(bl);
        }
        if (this.defaultButton != null) {
            this.defaultButton.setEnabled(bl);
        }
    }

    public void setResettable(Resettable resettable) {
        this.resettableParam = resettable;
    }

    public static enum TextPosition {
        BORDER,
        WEST,
        NORTH,
        NONE;

    }
}

