/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.debug;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import pixelitor.utils.debug.ColorModelNode;
import pixelitor.utils.debug.DebugNode;
import pixelitor.utils.debug.RasterNode;

public class BufferedImageNode
extends DebugNode {
    public BufferedImageNode(BufferedImage bufferedImage) {
        this("BufferedImage", bufferedImage);
    }

    public BufferedImageNode(String string, BufferedImage bufferedImage) {
        super(string, bufferedImage);
        ColorModel colorModel = bufferedImage.getColorModel();
        this.add(new ColorModelNode(colorModel));
        WritableRaster writableRaster = bufferedImage.getRaster();
        this.add(new RasterNode(writableRaster));
        String string2 = BufferedImageNode.getTypeDescription(bufferedImage.getType());
        this.addStringChild("type", string2);
        int n = bufferedImage.getWidth();
        this.addIntChild("width", n);
        int n2 = bufferedImage.getHeight();
        this.addIntChild("height", n2);
        boolean bl = bufferedImage.isAlphaPremultiplied();
        this.addBooleanChild("alphaPremultiplied", bl);
    }

    private static String getTypeDescription(int n) {
        String string;
        switch (n) {
            case 5: {
                string = "TYPE_3BYTE_BGR";
                break;
            }
            case 6: {
                string = "TYPE_4BYTE_ABGR";
                break;
            }
            case 7: {
                string = "TYPE_4BYTE_ABGR_PRE";
                break;
            }
            case 12: {
                string = "TYPE_BYTE_BINARY";
                break;
            }
            case 10: {
                string = "TYPE_BYTE_GRAY";
                break;
            }
            case 13: {
                string = "TYPE_BYTE_INDEXED";
                break;
            }
            case 0: {
                string = "TYPE_CUSTOM";
                break;
            }
            case 2: {
                string = "TYPE_INT_ARGB";
                break;
            }
            case 3: {
                string = "TYPE_INT_ARGB_PRE";
                break;
            }
            case 4: {
                string = "TYPE_INT_BGR";
                break;
            }
            case 1: {
                string = "TYPE_INT_RGB";
                break;
            }
            case 9: {
                string = "TYPE_USHORT_555_RGB";
                break;
            }
            case 8: {
                string = "TYPE_USHORT_565_RGB";
                break;
            }
            case 11: {
                string = "TYPE_USHORT_GRAY";
                break;
            }
            default: {
                string = "unrecognized (program error)";
            }
        }
        return string;
    }
}

