/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.debug;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DebugNode
extends DefaultMutableTreeNode {
    private String name;

    DebugNode(String string, Object object) {
        super(object);
        this.name = string;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String toDetailedString() {
        if (this.userObject == null) {
            return this.name + " = null";
        }
        Enumeration<TreeNode> enumeration = this.children();
        StringBuilder stringBuilder = new StringBuilder();
        DebugNode.addIndent(stringBuilder, this.getLevel());
        stringBuilder.append(this.name).append(" {");
        while (enumeration.hasMoreElements()) {
            String string;
            TreeNode treeNode = enumeration.nextElement();
            DebugNode.addIndent(stringBuilder, this.getLevel() + 1);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
            if (defaultMutableTreeNode instanceof DebugNode) {
                DebugNode debugNode = (DebugNode)defaultMutableTreeNode;
                string = debugNode.toDetailedString();
            } else {
                string = defaultMutableTreeNode.toString();
            }
            stringBuilder.append(string);
        }
        DebugNode.addIndent(stringBuilder, this.getLevel());
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    void addStringChild(String string, String string2) {
        this.add(new DefaultMutableTreeNode(string + " = " + string2));
    }

    void addQuotedStringChild(String string, String string2) {
        this.add(new DefaultMutableTreeNode(string + " = \"" + string2 + '\"'));
    }

    void addIntChild(String string, int n) {
        this.add(new DefaultMutableTreeNode(string + " = " + n));
    }

    void addFloatChild(String string, float f) {
        this.add(new DefaultMutableTreeNode(string + " = " + f));
    }

    void addBooleanChild(String string, boolean bl) {
        this.add(new DefaultMutableTreeNode(string + " = " + bl));
    }

    void addClassChild() {
        this.add(new DefaultMutableTreeNode("class = " + this.userObject.getClass().getName()));
    }

    private static void addIndent(StringBuilder stringBuilder, int n) {
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }
}

