/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.test;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.layers.Layer;

public class PixelitorEvent
implements Comparable<PixelitorEvent> {
    private String description;
    private Date date;
    private Composition comp;
    private Layer layer;
    private static Format dateFormatter = new SimpleDateFormat("HH:mm:ss:SSS");

    public PixelitorEvent(String string) {
        assert (string != null);
        this.description = string;
        this.date = new Date();
        this.comp = AppLogic.getActiveComp();
        if (this.comp != null) {
            this.layer = this.comp.getActiveLayer();
        }
    }

    public Date getDate() {
        return this.date;
    }

    public String getMessage() {
        return this.description;
    }

    @Override
    public int compareTo(PixelitorEvent pixelitorEvent) {
        Date date = this.getDate();
        Date date2 = pixelitorEvent.getDate();
        return date.compareTo(date2);
    }

    public String toString() {
        return this.description + " on \"" + this.comp.getName() + "/" + this.layer.getName() + "\" at " + dateFormatter.format(this.date);
    }
}

