/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.test;

import java.awt.AWTException;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import pixelitor.AppLogic;
import pixelitor.Build;
import pixelitor.ChangeReason;
import pixelitor.Composition;
import pixelitor.ConsistencyChecks;
import pixelitor.ExceptionHandler;
import pixelitor.GlobalKeyboardWatch;
import pixelitor.ImageComponent;
import pixelitor.PixelitorWindow;
import pixelitor.filters.Brick;
import pixelitor.filters.Fade;
import pixelitor.filters.Filter;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.Invert;
import pixelitor.filters.comp.CompOperation;
import pixelitor.filters.comp.Flip;
import pixelitor.filters.comp.Rotate;
import pixelitor.history.History;
import pixelitor.layers.AddNewLayerAction;
import pixelitor.layers.AdjustmentLayer;
import pixelitor.layers.BlendingMode;
import pixelitor.layers.DeleteActiveLayerAction;
import pixelitor.layers.Layer;
import pixelitor.layers.Layers;
import pixelitor.layers.ShapeLayer;
import pixelitor.layers.TextLayer;
import pixelitor.menus.CopyAction;
import pixelitor.menus.CopyType;
import pixelitor.menus.PasteAction;
import pixelitor.menus.SelectionActions;
import pixelitor.menus.ShowHideAllAction;
import pixelitor.menus.ShowHideHistogramsAction;
import pixelitor.menus.ShowHideLayersAction;
import pixelitor.menus.ShowHideStatusBarAction;
import pixelitor.menus.ShowHideToolsAction;
import pixelitor.menus.ZoomLevel;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.tools.Tool;
import pixelitor.tools.ToolSettingsPanelContainer;
import pixelitor.tools.Tools;
import pixelitor.utils.AppPreferences;
import pixelitor.utils.GUIUtils;
import pixelitor.utils.test.DebugEventQueue;
import pixelitor.utils.test.ImageTests;
import pixelitor.utils.test.OpTests;
import pixelitor.utils.test.RobotEvent;

public class RobotTest {
    static final Random rand = new Random();
    private static Tool preferredTool = null;
    private static boolean singleImageTest = false;
    private static boolean noHideSHow = true;
    private static boolean continueRunning = true;
    private static int[] keyEvents = new int[]{49, 65, 10, 27, 8, 112, 113, 114, 115, 77, 86, 71, 66, 69, 73, 83, 81, 82, 68, 88, 72, 80, 66, 18, 9, 44, 36, 39};

    private RobotTest() {
    }

    public static void runRobot() throws AWTException {
        if (Build.CURRENT != Build.DEVELOPMENT) {
            ExceptionHandler.showErrorDialog("Error", "Build is not DEVELOPMENT");
            return;
        }
        Build.CURRENT.setRobotTest(true);
        final KeyStroke keyStroke = KeyStroke.getKeyStroke('u');
        GlobalKeyboardWatch.addKeyboardShortCut(keyStroke, "stoprobot", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("RobotTest: \"" + keyStroke + "\" Pressed");
                continueRunning = false;
            }
        });
        continueRunning = true;
        final KeyStroke keyStroke2 = KeyStroke.getKeyStroke('j');
        GlobalKeyboardWatch.addKeyboardShortCut(keyStroke2, "exit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("RobotTest: exiting app because \"" + keyStroke2 + "\" was pressed");
                System.exit(1);
            }
        });
        System.out.println("RobotTest.runRobot CALLED at " + new Date());
        final Robot robot = new Robot();
        Point point = RobotTest.generateRandomPoint();
        robot.mouseMove(point.x, point.y);
        RobotTest.log("initial splash");
        ImageTests.createSplashImage();
        RobotTest.randomCopy();
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                int n = 8000;
                int n2 = n / 100;
                for (int i = 0; i < n; ++i) {
                    if (i % n2 == 0) {
                        int n3 = 100 * i / n;
                        System.out.print(n3 + "% ");
                    }
                    if (!GUIUtils.appIsActive()) {
                        System.out.println("\nRobotTest app focus lost");
                        RobotTest.cleanUp();
                        break;
                    }
                    if (!continueRunning) {
                        System.out.println("\nStopped with \"" + keyStroke + "\"");
                        RobotTest.cleanUp();
                        break;
                    }
                    Point point = RobotTest.generateRandomPoint();
                    final int n4 = point.x;
                    final int n5 = point.y;
                    robot.delay(100 + rand.nextInt(400));
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RobotTest.executeRandomOp(n4, n5, robot);
                                if (AppLogic.getActiveComp() == null) {
                                    throw new IllegalStateException("no active composition");
                                }
                                ConsistencyChecks.checkAll();
                            }
                            catch (Exception exception) {
                                ExceptionHandler.showExceptionDialog(exception);
                            }
                        }
                    };
                    try {
                        EventQueue.invokeAndWait(runnable);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                System.out.println("\nRobotTest.runRobot FINISHED at " + new Date());
                RobotTest.cleanUp();
                Toolkit.getDefaultToolkit().beep();
                return null;
            }
        };
        swingWorker.execute();
    }

    private static Point generateRandomPoint() {
        Container container = PixelitorWindow.getInstance().getContentPane();
        Dimension dimension = container.getSize();
        Point point = container.getLocationOnScreen();
        int n = 5;
        int n2 = 5;
        int n3 = point.x + n;
        int n4 = point.y + n2;
        int n5 = point.x + dimension.width - 2 * n3;
        int n6 = point.y + dimension.height - 2 * n4;
        Point point2 = new Point(n3 + rand.nextInt(n5), n4 + rand.nextInt(n6));
        return point2;
    }

    private static void cleanUp() {
        AppPreferences.WorkSpace.setDefault();
        Build.CURRENT.setRobotTest(false);
    }

    private static void executeRandomOp(int n, int n2, Robot robot) {
        int n3 = rand.nextInt(40);
        switch (n3) {
            case 0: 
            case 1: 
            case 2: {
                RobotTest.randomMove(robot, n, n2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                RobotTest.randomDrag(robot, n, n2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                RobotTest.randomClick(robot);
                break;
            }
            case 13: {
                RobotTest.randomResize();
                break;
            }
            case 14: {
                RobotTest.repeat();
                break;
            }
            case 15: {
                RobotTest.undo();
                break;
            }
            case 16: {
                RobotTest.redo();
                break;
            }
            case 17: {
                RobotTest.crop();
                break;
            }
            case 18: {
                RobotTest.fade();
                break;
            }
            case 19: {
                RobotTest.randomizeToolSettings();
                break;
            }
            case 20: {
                RobotTest.arrangeWindows();
                break;
            }
            case 21: {
                RobotTest.randomColors();
                break;
            }
            case 22: {
                RobotTest.randomOperation();
                break;
            }
            case 23: {
                RobotTest.randomKey(robot);
                break;
            }
            case 24: {
                RobotTest.randomZoom(rand);
                break;
            }
            case 25: {
                RobotTest.randomDeselect();
                break;
            }
            case 26: {
                RobotTest.layerToCanvasSize();
                break;
            }
            case 27: {
                RobotTest.invertSelection();
                break;
            }
            case 28: {
                RobotTest.traceWithCurrentBrush();
                break;
            }
            case 29: {
                RobotTest.traceWithCurrentEraser();
                break;
            }
            case 30: {
                RobotTest.randomRotateFlip();
                break;
            }
            case 31: {
                RobotTest.layerOrderChange();
                break;
            }
            case 32: {
                RobotTest.layerMerge();
                break;
            }
            case 33: {
                RobotTest.layerAddDelete();
                break;
            }
            case 34: {
                RobotTest.randomHideShow();
                break;
            }
            case 35: {
                RobotTest.randomCopy();
                break;
            }
            case 36: {
                RobotTest.randomPaste();
                break;
            }
            case 37: {
                RobotTest.randomChangeLayerOpacityOrBlending();
                break;
            }
            case 38: {
                RobotTest.randomChangeLayerVisibility();
                break;
            }
            case 39: {
                RobotTest.randomTool();
                break;
            }
            case 40: {
                RobotTest.randomCloseImageWOSaving();
                break;
            }
            case 41: {
                RobotTest.randomLoadImage();
                break;
            }
            case 42: {
                RobotTest.randomSaveInAllFormats();
                break;
            }
            case 43: {
                RobotTest.randomException();
                break;
            }
            case 44: {
                RobotTest.randomSpecialLayer();
                break;
            }
            case 45: {
                RobotTest.randomLayerMask();
            }
        }
    }

    private static void randomResize() {
        if (Math.random() > 0.7) {
            RobotTest.log("random resize");
            OpTests.randomResize();
        }
    }

    private static void log(String string) {
        DebugEventQueue.post(new RobotEvent(string));
    }

    private static void randomMove(Robot robot, int n, int n2) {
        RobotTest.log("random move to (" + n + ", " + n2 + ')');
        robot.mouseMove(n, n2);
    }

    private static void randomDrag(Robot robot, int n, int n2) {
        RobotTest.log("random \"" + Tools.getCurrentTool().getName() + " Tool\" drag to (" + n + ", " + n2 + ')');
        robot.mousePress(16);
        robot.mouseMove(n, n2);
        robot.mouseRelease(16);
    }

    private static void randomClick(Robot robot) {
        RobotTest.log("random click");
        robot.mousePress(16);
        robot.delay(50);
        robot.mouseRelease(16);
    }

    private static void randomColors() {
        RobotTest.log("random colors");
        FgBgColorSelector.setRandomColors();
    }

    private static void randomOperation() {
        if (!Layers.activeIsImageLayer()) {
            return;
        }
        int n = rand.nextInt(10);
        if (n < 6) {
            return;
        }
        Filter filter = FilterUtils.getRandomFilter();
        if (filter instanceof Fade) {
            return;
        }
        if (filter instanceof Brick) {
            return;
        }
        RobotTest.log("random operation: " + filter.getName());
        filter.randomizeSettings();
        filter.execute(ChangeReason.OP_WITHOUT_DIALOG);
    }

    private static void randomKey(Robot robot) {
        int n = rand.nextInt(keyEvents.length);
        int n2 = keyEvents[n];
        RobotTest.log("random key keyEvent = " + n2);
        robot.keyPress(n2);
        robot.delay(50);
        robot.keyRelease(n2);
    }

    private static void randomZoom(Random random) {
        ImageComponent imageComponent = AppLogic.getActiveImageComponent();
        if (imageComponent != null) {
            ZoomLevel zoomLevel = ZoomLevel.getRandomZoomLevel(random);
            RobotTest.log("random zoom zoomLevel = " + (Object)((Object)zoomLevel));
            imageComponent.setZoom(zoomLevel, true);
        }
    }

    private static void repeat() {
        if (rand.nextInt(10) > 5) {
            RobotTest.log("repeat");
            PixelitorWindow pixelitorWindow = PixelitorWindow.getInstance();
            pixelitorWindow.dispatchEvent(new KeyEvent(pixelitorWindow, 401, System.currentTimeMillis(), 2, 70, 'F'));
        }
    }

    private static void undo() {
        if (History.canUndo()) {
            RobotTest.log("undo");
            History.undo();
        }
    }

    private static void redo() {
        if (History.canRedo()) {
            RobotTest.log("redo");
            History.redo();
        }
    }

    private static void crop() {
        boolean bl = SelectionActions.areEnabled();
        if (bl) {
            RobotTest.log("crop");
            SelectionActions.getCropAction().actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void fade() {
        boolean bl = History.canFade();
        if (!bl) {
            return;
        }
        RobotTest.log("fade");
        Fade fade = new Fade();
        fade.setOpacity(rand.nextInt(100));
        fade.execute(ChangeReason.OP_WITHOUT_DIALOG);
    }

    private static void randomizeToolSettings() {
        RobotTest.log("randomize tool settings");
        ToolSettingsPanelContainer.INSTANCE.randomizeToolSettings();
    }

    private static void arrangeWindows() {
        double d = Math.random();
        if (d > 0.8) {
            RobotTest.log("arrange windows - tile");
            PixelitorWindow.getInstance().tileWindows();
        } else if (d > 0.7) {
            RobotTest.log("arrange windows - cascade");
            PixelitorWindow.getInstance().cascadeWindows();
        }
    }

    private static void randomDeselect() {
        if (SelectionActions.areEnabled()) {
            RobotTest.log("deselect");
            SelectionActions.getDeselectAction().actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void layerToCanvasSize() {
        if (rand.nextInt(4) == 2) {
            RobotTest.log("layer to canvas size");
            AppLogic.getActiveComp().layerToCanvasSize();
        }
    }

    private static void invertSelection() {
        if (SelectionActions.areEnabled()) {
            RobotTest.log("invert selection");
            SelectionActions.getInvertSelectionAction().actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void traceWithCurrentBrush() {
        if (SelectionActions.areEnabled()) {
            RobotTest.log("trace with current brush");
            SelectionActions.getTraceWithBrush().actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void traceWithCurrentEraser() {
        if (SelectionActions.areEnabled()) {
            RobotTest.log("trace with current easer");
            SelectionActions.getTraceWithEraser().actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void randomRotateFlip() {
        int n = rand.nextInt(5);
        CompOperation compOperation = null;
        switch (n) {
            case 0: {
                RobotTest.log("roate 90 CW");
                compOperation = new Rotate(90, "Rotate 90\u00b0 CW");
                break;
            }
            case 1: {
                RobotTest.log("roate 180");
                compOperation = new Rotate(180, "Rotate 180\u00b0");
                break;
            }
            case 2: {
                RobotTest.log("roate 90 CCW");
                compOperation = new Rotate(270, "Rotate 90\u00b0 CCW");
                break;
            }
            case 3: {
                RobotTest.log("flip horizontal");
                compOperation = Flip.createFlipOp(Flip.Direction.HORIZONTAL);
                break;
            }
            case 4: {
                RobotTest.log("flip vertical");
                compOperation = Flip.createFlipOp(Flip.Direction.VERTICAL);
            }
        }
        compOperation.actionPerformed(new ActionEvent("", 0, ""));
    }

    private static void layerOrderChange() {
        Composition composition = AppLogic.getActiveComp();
        int n = rand.nextInt(6);
        switch (n) {
            case 0: {
                RobotTest.log("layer order change: active to top");
                composition.moveActiveLayerToTop();
                break;
            }
            case 1: {
                RobotTest.log("layer order change: active to bottom");
                composition.moveActiveLayerToBottom();
                break;
            }
            case 2: {
                RobotTest.log("layer order change: selection up");
                composition.moveLayerSelectionUp();
                break;
            }
            case 3: {
                RobotTest.log("layer order change: selection down");
                composition.moveLayerSelectionDown();
                break;
            }
            case 4: {
                RobotTest.log("layer order change: active up");
                composition.moveActiveLayerUp();
                break;
            }
            case 5: {
                RobotTest.log("layer order change: active down");
                composition.moveActiveLayerDown();
            }
        }
    }

    private static void layerMerge() {
        Composition composition = AppLogic.getActiveComp();
        if (rand.nextBoolean()) {
            RobotTest.log("layer merge down");
            composition.mergeDown();
        } else {
            RobotTest.log("layer flatten image");
            composition.flattenImage();
        }
    }

    private static void layerAddDelete() {
        if (rand.nextBoolean()) {
            if (AddNewLayerAction.INSTANCE.isEnabled()) {
                RobotTest.log("add new layer");
                AddNewLayerAction.INSTANCE.actionPerformed(new ActionEvent("", 0, ""));
            }
        } else if (DeleteActiveLayerAction.INSTANCE.isEnabled()) {
            RobotTest.log("delete active layer");
            DeleteActiveLayerAction.INSTANCE.actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void randomHideShow() {
        if (noHideSHow) {
            return;
        }
        int n = rand.nextInt(5);
        if (n == 0) {
            RobotTest.log("random show-hide histograms");
            new ShowHideHistogramsAction().actionPerformed(new ActionEvent("", 0, ""));
        } else if (n == 1) {
            RobotTest.log("random show-hide layers");
            new ShowHideLayersAction().actionPerformed(new ActionEvent("", 0, ""));
        } else if (n == 2) {
            RobotTest.log("random show-hide tools");
            new ShowHideToolsAction().actionPerformed(new ActionEvent("", 0, ""));
        } else if (n == 4) {
            RobotTest.log("random show-hide statusbar");
            new ShowHideStatusBarAction().actionPerformed(new ActionEvent("", 0, ""));
        } else if (n == 5) {
            RobotTest.log("random show-hide all");
            ShowHideAllAction.INSTANCE.actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void randomCopy() {
        if (rand.nextBoolean()) {
            RobotTest.log("random copy layer");
            new CopyAction(CopyType.COPY_LAYER).actionPerformed(new ActionEvent("", 0, ""));
        } else {
            RobotTest.log("random copy composite");
            new CopyAction(CopyType.COPY_COMPOSITE).actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void randomPaste() {
        int n = rand.nextInt(10);
        if (n == 0) {
            if (singleImageTest) {
                return;
            }
            RobotTest.log("random paste as new image");
            new PasteAction(false).actionPerformed(new ActionEvent("", 0, ""));
        } else if (n == 1) {
            RobotTest.log("random paste as new layer");
            new PasteAction(true).actionPerformed(new ActionEvent("", 0, ""));
        }
    }

    private static void randomChangeLayerOpacityOrBlending() {
        Layer layer = AppLogic.getActiveLayer();
        if (rand.nextBoolean()) {
            float f = layer.getOpacity();
            float f2 = rand.nextFloat();
            if (f2 > f) {
                RobotTest.log("random increase opacity");
                layer.setOpacity(f2, true, true);
            } else if ((double)rand.nextFloat() > 0.75) {
                RobotTest.log("random decrease opacity");
                layer.setOpacity(f2, true, true);
            }
        } else {
            RobotTest.log("random change layer blending mode");
            BlendingMode[] blendingModeArray = BlendingMode.values();
            BlendingMode blendingMode = blendingModeArray[rand.nextInt(blendingModeArray.length)];
            layer.setBlendingMode(blendingMode, true, true);
        }
    }

    private static void randomChangeLayerVisibility() {
        Layer layer = AppLogic.getActiveLayer();
        boolean bl = layer.isVisible();
        if (rand.nextBoolean()) {
            if (!bl) {
                RobotTest.log("random showing layer");
                layer.setVisible(true, true);
            }
        } else if (bl && (double)rand.nextFloat() > 0.8) {
            RobotTest.log("random hiding layer");
            layer.setVisible(false, true);
        }
    }

    private static void randomTool() {
        Tool tool = null;
        tool = preferredTool != null ? preferredTool : Tools.getRandomTool(rand);
        if (Tools.getCurrentTool() != tool) {
            tool.getButton().doClick();
        }
    }

    private static void randomCloseImageWOSaving() {
        if (singleImageTest) {
            return;
        }
    }

    private static void randomSaveInAllFormats() {
    }

    private static void randomLoadImage() {
        if (singleImageTest) {
            return;
        }
    }

    private static void randomException() {
    }

    private static void randomSpecialLayer() {
        int n = rand.nextInt(3);
        Composition composition = AppLogic.getActiveComp();
        Layer layer = null;
        if (n == 0) {
            RobotTest.log("random text layer");
            String string = "text layer";
            String string2 = "text layer text";
            layer = new TextLayer(composition, string, string2);
        } else if (n == 1) {
            RobotTest.log("random shape layer");
            String string = "shape layer";
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(10.0f, 10.0f, 100.0f, 100.0f, 20.0f, 20.0f);
            layer = new ShapeLayer(composition, string, float_);
        } else if (n == 2) {
            RobotTest.log("random adjustment layer");
            layer = new AdjustmentLayer(composition, "invert adjustment", new Invert());
        }
        composition.addLayer(layer, true, true, false);
    }

    private static void randomLayerMask() {
        RobotTest.log("random layer mask");
        AppLogic.getActiveComp().getActiveLayer().addTestLayerMask();
    }
}

