/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.util.Logger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NEFCompressionData {
    private static final String CLASS = NEFCompressionData.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    @Nonnull
    private final NikonMakerNote3 makerNote;
    @Nonnull
    private final ShortBuffer shortBuffer;
    @Nonnull
    private final int[] lut;
    private final int version;
    private final int[] vPredictor;

    public NEFCompressionData(@Nonnull NikonMakerNote3 makerNote) {
        logger.fine("NEFCompressionData()", new Object[0]);
        this.makerNote = makerNote;
        ByteBuffer byteBuffer = ByteBuffer.wrap(makerNote.getCompressionData());
        ShortBuffer tempShortBuffer = byteBuffer.asShortBuffer();
        this.version = tempShortBuffer.get(0);
        short endiannessMarker = tempShortBuffer.get(1);
        ByteOrder order = endiannessMarker == 18433 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byteBuffer.order(order);
        this.shortBuffer = byteBuffer.asShortBuffer();
        logger.finest(">>>> version:           0x%04x", this.version);
        logger.finest(">>>> endianness marker: 0x%04x", endiannessMarker);
        logger.finest(">>>> endianness:        %s", order);
        this.shortBuffer.position(1);
        this.vPredictor = new int[4];
        for (int i = 0; i < this.vPredictor.length; ++i) {
            this.vPredictor[i] = this.shortBuffer.get();
        }
        this.shortBuffer.position(5);
        int lutSize = this.shortBuffer.get();
        logger.finer(">>>> samples: %d", lutSize);
        if ((this.version & 0xFF00) == 17920) {
            logger.finer(">>>> using linear table", new Object[0]);
            lutSize = 16384;
            this.lut = new int[lutSize];
            for (int i = 0; i < lutSize; ++i) {
                this.lut[i] = i;
            }
        } else {
            logger.finer(">>>> using sampled table", new Object[0]);
            this.lut = new int[lutSize];
            for (int i = 0; i < lutSize; ++i) {
                this.lut[i] = this.shortBuffer.get() & 0xFFFF;
            }
        }
        logger.finer(this.toString(), new Object[0]);
    }

    @Nonnull
    public int getVersion() {
        return this.version;
    }

    @Nonnull
    public int[] getVPredictor() {
        return (int[])this.vPredictor.clone();
    }

    @Nonnull
    public int[] getValues() {
        return this.lut;
    }

    @Nonnull
    public int[] getExpandedValues(@Nonnegative int bitsPerSample) {
        logger.fine("getExpandedValues(%d)", bitsPerSample);
        int[] values = new int[65536];
        int max = 1 << bitsPerSample;
        int step = max / (this.lut.length - 1);
        logger.finer(">>>> version: %04x samples: %d step: %d", this.version, this.lut.length, step);
        if (this.version == 17440 && step > 0) {
            int i;
            logger.finer(">>>> returning interpolated and padded values", new Object[0]);
            for (i = 0; i < this.lut.length; ++i) {
                values[i * step] = this.lut[i];
            }
            for (i = 0; i < max; ++i) {
                values[i] = (values[i - i % step] * (step - i % step) + values[i - i % step + step] * (i % step)) / step;
            }
            for (i = max; i < values.length; ++i) {
                values[i] = values[max - 1];
            }
        } else {
            int i;
            logger.finer(">>>> returning padded values", new Object[0]);
            for (i = 0; i < this.lut.length; ++i) {
                values[i] = this.lut[i];
            }
            for (i = this.lut.length; i < values.length; ++i) {
                values[i] = values[this.lut.length - 1];
            }
        }
        return values;
    }

    @Nonnegative
    public int getWhiteLevel() {
        return this.lut[this.lut.length - 1];
    }

    @Nonnull
    public String toString() {
        return String.format("NEFCompressionData[version: 0x%04x, size: %d, whiteLevel: %d]", this.version, this.lut.length, this.getWhiteLevel());
    }
}

