/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.CurveOperation;
import it.tidalwave.imageio.util.Logger;
import javax.annotation.Nonnull;

public class NEFCurveOperation
extends CurveOperation {
    private static final Logger logger = NEFCurveOperation.getLogger(NEFCurveOperation.class);

    protected double getWhiteLevel(@Nonnull PipelineArtifact artifact) {
        double whiteLevel;
        logger.fine("getWhiteLevel()", new Object[0]);
        NEFMetadata metadata = (NEFMetadata)artifact.getRAWMetadata();
        NikonMakerNote3 makerNote = metadata.getNikonMakerNote();
        if (makerNote.isCompressionDataAvailable()) {
            whiteLevel = makerNote.getCompressionDataObject().getWhiteLevel();
            logger.finer(">>>> whiteLevel from linearizationTable: %s", whiteLevel);
        } else {
            whiteLevel = super.getWhiteLevel(artifact);
        }
        return whiteLevel;
    }
}

