/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import jdomain.jdraw.action.BlockingDrawAction;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.RotateDialog;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawPixel;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.jdraw.gui.undo.Undoable;
import jdomain.util.Log;

public final class RotateAction
extends BlockingDrawAction {
    private static final long serialVersionUID = 1L;
    private Double angle;

    protected RotateAction() {
        super("Rotate...");
        this.setToolTipText("Rotates this frame");
    }

    public boolean prepareAction() {
        RotateDialog rotateDialog = new RotateDialog();
        rotateDialog.open();
        if (rotateDialog.getResult() == 1) {
            this.angle = rotateDialog.getRotationAngle();
            return this.angle != null;
        }
        return false;
    }

    public void startAction() {
        Image image = FolderPanel.INSTANCE.createOffScreenImage();
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        AffineTransform affineTransform = graphics2D.getTransform();
        affineTransform.setToIdentity();
        int n = Tool.getPictureWidth();
        int n2 = Tool.getPictureHeight();
        affineTransform.rotate(this.angle, n / 2, n2 / 2);
        graphics2D.drawImage(image, affineTransform, new JPanel());
        graphics2D.getTransform().setToIdentity();
        DrawPixel drawPixel = Undoable.calculateDifference(Tool.getCurrentFrame(), image, 0, 0, n, n2);
        if (drawPixel.isValid()) {
            UndoManager.INSTANCE.addUndoable(drawPixel);
            drawPixel.redo();
        }
    }

    public void finishAction() {
        Log.info("Frame rotated.");
    }
}

