/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.data;

import java.awt.Rectangle;
import java.util.Arrays;
import jdomain.jdraw.data.DataObject;
import jdomain.jdraw.data.Pixel;
import jdomain.jdraw.data.event.ChangeEvent;

public class Clip
extends DataObject {
    protected int transColour = -1;
    private static final long serialVersionUID = 0L;
    protected int[][] data;

    public Clip(int n, int n2, int n3) {
        this.data = new int[n2][n];
        this.fill(n3);
    }

    public Clip(int[][] nArray) {
        this.data = nArray;
    }

    public final int getTransparentColour() {
        return this.transColour;
    }

    public final boolean usesTransparency() {
        return this.transColour != -1;
    }

    public void setTransparent(int n) {
        this.transColour = n;
    }

    protected final void setTransparentColourQuiet(int n) {
        this.transColour = n;
    }

    public final void fill(int n) {
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            Arrays.fill(this.data[i], n);
        }
    }

    public final void rotate() {
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = n - 1;
        int[][] nArray = new int[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[j][n3 - i] = this.getPixel(j, i);
            }
        }
        this.data = nArray;
    }

    public final void flipVertically() {
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = n2 - 1;
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[i][n3 - j] = this.getPixel(j, i);
            }
        }
        this.data = nArray;
    }

    public final void flipHorizontally() {
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = n - 1;
        int[][] nArray = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[n3 - i][j] = this.getPixel(j, i);
            }
        }
        this.data = nArray;
    }

    public void setPixels(Pixel[] pixelArray) {
        this.setPixels(pixelArray, false);
    }

    public void restorePixels(Pixel[] pixelArray) {
        this.setPixels(pixelArray, true);
    }

    private void setPixels(Pixel[] pixelArray, boolean bl) {
        int n = pixelArray.length;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                Pixel pixel = pixelArray[i];
                this.setPixelQuiet(pixel.x, pixel.y, pixel.oldColour);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Pixel pixel = pixelArray[i];
                this.setPixelQuiet(pixel.x, pixel.y, pixel.newColour);
            }
        }
        this.notifyDataListeners(new ChangeEvent(this, 10));
    }

    public void pasteClip(Clip clip, int n, int n2) {
        int n3 = Math.max(0, n);
        int n4 = Math.max(0, n2);
        int n5 = Math.min(n + clip.getWidth() - 1, this.getWidth() - 1);
        int n6 = Math.min(n2 + clip.getHeight() - 1, this.getHeight() - 1);
        for (int i = n4; i <= n6; ++i) {
            for (int j = n3; j <= n5; ++j) {
                int n7 = clip.getPixel(j - n, i - n2);
                if (n7 == this.transColour) continue;
                this.setPixelQuiet(j, i, n7);
            }
        }
        this.notifyDataListeners(new ChangeEvent(this, 0));
    }

    public void setPixelQuiet(int n, int n2, int n3) {
        this.data[n2][n] = n3;
    }

    public void setPixel(int n, int n2, int n3) {
        if (this.data[n2][n] != n3) {
            this.data[n2][n] = n3;
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 1, n, n2, n3));
        }
    }

    public final Rectangle getBounds() {
        return new Rectangle(0, 0, this.getWidth(), this.getHeight());
    }

    public final int getWidth() {
        return this.data[0].length;
    }

    public final int getHeight() {
        return this.data.length;
    }

    public final int getPixel(int n, int n2) {
        return this.data[n2][n];
    }
}

