/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.data;

import java.awt.Color;
import java.io.Serializable;
import jdomain.jdraw.data.DataObject;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.util.Log;

public final class ColourEntry
extends DataObject
implements Serializable,
Comparable {
    private static final long serialVersionUID = 0L;
    public static final int ALPHA_MASK = 192;
    public static final int RED_MASK = 48;
    public static final int GREEN_MASK = 12;
    public static final int BLUE_MASK = 3;
    public static final int MAX_VALUE = 255;
    public static final int TRANSPARENT = 0;
    public static final int OPAQUE = 255;
    private Color colour;
    private int index;
    private boolean isTransparent = false;
    private int r;
    private int g;
    private int b;
    private int a;
    private transient int used = 0;

    public ColourEntry(Color color, int n) {
        this.index = n;
        this.isTransparent = false;
        this.setColour(color);
    }

    public Color getColour() {
        return this.colour;
    }

    public Color getOpaqueColour() {
        if (this.a == 255) {
            return this.colour;
        }
        return new Color(this.r, this.g, this.b);
    }

    public ColourEntry copy() {
        ColourEntry colourEntry = new ColourEntry(this.colour, this.index);
        return colourEntry;
    }

    public void removeAlpha() {
        String string = this.getColourString();
        this.setColour(new Color(this.r, this.g, this.b));
        String string2 = this.getColourString();
        this.notifyDataListeners(new ChangeEvent((DataObject)this, 42, string, string2));
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isOpaque() {
        return !this.isTransparent && this.colour.getAlpha() == 255;
    }

    public int getRed() {
        return this.colour.getRed();
    }

    public int getGreen() {
        return this.colour.getGreen();
    }

    public int getBlue() {
        return this.colour.getBlue();
    }

    public int getAlpha() {
        if (this.isTransparent) {
            return 0;
        }
        return this.a;
    }

    public boolean isSimilar(ColourEntry colourEntry, int n) {
        int n2 = Math.abs(this.r - colourEntry.r);
        int n3 = Math.abs(this.g - colourEntry.g);
        int n4 = Math.abs(this.b - colourEntry.b);
        int n5 = Math.abs(this.getAlpha() - colourEntry.getAlpha());
        return n2 <= n && n3 <= n && n4 <= n && n5 <= n;
    }

    protected void setIndexQuiet(int n) {
        this.index = n;
    }

    public void setIndex(int n) {
        if (this.index == n) {
            return;
        }
        int n2 = this.index;
        this.index = n;
        if (this.index == -1) {
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 41, n2, this.index));
        } else {
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 40, n2, this.index));
        }
    }

    public int getUsedCount() {
        return this.used;
    }

    public void dispose() {
        this.setIndex(-1);
    }

    public void decreaseIndex() {
        this.setIndex(this.index - 1);
    }

    public boolean isUsed() {
        return this.used > 0;
    }

    public void increaseUsed() {
        if (this.isValid()) {
            ++this.used;
        }
    }

    public void addUsed(int n) {
        this.used += n;
    }

    public void reset() {
        if (this.isValid()) {
            this.used = 0;
        }
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    protected void setTransparency(boolean bl) {
        if (bl != this.isTransparent) {
            String string = this.getColourString();
            this.isTransparent = bl;
            this.setColour(new Color(this.r, this.g, this.b));
            String string2 = this.getColourString();
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 42, string, string2));
        }
    }

    protected void setColour(Color color) {
        this.r = color.getRed();
        this.g = color.getGreen();
        this.b = color.getBlue();
        this.a = this.isTransparent ? 255 : color.getAlpha();
        this.colour = new Color(this.r, this.g, this.b, this.a);
        if (this.isTransparent && color.getAlpha() != 255) {
            Log.warning("The alpha value of the palette's transparent colour mustn't be changed.\n\n<font color=blue><b>Hint</b></font>: Ctrl-left-click this colour to remove its transparent colour status. The alpha value can then be modified.");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Color) {
            return this.colour.equals(object);
        }
        if (!(object instanceof ColourEntry)) {
            return false;
        }
        ColourEntry colourEntry = (ColourEntry)object;
        return this.hashCode() == colourEntry.hashCode();
    }

    protected int sum() {
        return this.r + this.g + this.b + this.a;
    }

    public int compareTo(Object object) {
        ColourEntry colourEntry = (ColourEntry)object;
        if (this.a != colourEntry.a) {
            if (this.a > colourEntry.a) {
                return 1;
            }
            return -1;
        }
        float[] fArray = Color.RGBtoHSB(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(colourEntry.colour.getRed(), colourEntry.colour.getGreen(), colourEntry.colour.getBlue(), null);
        for (int i = 0; i < 3; ++i) {
            if (fArray[i] < fArray2[i]) {
                return -1;
            }
            if (!(fArray[i] > fArray2[i])) continue;
            return 1;
        }
        if (this.index == colourEntry.index) {
            return 0;
        }
        if (this.index < colourEntry.index) {
            return -1;
        }
        return 1;
    }

    private String hashString() {
        float[] fArray = Color.RGBtoHSB(this.r, this.g, this.b, null);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            stringBuffer.append(fArray[i]);
            stringBuffer.append('.');
        }
        stringBuffer.append(this.a);
        return stringBuffer.toString();
    }

    protected final String getColourString() {
        return ColourEntry.getColourString(this.r, this.g, this.b, this.isTransparent ? 0 : this.a);
    }

    protected static final String getColourString(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append('.');
        stringBuffer.append(n2);
        stringBuffer.append('.');
        stringBuffer.append(n3);
        stringBuffer.append('.');
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        stringBuffer.append(String.valueOf(this.index));
        stringBuffer.append(":[");
        stringBuffer.append(this.r);
        stringBuffer.append(",");
        stringBuffer.append(this.g);
        stringBuffer.append(",");
        stringBuffer.append(this.b);
        stringBuffer.append(",");
        stringBuffer.append(this.a);
        stringBuffer.append("]");
        if (this.isTransparent) {
            stringBuffer.append(" (transparent)");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = this.hashString().hashCode();
        if (this.isTransparent) {
            n += 1000;
        }
        return n += this.index;
    }

    public void invalidate() {
        if (Log.DEBUG) {
            Log.debug("invalidated colour #" + this.index);
        }
        this.used = -1;
    }

    public boolean isValid() {
        return this.used >= 0;
    }
}

