/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.data;

import java.io.Serializable;
import jdomain.jdraw.data.ColourEntry;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.util.Log;

public final class ColourSettings
implements Serializable {
    private static final long serialVersionUID = 0L;
    public final ColourEntry foreground;
    public final ColourEntry background;
    public final ColourEntry transparent;
    public final ColourEntry pictureBackground;
    public final Picture picture;

    public ColourSettings(Picture picture) {
        this.picture = picture;
        Palette palette = this.picture.getCurrentPalette();
        this.foreground = palette.getColour(this.picture.getForeground());
        this.background = palette.getColour(this.picture.getBackground());
        this.pictureBackground = palette.getColour(this.picture.getPictureBackground());
        int n = this.picture.getTransparent();
        this.transparent = n == -1 ? null : palette.getColour(n);
    }

    public void restore() {
        Palette palette;
        int n;
        if (Log.DEBUG) {
            Log.debug(">>> restoring colour settings");
        }
        if ((n = (palette = this.picture.getCurrentPalette()).indexOf(this.foreground)) == -1) {
            n = 1;
        }
        this.picture.setForeground(n);
        n = palette.indexOf(this.background);
        if (n == -1) {
            n = 0;
        }
        this.picture.setBackground(n);
        n = palette.indexOf(this.pictureBackground);
        if (n == -1) {
            n = 0;
        }
        this.picture.setPictureBackground(n);
        int n2 = this.picture.getTransparent();
        n = -1;
        if (this.transparent != null) {
            n = this.transparent.getIndex();
        }
        if (n2 != n) {
            if (n2 == -1) {
                this.picture.setTransparent(-1);
            } else if (n == -1) {
                this.picture.setTransparent(n2);
            } else {
                this.picture.setTransparent(n);
            }
        }
        if (Log.DEBUG) {
            Log.debug("After restoring:");
            Log.debug(this.toString(palette.getColour(this.picture.getForeground()), palette.getColour(this.picture.getBackground()), palette.getColour(this.picture.getPictureBackground()), this.picture.getTransparent() == -1 ? null : palette.getColour(this.picture.getTransparent())));
        }
    }

    private String toString(ColourEntry colourEntry, ColourEntry colourEntry2, ColourEntry colourEntry3, ColourEntry colourEntry4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nforeground:         ");
        stringBuffer.append(colourEntry);
        stringBuffer.append("\nbackground:         ");
        stringBuffer.append(colourEntry2);
        stringBuffer.append("\ntransparent:        ");
        stringBuffer.append(colourEntry4 == null ? "none" : colourEntry4.toString());
        stringBuffer.append("\npicture background: ");
        stringBuffer.append(colourEntry3);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(this.foreground, this.background, this.pictureBackground, this.transparent);
    }
}

