/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.data;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import jdomain.jdraw.data.ColourEntry;
import jdomain.jdraw.data.DataChangeListener;
import jdomain.jdraw.data.DataObject;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.util.Assert;
import jdomain.util.Log;

public final class Palette
extends DataObject
implements DataChangeListener {
    private static final long serialVersionUID = 0L;
    public static final int GIF_MAX_COLOURS = 256;
    public static final int MAX_RGB_VALUE = 255;
    private boolean sorting = false;
    private final ColourList colours = new ColourList();
    private final Picture picture;
    private final HashMap colourMap = new HashMap(256);

    public Palette(Picture picture) {
        this.picture = picture;
    }

    public static Palette createDefaultPalette(Picture picture) {
        int n;
        Palette palette = new Palette(picture);
        for (int i = 0; i < 8; ++i) {
            palette.addQuiet(Color.black);
        }
        int n2 = 255;
        for (n = 0; n < 8; ++n) {
            palette.addQuiet(new Color(n2, 0, 0));
            n2 += -26;
        }
        n2 = 255;
        for (n = 0; n < 8; ++n) {
            palette.addQuiet(new Color(0, n2, 0));
            n2 += -26;
        }
        n2 = 255;
        for (n = 0; n < 8; ++n) {
            palette.addQuiet(new Color(0, 0, n2));
            n2 += -26;
        }
        n2 = 255;
        for (n = 0; n < 8; ++n) {
            palette.addQuiet(new Color(0, n2, n2));
            n2 += -26;
        }
        n2 = 255;
        for (n = 0; n < 8; ++n) {
            palette.addQuiet(new Color(n2, n2, 0));
            n2 += -26;
        }
        n2 = 255;
        for (n = 0; n < 8; ++n) {
            palette.addQuiet(new Color(n2, n2 / 2, 0));
            n2 += -26;
        }
        n2 = 255;
        for (n = 0; n < 8; ++n) {
            palette.addQuiet(new Color(n2, 0, n2));
            n2 += -26;
        }
        n2 = 255;
        for (n = 0; n < 8; ++n) {
            palette.addQuiet(new Color(n2, n2, n2));
            n2 += -26;
        }
        palette.addQuiet(new Color(254, 128, 17));
        palette.addQuiet(new Color(255, 161, 85));
        palette.addQuiet(new Color(255, 225, 165));
        palette.addQuiet(new Color(49, 83, 183));
        palette.addQuiet(new Color(0, 146, 255));
        return palette;
    }

    public int countTransparentColours() {
        int n = this.size();
        int n2 = 0;
        if (this.picture.getTransparent() != -1) {
            ++n2;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getColour(i).getColour().getAlpha() == 255) continue;
            ++n2;
        }
        return n2;
    }

    public int getLastTransparentColour() {
        int n = this.size();
        int n2 = this.picture.getTransparent();
        for (int i = n - 1; i >= 0; --i) {
            if (i == n2) {
                return n2;
            }
            Color color = this.getColour(i).getColour();
            if (color.getAlpha() == 255) continue;
            return i;
        }
        return -1;
    }

    public void addColour(Color color) {
        ColourEntry colourEntry = this.addQuiet(color);
        this.notifyDataListeners(new ChangeEvent((DataObject)this, 22, null, colourEntry));
    }

    public ColourEntry addQuiet(Color color) {
        ColourEntry colourEntry = new ColourEntry(color, this.size());
        this.colours.add(colourEntry);
        return colourEntry;
    }

    public void removeAlphaValues() {
        Palette.surpressGUIEvents(this.picture);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ColourEntry colourEntry = this.getColour(i);
            if (colourEntry.isTransparent() || colourEntry.isOpaque()) continue;
            colourEntry.removeAlpha();
        }
        Palette.allowGUIEvents(this.picture);
    }

    public void purgeColours() {
        Palette.surpressGUIEvents(this.picture);
        int n = this.size();
        ArrayList arrayList = new ArrayList(this.colours);
        this.clearColours();
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            ColourEntry colourEntry = (ColourEntry)iterator.next();
            if (colourEntry.isUsed()) {
                colourEntry.setIndexQuiet(n2);
                nArray[n3] = n2++;
                this.colours.add(colourEntry);
            }
            ++n3;
        }
        if (this.colours.size() > 0) {
            Frame[] frameArray = this.picture.findFramesWithPalette(this);
            int n4 = frameArray.length;
            for (int i = 0; i < n4; ++i) {
                frameArray[i].replaceColours(nArray);
            }
        }
        if (this.colours.size() == 0) {
            this.addColour(Color.black);
        }
        if (this.colours.size() == 1) {
            this.addColour(Color.white);
        }
        Palette.allowGUIEvents(this.picture);
    }

    protected void updateTransparent(int n, int n2) {
        Frame[] frameArray = this.picture.findFramesWithPalette(this);
        int n3 = frameArray.length;
        for (int i = 0; i < n3; ++i) {
            frameArray[i].setTransparentColourQuiet(n2);
        }
        if (n != -1 && n < this.size()) {
            this.getColour(n).setTransparency(false);
        }
        if (n2 != -1) {
            this.getColour(n2).setTransparency(true);
        }
    }

    public int compress() {
        int n = this.size();
        this.compress(this.picture.findFramesWithPalette(this));
        if (this.size() != n) {
            this.notifyDataListeners(new ChangeEvent(this, 20));
        }
        return n - this.size();
    }

    protected boolean compress(Frame[] frameArray) {
        boolean bl;
        if (Log.DEBUG) {
            Log.debug("compressing palette...");
        }
        int n = this.size();
        this.calculateUsage();
        this.purgeColours();
        int n2 = this.size();
        boolean bl2 = bl = n != n2;
        if (Log.DEBUG) {
            Log.debug("done.");
        }
        return bl;
    }

    public Palette copy() {
        Palette palette = new Palette(this.picture);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ColourEntry colourEntry = (ColourEntry)this.colours.get(i);
            palette.colours.add(colourEntry.copy());
        }
        return palette;
    }

    public final void dataChanged(ChangeEvent changeEvent) {
        switch (changeEvent.changeType) {
            case 41: {
                this.entryDisposed(changeEvent);
                break;
            }
            case 40: {
                this.entryReindexed(changeEvent);
                break;
            }
            case 42: {
                this.rehash(changeEvent);
                this.notifyDataListeners(new ChangeEvent((DataObject)this, 21, ((ColourEntry)changeEvent.source).getIndex()));
                break;
            }
            default: {
                Assert.fail("data: cannot handle event " + changeEvent.toString());
            }
        }
    }

    private void rehash(ChangeEvent changeEvent) {
        String string = (String)changeEvent.getOldValue();
        String string2 = (String)changeEvent.getNewValue();
        this.colourMap.remove(string);
        this.colourMap.put(string2, changeEvent.source);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Palette)) {
            return false;
        }
        Palette palette = (Palette)object;
        int n = this.size();
        if (palette.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getColour(i).equals(palette.getColour(i))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public int findColour(Color color) {
        String string = ColourEntry.getColourString(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        ColourEntry colourEntry = (ColourEntry)this.colourMap.get(string);
        if (colourEntry == null) {
            return -1;
        }
        return colourEntry.getIndex();
    }

    public ColourEntry getColour(int n) {
        return (ColourEntry)this.colours.get(n);
    }

    public Picture getPicture() {
        return this.picture;
    }

    public int indexOf(ColourEntry colourEntry) {
        return this.colours.indexOf(colourEntry);
    }

    public boolean isGlobalPalette() {
        return this.picture.getPalette() == this;
    }

    public int reduceColours(int n) {
        Palette.surpressGUIEvents(this.picture);
        int n2 = this.reducePalette(n);
        Palette.allowGUIEvents(this.picture);
        return n2;
    }

    private void calculateUsage() {
        this.resetCounters();
        Frame[] frameArray = this.picture.findFramesWithPalette(this);
        int n = frameArray.length;
        int n2 = this.picture.getWidth();
        int n3 = this.picture.getHeight();
        for (int i = 0; i < n; ++i) {
            Frame frame = frameArray[i];
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    ColourEntry colourEntry = this.getColour(frame.getPixel(k, j));
                    colourEntry.increaseUsed();
                }
            }
        }
    }

    protected int reducePalette(int n) {
        ColourEntry colourEntry;
        ColourEntry colourEntry2;
        int n2 = this.size();
        this.calculateUsage();
        TreeSet treeSet = new TreeSet(new UsageComparator());
        treeSet.addAll(this.colours);
        ArrayList<ColourEntry> arrayList = new ArrayList<ColourEntry>(n);
        Iterator iterator = treeSet.iterator();
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        int n3 = n2 / (n * 2);
        int n4 = 0;
        while (arrayList.size() < n && iterator.hasNext()) {
            colourEntry2 = (ColourEntry)iterator.next();
            colourEntry = this.findSimilarColour(arrayList, colourEntry2.getIndex(), n3);
            if (colourEntry == null) {
                int n5 = colourEntry2.getIndex();
                nArray[n5] = n4;
                colourEntry2.setIndexQuiet(n4);
                arrayList.add(colourEntry2);
                ++n4;
                continue;
            }
            nArray[colourEntry2.getIndex()] = colourEntry.getIndex();
        }
        while (iterator.hasNext()) {
            colourEntry2 = (ColourEntry)iterator.next();
            if (!colourEntry2.isUsed()) continue;
            colourEntry = this.findSimilarColour(arrayList, colourEntry2.getIndex());
            nArray[colourEntry2.getIndex()] = colourEntry.getIndex();
        }
        this.clearColours();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.colours.add(iterator.next());
        }
        Frame[] frameArray = this.picture.findFramesWithPalette(this);
        int n6 = frameArray.length;
        for (int i = 0; i < n6; ++i) {
            frameArray[i].replaceColours(nArray);
        }
        this.picture.setTransparent(frameArray[0].getTransparentColour());
        return this.size() - n2;
    }

    private ColourEntry findSimilarColour(ArrayList arrayList, int n) {
        return this.findSimilarColour(arrayList, n, 255);
    }

    private ColourEntry findSimilarColour(ArrayList arrayList, int n, int n2) {
        int n3 = 0;
        int n4 = arrayList.size();
        ColourEntry colourEntry = this.getColour(n);
        do {
            for (int i = 0; i < n4; ++i) {
                ColourEntry colourEntry2 = (ColourEntry)arrayList.get(i);
                if (!colourEntry2.isSimilar(colourEntry, n3)) continue;
                return colourEntry2;
            }
        } while (++n3 <= n2);
        return null;
    }

    public ColourEntry findMaxUsedColorEntryForColour(Color color) {
        ColourEntry colourEntry = null;
        Iterator iterator = this.colours.iterator();
        while (iterator.hasNext()) {
            ColourEntry colourEntry2 = (ColourEntry)iterator.next();
            if (!colourEntry2.getColour().equals(color) || colourEntry != null && colourEntry.getUsedCount() >= colourEntry2.getUsedCount()) continue;
            colourEntry = colourEntry2;
        }
        return colourEntry;
    }

    private void reindex(int n) {
        int n2 = this.size();
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                ColourEntry colourEntry = this.getColour(i);
                colourEntry.decreaseIndex();
            }
        }
    }

    private void replaceIndices(int[] nArray) {
        Frame[] frameArray = this.picture.findFramesWithPalette(this);
        int n = frameArray.length;
        for (int i = 0; i < n; ++i) {
            frameArray[i].replaceColours(nArray);
        }
    }

    private void replaceIndex(int n, int n2) {
        Frame[] frameArray = this.picture.findFramesWithPalette(this);
        int n3 = frameArray.length;
        for (int i = 0; i < n3; ++i) {
            frameArray[i].replaceColour(n, n2);
        }
    }

    private void entryReindexed(ChangeEvent changeEvent) {
        if (!this.sorting) {
            this.replaceIndex(changeEvent.getOldInt(), changeEvent.getNewInt());
        }
    }

    protected final void rebuildColourMap() {
        this.colourMap.clear();
        Iterator iterator = this.colours.iterator();
        while (iterator.hasNext()) {
            ColourEntry colourEntry = (ColourEntry)iterator.next();
            this.colourMap.put(colourEntry.getColourString(), colourEntry);
        }
    }

    private void entryDisposed(ChangeEvent changeEvent) {
        ColourEntry colourEntry = (ColourEntry)changeEvent.source;
        if (colourEntry.isTransparent()) {
            this.picture.setTransparent(-1);
        }
        int n = changeEvent.getOldInt();
        this.replaceIndex(n, 0);
        this.colours.remove(n);
        this.reindex(n);
        if (this.size() == 1) {
            Color color = this.getColour(0).getColour();
            if (color.getRed() + color.getGreen() + color.getBlue() == 0) {
                this.colours.add(new ColourEntry(Color.white, 1));
            } else {
                this.colours.add(new ColourEntry(Color.black, 1));
            }
        }
        this.notifyDataListeners(new ChangeEvent(this, 20));
    }

    public void removeColour(int n) {
        Palette.surpressGUIEvents(this.picture);
        this.getColour(n).dispose();
        Palette.allowGUIEvents(this.picture);
    }

    public void replaceColour(int n, int n2) {
        if (n != n2) {
            Frame[] frameArray = this.picture.findFramesWithPalette(this);
            int n3 = frameArray.length;
            for (int i = 0; i < n3; ++i) {
                frameArray[i].replaceColour(n, n2);
            }
        }
    }

    private void resetCounters() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.getColour(i).reset();
        }
    }

    public void setColour(int n, Color color) {
        this.setQuiet(n, color);
        if (color.getAlpha() == 0) {
            this.picture.setTransparent(n);
        }
        this.notifyDataListeners(new ChangeEvent((DataObject)this, 21, n));
    }

    public void setQuiet(int n, Color color) {
        int n2 = this.size();
        if (n < n2) {
            ColourEntry colourEntry = this.getColour(n);
            colourEntry.setColour(color);
        } else {
            ColourEntry colourEntry = new ColourEntry(color, Math.min(n, n2));
            this.colours.set(n, colourEntry);
        }
    }

    public int size() {
        return this.colours.size();
    }

    private void clearColours() {
        while (this.colours.size() > 0) {
            this.colours.remove(0);
        }
        this.colourMap.clear();
    }

    public void sort() {
        Palette.surpressGUIEvents(this.picture);
        this.sorting = true;
        TreeSet treeSet = new TreeSet(this.colours);
        Assert.isTrue(treeSet.size() == this.size(), "wrong hashcode/equals functions");
        Iterator iterator = treeSet.iterator();
        this.clearColours();
        int n = 0;
        int[] nArray = new int[treeSet.size()];
        while (iterator.hasNext()) {
            ColourEntry colourEntry = (ColourEntry)iterator.next();
            this.colours.add(colourEntry);
            nArray[colourEntry.getIndex()] = n;
            colourEntry.setIndex(n);
            ++n;
        }
        this.replaceIndices(nArray);
        this.sorting = false;
        Palette.allowGUIEvents(this.picture);
    }

    public void swapColours(Picture picture, int n, int n2) {
        Frame[] frameArray = picture.findFramesWithPalette(this);
        int n3 = frameArray.length;
        for (int i = 0; i < n3; ++i) {
            frameArray[i].swapColours(n, n2);
        }
    }

    private final class UsageComparator
    implements Comparator {
        private UsageComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            int n2 = ((ColourEntry)object).getUsedCount();
            if (n2 == (n = ((ColourEntry)object2).getUsedCount())) {
                n2 = ((ColourEntry)object).getIndex();
                n = ((ColourEntry)object2).getIndex();
            }
            if (n2 > n) {
                return -1;
            }
            if (n2 < n) {
                return 1;
            }
            Assert.fail("data: duplicate index found!");
            return 0;
        }
    }

    private final class ColourList
    extends ArrayList {
        private static final long serialVersionUID = 1L;

        private ColourList() {
        }

        public void add(int n, Object object) {
            this.attach(object);
            super.add(n, object);
        }

        public boolean add(Object object) {
            this.attach(object);
            return super.add(object);
        }

        public boolean addAll(Collection collection) {
            Assert.fail("data: method forbidden");
            return super.addAll(collection);
        }

        public boolean addAll(int n, Collection collection) {
            Assert.fail("data: method forbidden");
            return super.addAll(n, collection);
        }

        private void attach(Object object) {
            this.check(object);
            ColourEntry colourEntry = (ColourEntry)object;
            Palette.this.colourMap.put(colourEntry.getColourString(), colourEntry);
            colourEntry.addDataChangeListener(Palette.this);
        }

        private void check(Object object) {
        }

        public void clear() {
            Assert.fail("data: method forbidden");
            super.clear();
        }

        private void detach(Object object) {
            this.check(object);
            ColourEntry colourEntry = (ColourEntry)object;
            colourEntry.removeDataChangeListener(Palette.this);
        }

        public Object remove(int n) {
            this.detach(this.get(n));
            Object e = super.remove(n);
            return e;
        }

        public boolean remove(Object object) {
            this.detach(object);
            return super.remove(object);
        }

        protected void removeRange(int n, int n2) {
            Assert.fail("data: method forbidden");
            super.removeRange(n, n2);
        }

        public Object set(int n, Object object) {
            this.attach(object);
            return super.set(n, object);
        }
    }
}

