/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gio;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.FrameSettings;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.SimpleLogListener;
import jdomain.util.Util;

public final class GIFReader {
    private static final boolean DEBUG_READ = false;
    private static final int DEBUG_LEVEL = 0;
    private static final int MAX_CODE_SIZE = 12;
    private static final int[] LOOP_Y = new int[]{0, 4, 2, 1};
    private static final int[] LOOP_OFFSET = new int[]{8, 8, 4, 2};
    private static final int BIT_0 = 1;
    private static final int BIT_1 = 2;
    private static final int BIT_2 = 4;
    private static final int BIT_3 = 8;
    private static final int BIT_4 = 16;
    private static final int BIT_5 = 32;
    private static final int BIT_6 = 64;
    private static final int BIT_7 = 128;
    private final InputStream in;
    private Picture picture;
    private int currentFrame = -1;
    private GraphicControlExtension gce = null;
    private int paletteSize;
    private int minX;
    private int minY;
    private int w;
    private int h;
    private boolean interlaced;
    private int bytesAvailable;
    private int clear;
    private int endLZW;
    private int initialcodeSize;
    private int codeSize;
    private final HashMap codeMap = new HashMap(4096);
    private int freeCode;
    private int lastCode;
    private int code;
    private int currentData;
    private int availableBits;
    private int x;
    private int y;
    private int loop;

    private GIFReader(InputStream inputStream) {
        this.in = inputStream;
    }

    private static void debug(int n, String string) {
        if (n <= 0) {
            Log.debug(string);
        }
    }

    public static final Picture readGIF(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            return GIFReader.readGIF(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.error("File '" + string + "' not found.");
            return null;
        }
        catch (Exception exception) {
            Log.exception(exception);
            return null;
        }
    }

    public static final Picture readGIF(InputStream inputStream) {
        try {
            GIFReader gIFReader = new GIFReader(inputStream);
            Picture picture = gIFReader.readGIF();
            picture.setCurrentFrame(0);
            picture.setTransparent(picture.getFrame(0).getTransparentColour());
            return picture;
        }
        catch (Exception exception) {
            Log.exception(exception);
            return null;
        }
    }

    private int readInt() throws Exception {
        int n = this.in.read();
        int n2 = this.in.read();
        return n + (n2 <<= 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Picture readGIF() throws Exception {
        try {
            char c;
            this.readSignature();
            boolean bl = this.readScreenDescriptor();
            if (bl) {
                this.picture.setPalette(this.readPalette());
            } else {
                this.picture.setPalette(Palette.createDefaultPalette(this.picture));
            }
            do {
                c = (char)this.in.read();
                switch (c) {
                    case ',': {
                        Serializable serializable;
                        boolean bl2 = this.readImageDescriptor();
                        Frame frame = this.picture.getFrame(this.currentFrame);
                        if (bl2) {
                            serializable = this.readPalette();
                            frame.setPalette((Palette)serializable);
                        }
                        if (this.gce != null) {
                            if (this.gce.useTransparentColour) {
                                frame.setTransparentColour(this.gce.transparentColour);
                            }
                            serializable = frame.getSettings();
                            ((FrameSettings)serializable).setDelay(this.gce.delay);
                            ((FrameSettings)serializable).setDisposalMethod(this.gce.disposalMethod);
                            this.gce = null;
                        }
                        this.readImageData();
                        break;
                    }
                    case '!': {
                        this.readExtensionBlock();
                        break;
                    }
                    case ';': {
                        break;
                    }
                    case '\u0000': {
                        Log.info("Ignoring unexpected block separator...");
                        break;
                    }
                    default: {
                        Assert.fail("gio: unknown separator '" + c + "' (" + Util.hexString(c, 2) + ")");
                    }
                }
            } while (c != ';');
            Picture picture = this.picture;
            return picture;
        }
        finally {
            Util.close(this.in);
        }
    }

    private void initCodes() {
        this.codeSize = this.initialcodeSize + 1;
        int n = (int)Math.pow(2.0, this.initialcodeSize) - 1;
        this.codeMap.clear();
        for (int i = 0; i <= n; ++i) {
            Integer n2 = new Integer(i);
            String string = "" + (char)i;
            this.codeMap.put(n2, string);
        }
        this.clear = n + 1;
        this.endLZW = n + 2;
        this.freeCode = n + 3;
        this.lastCode = (int)(Math.pow(2.0, this.codeSize) - 1.0);
    }

    private void increaseCodeSize() {
        if (this.codeSize < 12) {
            ++this.codeSize;
            this.lastCode = (int)(Math.pow(2.0, this.codeSize) - 1.0);
        } else if (Log.DEBUG) {
            Log.debug(">> cannot increase code size");
        }
    }

    private String findCode(int n) {
        return (String)this.codeMap.get(new Integer(n));
    }

    private void addCode(String string) {
        Assert.isTrue(string != null && string.length() > 0, "gio: invalid code");
        this.codeMap.put(new Integer(this.freeCode), string);
        ++this.freeCode;
        if (this.freeCode > this.lastCode) {
            this.increaseCodeSize();
        }
    }

    private void readImageData() throws Exception {
        this.initialcodeSize = this.in.read();
        this.initCodes();
        this.availableBits = 0;
        this.currentData = 0;
        this.loop = 0;
        this.x = this.minX;
        this.y = this.minY + LOOP_Y[this.loop];
        this.nextCode();
        Assert.isTrue(this.code == this.clear, "gio: clear expected instead of " + Util.binaryString(this.code, this.codeSize));
        this.nextCode();
        this.output(this.findCode(this.code));
        int n = this.code;
        boolean bl = false;
        do {
            char c;
            String string;
            this.nextCode();
            if (this.code == this.clear) {
                this.initCodes();
                this.nextCode();
                this.output(this.findCode(this.code));
                n = this.code;
                continue;
            }
            if (this.code == this.endLZW) {
                bl = true;
                continue;
            }
            String string2 = this.findCode(this.code);
            if (string2 != null) {
                this.output(string2);
                string = this.findCode(n);
                c = string2.charAt(0);
                this.addCode(string + c);
                string = string + c;
            } else {
                string = this.findCode(n);
                Assert.notNull(string, "gio: prefix is null. missing code #" + n + ", " + Util.binaryString(n, this.codeSize));
                c = string.charAt(0);
                this.output(string + c);
                this.addCode(string + c);
            }
            n = this.code;
        } while (!bl);
        int n2 = this.in.read();
        Assert.isTrue(n2 == 0, "gio: missing block terminator. found " + Util.binaryString(n2, this.codeSize) + " instead.");
    }

    private void output(String string) {
        int n = string.length();
        if (n == 0) {
            return;
        }
        Frame frame = this.picture.getFrame(this.currentFrame);
        block0: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            Assert.isFalse(this.y >= this.minY + this.h, "gio: y out of range, " + this.y + " >= " + (this.minY + this.h));
            frame.setPixel(this.x, this.y, c);
            ++this.x;
            if (this.x != this.minX + this.w) continue;
            this.x = this.minX;
            if (this.interlaced) {
                this.y += LOOP_OFFSET[this.loop];
                while (this.y >= this.minY + this.h) {
                    ++this.loop;
                    if (this.loop < LOOP_Y.length) {
                        this.y = this.minY + LOOP_Y[this.loop];
                        continue;
                    }
                    this.y = -1;
                    continue block0;
                }
                continue;
            }
            ++this.y;
        }
    }

    private void nextCode() throws Exception {
        int n;
        while (this.availableBits < this.codeSize) {
            if (this.bytesAvailable == 0) {
                this.bytesAvailable = this.in.read();
                Assert.isTrue(this.bytesAvailable > 0, "gio: out of data");
            }
            n = this.in.read();
            --this.bytesAvailable;
            this.currentData |= (n <<= this.availableBits);
            this.availableBits += 8;
        }
        n = 1;
        for (int i = 1; i < this.codeSize; ++i) {
            n = (n << 1) + 1;
        }
        this.code = this.currentData & n;
        this.currentData >>= this.codeSize;
        this.availableBits -= this.codeSize;
    }

    private void readExtensionBlock() throws Exception {
        int n = this.in.read();
        switch (n) {
            case 249: {
                this.readGraphicControlExtension();
                break;
            }
            default: {
                int n2;
                Log.info("gio: skipping extension block of type '" + n + "', 0x" + Util.hexString(n, 2));
                byte[] byArray = new byte[256];
                do {
                    if ((n2 = this.in.read()) <= 0) continue;
                    this.in.read(byArray, 0, n2);
                } while (n2 > 0);
            }
        }
    }

    private void readGraphicControlExtension() throws Exception {
        this.gce = new GraphicControlExtension();
        this.in.read();
        int n = this.in.read();
        this.gce.useTransparentColour = (n & 1) > 0;
        this.gce.disposalMethod = (n & 0x1C) >> 2;
        this.gce.delay = this.readInt();
        this.gce.transparentColour = this.in.read();
        n = this.in.read();
        Assert.isTrue(n == 0, "gio: missing extension block terminator");
    }

    private boolean readImageDescriptor() throws Exception {
        this.minX = this.readInt();
        this.minY = this.readInt();
        this.w = this.readInt();
        this.h = this.readInt();
        ++this.currentFrame;
        Frame frame = this.picture.addFrame();
        int n = this.in.read();
        boolean bl = (n & 0x80) > 0;
        this.interlaced = (n & 0x40) > 0;
        boolean bl2 = (n & 0x20) > 0;
        int n2 = n & 7;
        this.paletteSize = (int)Math.pow(2.0, n2 + 1);
        return bl;
    }

    private void readSignature() throws Exception {
        String string = "GIF89a";
        String string2 = "GIF87a";
        byte[] byArray = new byte[string.length()];
        this.in.read(byArray);
        String string3 = new String(byArray);
        Assert.isTrue(string3.equals(string) || string3.equals(string2), "gio: unknown signature '" + string3 + "'");
    }

    private boolean readScreenDescriptor() throws Exception {
        int n = this.readInt();
        int n2 = this.readInt();
        this.picture = new Picture(n, n2);
        int n3 = this.in.read();
        boolean bl = (n3 & 0x80) > 0;
        int n4 = (n3 & 0x70) >> 4;
        boolean bl2 = (n3 & 8) != 0;
        int n5 = n3 & 7;
        this.paletteSize = (int)Math.pow(2.0, n5 + 1);
        this.picture.setPictureBackground(this.in.read());
        int n6 = this.in.read();
        return bl;
    }

    private final Palette readPalette() throws Exception {
        Palette palette = new Palette(this.picture);
        for (int i = 0; i < this.paletteSize; ++i) {
            palette.addQuiet(new Color(this.in.read(), this.in.read(), this.in.read()));
        }
        return palette;
    }

    public static void main(String[] stringArray) {
        SimpleLogListener simpleLogListener = new SimpleLogListener(System.out);
        Log.addLogListener(simpleLogListener);
        GIFReader.readGIF("/home/michaela/tmp/test1.gif");
    }

    private final class GraphicControlExtension {
        public boolean useTransparentColour = false;
        public int transparentColour = -1;
        public int delay = -1;
        public int disposalMethod = -1;

        private GraphicControlExtension() {
        }
    }
}

