/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.util.Util;
import jdomain.util.gui.WidgetFactory;

public class GrayScaleDialog
extends DrawDialog
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private static int percentage = 50;
    private static boolean brighten = true;
    private final JTextField percentageField = new JTextField(4);
    private final JCheckBox brightenBox = new JCheckBox("Brighten pixels");

    public GrayScaleDialog() {
        super("Grayscale");
        WidgetFactory.addFocusAdapter(this.percentageField);
        this.setDefaultBorder();
        this.setModal(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.percentageField.getDocument().addDocumentListener(this);
        this.percentageField.setText(String.valueOf(percentage));
        this.brightenBox.setSelected(brighten);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.gridwidth = 2;
        JLabel jLabel = new JLabel("<html><b>Please specify the grayscale filter:</b></html>");
        jLabel.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        JLabel jLabel2 = new JLabel("Gray in %: ");
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.percentageField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.brightenBox, gridBagConstraints);
        this.main.add((Component)jPanel, "Center");
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
        this.setFirstFocusComponent(this.percentageField);
    }

    public int getPercentage() {
        percentage = Util.asInt(this.percentageField.getText().trim());
        return percentage;
    }

    public boolean brightenPixels() {
        brighten = this.brightenBox.isSelected();
        return brighten;
    }

    private void checkInput() {
        String string = this.percentageField.getText().trim();
        if (!Util.isNumber(string)) {
            this.getApproveButton().setEnabled(false);
        } else {
            this.getApproveButton().setEnabled(Util.isIn(Util.asInt(string), 0, 100));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }
}

