/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import jdomain.jdraw.Settings;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.data.DataChangeListener;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.jdraw.gui.Dispatcher;
import jdomain.jdraw.gui.DrawMenu;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.InfoClip;
import jdomain.jdraw.gui.PalettePanel;
import jdomain.jdraw.gui.StatusPanel;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.ToolPanel;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.util.Log;
import jdomain.util.ResourceLoader;
import jdomain.util.gui.GUIUtil;
import jdomain.util.gui.StandardMainFrame;

public final class MainFrame
extends StandardMainFrame
implements DataChangeListener {
    private static final long serialVersionUID = 1L;
    public static final Font DEFAULT_FONT = GUIUtil.DEFAULT_FONT;
    public static final Font SMALL_FONT = new Font("SansSerif", 0, 10);
    public static final Font TINY_FONT = new Font("SansSerif", 0, 9);
    public static final Font BOLD_FONT = GUIUtil.BOLD_FONT;
    public static final Font BIG_FONT = new Font("Serif", 1, 32);
    private static final String PREFIX = "JDraw v1.1.5 - December 2005";
    public static final MainFrame INSTANCE = new MainFrame();
    private String fileName = null;
    private Picture picture;
    private final JPanel centerPanel = new JPanel(new BorderLayout(0, 0));
    static /* synthetic */ Class class$jdomain$jdraw$action$ReduceColoursAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ReducePaletteColoursAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ExitAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SaveAsAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ScaleAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$RemoveColourAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$EditFrameSettingsAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ToggleGridAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$HelpAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$CompressAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$LoadAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SwapColoursAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$NewAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetPixelToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ResizeAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SaveAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ViewAnimationAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$UndoAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$RedoAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$IncreaseZoomAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$DecreaseZoomAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetFillToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetColourPickerToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetLineToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetMinZoomAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetMaxZoomAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetPreviousZoomAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ToggleTransparencyAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ToggleViewsAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$RotateClipAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$FlipClipHorizontallyAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$FlipClipVerticallyAction;

    private MainFrame() {
        super(PREFIX);
        this.setDefaultCloseOperation(0);
        this.setIconImage(ResourceLoader.getImage("jdomain/jdraw/images/pixel_tool.png").getImage());
        this.setJMenuBar(new DrawMenu());
        this.updateTitle();
        this.createGui();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setOpaque(false);
        jPanel.add(InfoClip.INSTANCE);
        this.setGlassPane(jPanel);
        this.getGlassPane().setVisible(true);
    }

    protected void setupSize() {
        Settings settings = Settings.INSTANCE;
        Dimension dimension = settings.getFrameDimension();
        if (dimension != null) {
            Log.debug("restoring window dimension and location");
            this.setLocation(settings.getFrameLocation());
            this.setSize(dimension);
        } else {
            this.setLocation(new Point(0, 0));
            this.setSize(new Dimension(640, 480));
        }
    }

    protected void opened() {
        Settings settings = Settings.INSTANCE;
        Dimension dimension = settings.getFrameDimension();
        if (dimension == null) {
            super.opened();
        }
    }

    private void attach() {
        this.picture.addDataChangeListener(this);
        int n = this.picture.getFrameCount();
        for (int i = 0; i < n; ++i) {
            Frame frame = this.picture.getFrame(i);
            frame.addDataChangeListener(this);
            frame.getPalette().addDataChangeListener(this);
        }
    }

    private void detach() {
        if (this.picture != null) {
            this.picture.removeDataChangeListener(this);
            int n = this.picture.getFrameCount();
            for (int i = 0; i < n; ++i) {
                Frame frame = this.picture.getFrame(i);
                frame.removeDataChangeListener(this);
                frame.getPalette().removeDataChangeListener(this);
            }
        }
    }

    public void setPicture(Picture picture) {
        boolean bl;
        boolean bl2 = bl = picture == this.picture;
        if (!bl) {
            this.detach();
            this.picture = picture;
        }
        FolderPanel.INSTANCE.setPicture(this.picture);
        PalettePanel.INSTANCE.setPalette(this.picture.getCurrentFrame().getPalette());
        UndoManager.INSTANCE.reset();
        this.updateTitle();
        if (!bl) {
            this.attach();
        }
    }

    public Picture getPicture() {
        return this.picture;
    }

    private final JPanel getMainPanel() {
        return (JPanel)this.getContentPane();
    }

    protected void createGui() {
        JPanel jPanel = this.getMainPanel();
        jPanel.add((Component)StatusPanel.INSTANCE, "South");
        this.centerPanel.add((Component)FolderPanel.INSTANCE, "Center");
        jPanel.add((Component)this.centerPanel, "Center");
        this.showViews(true);
    }

    public void showViews(boolean bl) {
        if (bl) {
            this.getMainPanel().add((Component)PalettePanel.INSTANCE, "West");
            this.centerPanel.add((Component)ToolPanel.INSTANCE, "North");
        } else {
            this.getMainPanel().remove(PalettePanel.INSTANCE);
            this.centerPanel.remove(ToolPanel.INSTANCE);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.updateTitle();
    }

    public void updateTitle() {
        String string = this.fileName;
        if (string == null) {
            string = "noname";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(0, "[");
        if (UndoManager.INSTANCE.hasChanges()) {
            stringBuffer.append("*");
        }
        stringBuffer.append("] ");
        if (this.picture != null) {
            stringBuffer.append("(").append(String.valueOf(this.picture.getWidth()));
            stringBuffer.append("x").append(String.valueOf(this.picture.getHeight()));
            stringBuffer.append(", ").append(Tool.getCurrentPalette().size());
            stringBuffer.append(" colours)");
        }
        this.setTitle("JDraw v1.1.5 - December 2005  -  " + stringBuffer.toString());
        if (this.picture != null) {
            DrawAction.getAction(class$jdomain$jdraw$action$ReduceColoursAction == null ? (class$jdomain$jdraw$action$ReduceColoursAction = MainFrame.class$("jdomain.jdraw.action.ReduceColoursAction")) : class$jdomain$jdraw$action$ReduceColoursAction).setEnabled(this.picture.getMaximalPaletteSize() > 256);
            DrawAction.getAction(class$jdomain$jdraw$action$ReducePaletteColoursAction == null ? (class$jdomain$jdraw$action$ReducePaletteColoursAction = MainFrame.class$("jdomain.jdraw.action.ReducePaletteColoursAction")) : class$jdomain$jdraw$action$ReducePaletteColoursAction).setEnabled(Tool.getCurrentPalette().size() > 256);
        }
    }

    protected void closing() {
        DrawAction.getAction(class$jdomain$jdraw$action$ExitAction == null ? (class$jdomain$jdraw$action$ExitAction = MainFrame.class$("jdomain.jdraw.action.ExitAction")) : class$jdomain$jdraw$action$ExitAction).actionPerformed();
    }

    private DrawAction handleCtrlKeys(char c) {
        switch (c) {
            case '\u0001': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SaveAsAction == null ? (class$jdomain$jdraw$action$SaveAsAction = MainFrame.class$("jdomain.jdraw.action.SaveAsAction")) : class$jdomain$jdraw$action$SaveAsAction);
            }
            case '\u0003': {
                return DrawAction.getAction(class$jdomain$jdraw$action$ScaleAction == null ? (class$jdomain$jdraw$action$ScaleAction = MainFrame.class$("jdomain.jdraw.action.ScaleAction")) : class$jdomain$jdraw$action$ScaleAction);
            }
            case '\u0004': {
                return DrawAction.getAction(class$jdomain$jdraw$action$RemoveColourAction == null ? (class$jdomain$jdraw$action$RemoveColourAction = MainFrame.class$("jdomain.jdraw.action.RemoveColourAction")) : class$jdomain$jdraw$action$RemoveColourAction);
            }
            case '\u0005': {
                return DrawAction.getAction(class$jdomain$jdraw$action$EditFrameSettingsAction == null ? (class$jdomain$jdraw$action$EditFrameSettingsAction = MainFrame.class$("jdomain.jdraw.action.EditFrameSettingsAction")) : class$jdomain$jdraw$action$EditFrameSettingsAction);
            }
            case '\u0007': {
                return DrawAction.getAction(class$jdomain$jdraw$action$ToggleGridAction == null ? (class$jdomain$jdraw$action$ToggleGridAction = MainFrame.class$("jdomain.jdraw.action.ToggleGridAction")) : class$jdomain$jdraw$action$ToggleGridAction);
            }
            case '\b': {
                return DrawAction.getAction(class$jdomain$jdraw$action$HelpAction == null ? (class$jdomain$jdraw$action$HelpAction = MainFrame.class$("jdomain.jdraw.action.HelpAction")) : class$jdomain$jdraw$action$HelpAction);
            }
            case '\u000b': {
                return DrawAction.getAction(class$jdomain$jdraw$action$CompressAction == null ? (class$jdomain$jdraw$action$CompressAction = MainFrame.class$("jdomain.jdraw.action.CompressAction")) : class$jdomain$jdraw$action$CompressAction);
            }
            case '\f': {
                return DrawAction.getAction(class$jdomain$jdraw$action$LoadAction == null ? (class$jdomain$jdraw$action$LoadAction = MainFrame.class$("jdomain.jdraw.action.LoadAction")) : class$jdomain$jdraw$action$LoadAction);
            }
            case '\n': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SwapColoursAction == null ? (class$jdomain$jdraw$action$SwapColoursAction = MainFrame.class$("jdomain.jdraw.action.SwapColoursAction")) : class$jdomain$jdraw$action$SwapColoursAction);
            }
            case '\u000e': {
                return DrawAction.getAction(class$jdomain$jdraw$action$NewAction == null ? (class$jdomain$jdraw$action$NewAction = MainFrame.class$("jdomain.jdraw.action.NewAction")) : class$jdomain$jdraw$action$NewAction);
            }
            case '\u0010': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetPixelToolAction == null ? (class$jdomain$jdraw$action$SetPixelToolAction = MainFrame.class$("jdomain.jdraw.action.SetPixelToolAction")) : class$jdomain$jdraw$action$SetPixelToolAction);
            }
            case '\u0012': {
                return DrawAction.getAction(class$jdomain$jdraw$action$ResizeAction == null ? (class$jdomain$jdraw$action$ResizeAction = MainFrame.class$("jdomain.jdraw.action.ResizeAction")) : class$jdomain$jdraw$action$ResizeAction);
            }
            case '\u0013': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SaveAction == null ? (class$jdomain$jdraw$action$SaveAction = MainFrame.class$("jdomain.jdraw.action.SaveAction")) : class$jdomain$jdraw$action$SaveAction);
            }
            case '\u0016': {
                return DrawAction.getAction(class$jdomain$jdraw$action$ViewAnimationAction == null ? (class$jdomain$jdraw$action$ViewAnimationAction = MainFrame.class$("jdomain.jdraw.action.ViewAnimationAction")) : class$jdomain$jdraw$action$ViewAnimationAction);
            }
            case '\u001a': {
                return DrawAction.getAction(class$jdomain$jdraw$action$UndoAction == null ? (class$jdomain$jdraw$action$UndoAction = MainFrame.class$("jdomain.jdraw.action.UndoAction")) : class$jdomain$jdraw$action$UndoAction);
            }
        }
        return null;
    }

    private DrawAction handleCtrlShiftKeys(char c) {
        switch (c) {
            case '\u001a': {
                return DrawAction.getAction(class$jdomain$jdraw$action$RedoAction == null ? (class$jdomain$jdraw$action$RedoAction = MainFrame.class$("jdomain.jdraw.action.RedoAction")) : class$jdomain$jdraw$action$RedoAction);
            }
        }
        return null;
    }

    private DrawAction handlePlainKeys(char c) {
        switch (c) {
            case '+': {
                return DrawAction.getAction(class$jdomain$jdraw$action$IncreaseZoomAction == null ? (class$jdomain$jdraw$action$IncreaseZoomAction = MainFrame.class$("jdomain.jdraw.action.IncreaseZoomAction")) : class$jdomain$jdraw$action$IncreaseZoomAction);
            }
            case '-': {
                return DrawAction.getAction(class$jdomain$jdraw$action$DecreaseZoomAction == null ? (class$jdomain$jdraw$action$DecreaseZoomAction = MainFrame.class$("jdomain.jdraw.action.DecreaseZoomAction")) : class$jdomain$jdraw$action$DecreaseZoomAction);
            }
            case '1': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetPixelToolAction == null ? (class$jdomain$jdraw$action$SetPixelToolAction = MainFrame.class$("jdomain.jdraw.action.SetPixelToolAction")) : class$jdomain$jdraw$action$SetPixelToolAction);
            }
            case '2': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetFillToolAction == null ? (class$jdomain$jdraw$action$SetFillToolAction = MainFrame.class$("jdomain.jdraw.action.SetFillToolAction")) : class$jdomain$jdraw$action$SetFillToolAction);
            }
            case '3': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetColourPickerToolAction == null ? (class$jdomain$jdraw$action$SetColourPickerToolAction = MainFrame.class$("jdomain.jdraw.action.SetColourPickerToolAction")) : class$jdomain$jdraw$action$SetColourPickerToolAction);
            }
            case '4': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetLineToolAction == null ? (class$jdomain$jdraw$action$SetLineToolAction = MainFrame.class$("jdomain.jdraw.action.SetLineToolAction")) : class$jdomain$jdraw$action$SetLineToolAction);
            }
            case '0': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetMinZoomAction == null ? (class$jdomain$jdraw$action$SetMinZoomAction = MainFrame.class$("jdomain.jdraw.action.SetMinZoomAction")) : class$jdomain$jdraw$action$SetMinZoomAction);
            }
            case '9': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetMaxZoomAction == null ? (class$jdomain$jdraw$action$SetMaxZoomAction = MainFrame.class$("jdomain.jdraw.action.SetMaxZoomAction")) : class$jdomain$jdraw$action$SetMaxZoomAction);
            }
            case '8': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetPreviousZoomAction == null ? (class$jdomain$jdraw$action$SetPreviousZoomAction = MainFrame.class$("jdomain.jdraw.action.SetPreviousZoomAction")) : class$jdomain$jdraw$action$SetPreviousZoomAction);
            }
            case ' ': {
                return DrawAction.getAction(class$jdomain$jdraw$action$ToggleTransparencyAction == null ? (class$jdomain$jdraw$action$ToggleTransparencyAction = MainFrame.class$("jdomain.jdraw.action.ToggleTransparencyAction")) : class$jdomain$jdraw$action$ToggleTransparencyAction);
            }
            case '\t': {
                return DrawAction.getAction(class$jdomain$jdraw$action$ToggleViewsAction == null ? (class$jdomain$jdraw$action$ToggleViewsAction = MainFrame.class$("jdomain.jdraw.action.ToggleViewsAction")) : class$jdomain$jdraw$action$ToggleViewsAction);
            }
            case 'r': {
                return DrawAction.getAction(class$jdomain$jdraw$action$RotateClipAction == null ? (class$jdomain$jdraw$action$RotateClipAction = MainFrame.class$("jdomain.jdraw.action.RotateClipAction")) : class$jdomain$jdraw$action$RotateClipAction);
            }
            case 'h': {
                return DrawAction.getAction(class$jdomain$jdraw$action$FlipClipHorizontallyAction == null ? (class$jdomain$jdraw$action$FlipClipHorizontallyAction = MainFrame.class$("jdomain.jdraw.action.FlipClipHorizontallyAction")) : class$jdomain$jdraw$action$FlipClipHorizontallyAction);
            }
            case 'v': {
                return DrawAction.getAction(class$jdomain$jdraw$action$FlipClipVerticallyAction == null ? (class$jdomain$jdraw$action$FlipClipVerticallyAction = MainFrame.class$("jdomain.jdraw.action.FlipClipVerticallyAction")) : class$jdomain$jdraw$action$FlipClipVerticallyAction);
            }
            case '\u001b': {
                return DrawAction.getAction(class$jdomain$jdraw$action$SetPixelToolAction == null ? (class$jdomain$jdraw$action$SetPixelToolAction = MainFrame.class$("jdomain.jdraw.action.SetPixelToolAction")) : class$jdomain$jdraw$action$SetPixelToolAction);
            }
        }
        return null;
    }

    private DrawAction handleShiftKeys(char c) {
        return null;
    }

    public boolean handleKey(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            if ((keyEvent.getModifiers() & 8) > 0) {
                return false;
            }
            DrawAction drawAction = null;
            switch (keyEvent.getModifiers()) {
                case 2: {
                    drawAction = this.handleCtrlKeys(keyEvent.getKeyChar());
                    break;
                }
                case 0: {
                    drawAction = this.handlePlainKeys(keyEvent.getKeyChar());
                    break;
                }
                case 1: {
                    drawAction = this.handleShiftKeys(keyEvent.getKeyChar());
                    break;
                }
                case 3: {
                    drawAction = this.handleCtrlShiftKeys(keyEvent.getKeyChar());
                    break;
                }
                default: {
                    return false;
                }
            }
            if (drawAction != null) {
                drawAction.actionPerformed();
                keyEvent.consume();
                return true;
            }
            if (Log.DEBUG) {
                Log.debug("unknown key: " + this.keyDesc(keyEvent.getKeyChar(), keyEvent.getModifiers()));
            }
        }
        return false;
    }

    public void dataChanged(ChangeEvent changeEvent) {
        Dispatcher.dispatch(changeEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

