/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.data.ColourEntry;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.jdraw.gui.ColourPanel;
import jdomain.jdraw.gui.DrawMenu;
import jdomain.jdraw.gui.GradientPanel;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.StatusPanel;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.Util;
import jdomain.util.gui.ScrollablePanel;
import jdomain.util.gui.StandardScrollPane;

public final class PalettePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public static final PalettePanel INSTANCE = new PalettePanel();
    private static final int COLS = 8;
    private static final int BORDER = 1;
    private Palette palette;
    private final JLabel titleLabel = new JLabel(" ");
    private JPanel colours = new JPanel(new GridLayout(0, 8, 1, 1));
    private JPanel title;
    private final StandardScrollPane scrollPanel;
    static /* synthetic */ Class class$jdomain$jdraw$action$EditColourAction;

    private PalettePanel() {
        super(new BorderLayout(0, 0));
        ScrollablePanel scrollablePanel = new ScrollablePanel(ColourPanel.DIMENSION.width + 1, 5);
        scrollablePanel.setLayout(new BorderLayout(0, 0));
        scrollablePanel.add((Component)this.colours, "North");
        scrollablePanel.setBackground(Color.black);
        this.scrollPanel = new StandardScrollPane(scrollablePanel, 20, 31);
        this.scrollPanel.setEnsuredWidth(ColourPanel.DIMENSION.width * 8 + 8 + 2 + 2);
        this.add((Component)this.scrollPanel, "Center");
        this.add((Component)GradientPanel.INSTANCE, "South");
        this.title = this.createTitleBar();
        this.title.addMouseListener(this);
        this.scrollPanel.getViewport().setBackground(Color.black);
        this.colours.setBackground(Color.black);
        this.colours.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    private JPanel createTitleBar() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setToolTipText("<html> <b>Right-click:</b> palette menu</html>");
        jPanel.add((Component)this.titleLabel, "Center");
        jPanel.setFont(MainFrame.BOLD_FONT);
        this.titleLabel.setForeground(Color.white);
        this.titleLabel.setHorizontalAlignment(0);
        jPanel.setBackground(new Color(40, 60, 160));
        this.add((Component)jPanel, "North");
        Dimension dimension = this.titleLabel.getPreferredSize();
        dimension.height += 2;
        jPanel.setPreferredSize(dimension);
        return jPanel;
    }

    public void changeColour(ChangeEvent changeEvent) {
        this.updateColour(changeEvent.getOldInt());
        this.updateColour(changeEvent.getNewInt());
    }

    private void updateTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.palette.isGlobalPalette()) {
            stringBuffer.append("Global ");
        } else {
            stringBuffer.append("Local ");
        }
        stringBuffer.append(" Palette");
        this.titleLabel.setText(stringBuffer.toString());
        MainFrame.INSTANCE.updateTitle();
    }

    public void setPalette(Palette palette) {
        this.palette = palette;
        this.createPaletteView();
        Picture picture = Tool.getPicture();
        this.updateColour(picture.getForeground());
        this.updateColour(picture.getBackground());
        this.updateColour(picture.getTransparent());
        this.updateTitle();
    }

    protected void colourAdded(ColourEntry colourEntry) {
        ColourPanel colourPanel = new ColourPanel(colourEntry);
        this.colours.add(colourPanel);
        colourPanel.addMouseListener(this);
        colourPanel.addMouseMotionListener(this);
        this.colours.invalidate();
        this.colours.revalidate();
    }

    private void createPaletteView() {
        this.setVisible(false);
        this.colours.removeAll();
        int n = this.palette.size();
        for (int i = 0; i < n; ++i) {
            this.colourAdded(this.palette.getColour(i));
        }
        this.setVisible(true);
    }

    public void updateColour(int n) {
        if (n != -1 && n < Tool.getCurrentPalette().size()) {
            this.getColourPanel(n).update();
        }
    }

    private ColourPanel getColourPanel(int n) {
        return (ColourPanel)this.colours.getComponent(n);
    }

    private void editColour(Color color) {
        DrawAction.getAction(class$jdomain$jdraw$action$EditColourAction == null ? (class$jdomain$jdraw$action$EditColourAction = PalettePanel.class$("jdomain.jdraw.action.EditColourAction")) : class$jdomain$jdraw$action$EditColourAction).actionPerformed();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getButton();
        int n2 = mouseEvent.getModifiers();
        if ((n2 & 2) > 0) {
            if (n == 1) {
                this.setTransparentColour(mouseEvent);
            } else if (n == 2 || n == 3) {
                this.setPictureBackgroundColour(mouseEvent);
            }
            return;
        }
        if (mouseEvent.getSource() instanceof ColourPanel) {
            this.colourSelection(n, mouseEvent);
        } else if (mouseEvent.getSource() == this.title) {
            this.paletteMenu(n, mouseEvent);
        }
    }

    private void setTransparentColour(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof ColourPanel) {
            ColourPanel colourPanel = (ColourPanel)mouseEvent.getSource();
            Picture picture = Tool.getPicture();
            if (picture.getTransparent() != colourPanel.index) {
                picture.setTransparent(colourPanel.index);
            } else {
                picture.setTransparent(-1);
            }
        }
    }

    private void setPictureBackgroundColour(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof ColourPanel) {
            if (this.palette.isGlobalPalette()) {
                ColourPanel colourPanel = (ColourPanel)mouseEvent.getSource();
                Picture picture = Tool.getPicture();
                picture.setPictureBackground(colourPanel.index);
            } else {
                Log.warning("Choose picture background in global palette!");
            }
        }
    }

    private void paletteMenu(int n, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.createPaletteMenu();
        jPopupMenu.show(this.title, mouseEvent.getX(), 10);
    }

    private JPopupMenu createPaletteMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenu jMenu = ((DrawMenu)MainFrame.INSTANCE.getJMenuBar()).getPaletteMenu();
        Component[] componentArray = jMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JMenuItem) {
                DrawAction drawAction = (DrawAction)((JMenuItem)component).getAction();
                JMenuItem jMenuItem = new JMenuItem(drawAction);
                jMenuItem.setToolTipText(drawAction.getToolTipText());
                jPopupMenu.add(jMenuItem);
                continue;
            }
            jPopupMenu.addSeparator();
        }
        return jPopupMenu;
    }

    private void colourSelection(int n, MouseEvent mouseEvent) {
        ColourPanel colourPanel = (ColourPanel)mouseEvent.getSource();
        switch (n) {
            case 1: {
                Tool.getPicture().setForeground(colourPanel.index);
                if (mouseEvent.getClickCount() != 2) break;
                this.editColour(colourPanel.getBackground());
                break;
            }
            case 2: 
            case 3: {
                Tool.getPicture().setBackground(colourPanel.index);
                break;
            }
            default: {
                Assert.fail("gui: unknown button " + n);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        StatusPanel.INSTANCE.drawInfo(this.drawInfo(mouseEvent.getSource()));
    }

    private final String drawInfo(Object object) {
        if (object instanceof ColourPanel) {
            ColourPanel colourPanel = (ColourPanel)object;
            Color color = colourPanel.getForeground();
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            int n4 = color.getAlpha();
            StringBuffer stringBuffer = new StringBuffer("Colour #");
            stringBuffer.append(colourPanel.index);
            stringBuffer.append(" rgba(");
            stringBuffer.append(n);
            stringBuffer.append(",");
            stringBuffer.append(n2);
            stringBuffer.append(",");
            stringBuffer.append(n3);
            stringBuffer.append(",");
            stringBuffer.append(n4);
            stringBuffer.append(") ");
            stringBuffer.append(" hex(");
            stringBuffer.append(Util.hexString(n, 2));
            stringBuffer.append(",");
            stringBuffer.append(Util.hexString(n2, 2));
            stringBuffer.append(",");
            stringBuffer.append(Util.hexString(n3, 2));
            stringBuffer.append(",");
            stringBuffer.append(Util.hexString(n4, 2));
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

