/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Point;
import java.util.ArrayList;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawPixel;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.util.Assert;

public final class PixelTool
extends Tool {
    public static final PixelTool INSTANCE = new PixelTool();
    private ArrayList pixels = new ArrayList();
    private ArrayList oldColours = new ArrayList();
    private int currentColour;

    private PixelTool() {
    }

    public final void deactivate() {
        super.deactivate();
        this.pixels.clear();
        this.oldColours.clear();
    }

    public void pressed(int n, Point point, int n2) {
        if (point != null) {
            switch (n) {
                case 0: {
                    this.setPixel(point, Tool.getPicture().getForeground());
                    break;
                }
                case 1: {
                    this.setPixel(point, Tool.getPicture().getBackground());
                    break;
                }
                default: {
                    Assert.fail("gui: unknown button " + n);
                }
            }
        }
    }

    private void setPixel(Point point, int n) {
        Frame frame = PixelTool.getCurrentFrame();
        this.currentColour = n;
        int n2 = frame.getPixel(point.x, point.y);
        if (n2 != n) {
            this.pixels.add(point);
            this.oldColours.add(new Integer(n2));
            frame.setPixel(point.x, point.y, n);
        }
    }

    public void released(int n, Point point) {
        int n2 = this.pixels.size();
        if (n2 > 0) {
            Point[] pointArray = new Point[n2];
            this.pixels.toArray(pointArray);
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = (Integer)this.oldColours.get(i);
            }
            DrawPixel drawPixel = new DrawPixel(pointArray, this.currentColour, nArray);
            UndoManager.INSTANCE.addUndoable(drawPixel);
            this.pixels.clear();
            this.oldColours.clear();
        }
    }
}

