/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jdomain.jdraw.gui.DrawBrowser;
import jdomain.jdraw.gui.ICOHandler;
import jdomain.jdraw.gui.JDHandler;
import jdomain.jdraw.gui.MainFrame;
import jdomain.util.Log;
import jdomain.util.gui.AntialiasPanel;
import jdomain.util.gui.BrowserFilter;
import jdomain.util.gui.ScrollablePanel;
import jdomain.util.gui.StandardDialog;

public class SearchFrame
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LENGTH = 50;
    private static int rows;
    private static int columns;
    private static final int INSET = 4;
    private static final Font PLAIN;
    private static final BrowserFilter[] FILTER;
    private final JPanel settings = new JPanel(new GridBagLayout());
    private final JComboBox extBox = new JComboBox<BrowserFilter>(FILTER);
    private JTextField dirField;
    private JLabel info;
    private final IconListener listener = new IconListener();
    private int colCount = 0;
    private final GridBagConstraints grid = new GridBagConstraints();
    private JScrollPane pane;
    private String directory = DrawBrowser.INSTANCE.getOpenDir();
    private ScrollablePanel picPanel = new ScrollablePanel(new GridBagLayout(), 50, rows);
    private final JButton search = new JButton("Search");
    private final JButton browse = new JButton("Browse...");
    private String imageName = null;
    private final ICOHandler icoHandler = new ICOHandler();
    private final JDHandler jdHandler = new JDHandler();

    public SearchFrame() {
        super(MainFrame.INSTANCE, "Search Images...");
        this.setContentPane(this.main);
        this.setModal(true);
        this.createSettings();
        this.grid.insets = new Insets(4, 4, 4, 4);
        this.grid.anchor = 18;
        this.main.add((Component)this.settings, "North");
        this.picPanel.setBackground(Color.white);
        this.pane = new JScrollPane(this.picPanel);
        this.pane.getViewport().setBackground(Color.white);
        this.main.add((Component)this.pane, "Center");
        this.info = new JLabel(" ");
        this.info.setHorizontalAlignment(2);
        this.info.setBorder(new EmptyBorder(2, 10, 2, 10));
        this.getLeftButtonPanel().add(this.info);
        this.setDefaultBorder();
        this.setUndecorated(false);
        this.addButtonPanel();
        this.addRightButton(this.search);
        this.search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.search();
            }
        });
        this.addRightButton(this.getCancelButton());
        this.getCancelButton().setText("Close");
        this.getRootPane().setDefaultButton(this.search);
        this.extBox.setEditable(false);
        this.pane.setPreferredSize(new Dimension(columns * 50, rows * 50));
    }

    private final void createSettings() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.settings.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10)));
        JLabel jLabel = new JLabel("Directory: ");
        this.dirField = new JTextField(this.directory, 25);
        JLabel jLabel2 = new JLabel("Filter: ");
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.browse(SearchFrame.this.dirField);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.settings.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.settings.add((Component)this.dirField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.settings.add(Box.createHorizontalStrut(4), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.settings.add((Component)this.browse, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.settings.add(Box.createHorizontalStrut(8), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.settings.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.settings.add((Component)this.extBox, gridBagConstraints);
        ++gridBagConstraints.gridx;
    }

    private void info(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        final String string2 = string;
        Runnable runnable = new Runnable(){

            public void run() {
                SearchFrame.this.info.setText(string2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public String getImageName() {
        return this.imageName;
    }

    private ImageIcon getIcon(String string) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = this.icoHandler.canHandleImage(string) ? this.icoHandler.createIconLabel(string) : (this.jdHandler.canHandleImage(string) ? this.jdHandler.createIconLabel(string) : new ImageIcon(string));
        }
        catch (Exception exception) {
            Log.exception(exception);
        }
        return imageIcon;
    }

    public void addImage(String string) {
        Object object;
        ImageIcon imageIcon = this.getIcon(string);
        if (imageIcon == null) {
            return;
        }
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        if (n > 42 || n2 > 42) {
            object = imageIcon.getImage();
            object = n > n2 ? ((Image)object).getScaledInstance(42, -1, 4) : ((Image)object).getScaledInstance(-1, 42, 4);
            imageIcon = new ImageIcon((Image)object);
        }
        object = new JLabel(imageIcon);
        String string2 = string.substring(this.dirField.getText().trim().length());
        ((JComponent)object).setToolTipText(string2 + " (" + n + "x" + n2 + ")");
        ((Component)object).addMouseListener(this.listener);
        Object object2 = object;
        Runnable runnable = new Runnable((JLabel)object2){
            private final /* synthetic */ JLabel val$pic;
            {
                this.val$pic = jLabel;
            }

            public void run() {
                Dimension dimension = SearchFrame.this.pane.getSize();
                SearchFrame.this.colCount++;
                if (SearchFrame.this.colCount * 50 > dimension.width - 20) {
                    ((SearchFrame)SearchFrame.this).grid.gridx = 0;
                    ++((SearchFrame)SearchFrame.this).grid.gridy;
                    SearchFrame.this.colCount = 1;
                }
                SearchFrame.this.picPanel.add((Component)this.val$pic, SearchFrame.this.grid);
                ++((SearchFrame)SearchFrame.this).grid.gridx;
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void browse(JTextField jTextField) {
        String string = this.directory;
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.dirField.setText(jFileChooser.getSelectedFile().toString());
            this.search();
        }
    }

    private void open(String string) {
        this.imageName = string;
        this.approve();
    }

    private void search() {
        this.search.setEnabled(false);
        this.browse.setEnabled(false);
        String string = this.dirField.getText().trim();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
            this.dirField.setText(string);
        }
        this.picPanel.setVisible(false);
        this.picPanel.removeAll();
        this.picPanel.setVisible(true);
        this.colCount = 1;
        this.grid.gridx = 0;
        this.grid.gridy = 0;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                try {
                    object = new File(SearchFrame.this.dirField.getText().trim());
                    this.open((File)object);
                    SearchFrame.this.directory = SearchFrame.this.dirField.getText().trim();
                    SearchFrame.this.info("Search finished.");
                }
                catch (Exception exception) {
                    try {
                        exception.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        Runnable runnable = new Runnable(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                SearchFrame.access$1200(5.access$1100(this.this$1)).setEnabled(true);
                                SearchFrame.access$1300(5.access$1100(this.this$1)).setEnabled(true);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                        throw throwable;
                    }
                    Runnable runnable = new /* invalid duplicate definition of identical inner class */;
                    SwingUtilities.invokeLater(runnable);
                }
                object = new /* invalid duplicate definition of identical inner class */;
                SwingUtilities.invokeLater((Runnable)object);
            }

            private void open(File file) throws Exception {
                SearchFrame.this.info("Searching in " + file.toString() + "...");
                5.sleep(100L);
                File[] fileArray = file.listFiles();
                BrowserFilter browserFilter = (BrowserFilter)SearchFrame.this.extBox.getSelectedItem();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        this.open(fileArray[i]);
                        continue;
                    }
                    if (!browserFilter.accept(fileArray[i])) continue;
                    SearchFrame.this.addImage(fileArray[i].toString());
                }
            }

            static /* synthetic */ SearchFrame access$1100(5 var0) {
                return var0.SearchFrame.this;
            }
        };
        thread.start();
    }

    static /* synthetic */ JButton access$1200(SearchFrame searchFrame) {
        return searchFrame.browse;
    }

    static /* synthetic */ JButton access$1300(SearchFrame searchFrame) {
        return searchFrame.search;
    }

    static /* synthetic */ void access$1800(SearchFrame searchFrame, String string) {
        searchFrame.open(string);
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        dimension.width = (int)((double)dimension.width * 0.8);
        dimension.height = (int)((double)dimension.height * 0.8);
        columns = dimension.width / 50;
        rows = dimension.height / 50;
        PLAIN = new Font("SansSerif", 0, 12);
        FILTER = new BrowserFilter[]{DrawBrowser.ALL_IMAGES_READ_FILTER, DrawBrowser.DRAW_FILTER, DrawBrowser.GIF_FILTER, DrawBrowser.ICO_FILTER, DrawBrowser.JPG_FILTER, DrawBrowser.PNG_FILTER};
    }

    private final class IconListener
    extends MouseAdapter {
        private IconListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                JLabel jLabel = (JLabel)mouseEvent.getSource();
                String string = jLabel.getToolTipText();
                string = string.substring(0, string.indexOf(40) - 1);
                String string2 = SearchFrame.this.dirField.getText().trim();
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                string = string2 + string;
                StandardDialog standardDialog = new StandardDialog(SearchFrame.this, jLabel.getToolTipText(), false);
                standardDialog.setModal(true);
                AntialiasPanel antialiasPanel = standardDialog.main;
                ImageIcon imageIcon = SearchFrame.this.getIcon(string);
                JLabel jLabel2 = new JLabel(imageIcon);
                antialiasPanel.add((Component)jLabel2, "Center");
                JLabel jLabel3 = new JLabel(string);
                jLabel3.setBorder(new EmptyBorder(0, 0, 15, 0));
                jLabel3.setFont(PLAIN);
                antialiasPanel.add((Component)jLabel3, "North");
                antialiasPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
                standardDialog.setContentPane(antialiasPanel);
                JButton jButton = new JButton("Open");
                jButton.addActionListener(new ActionListener(this, standardDialog, jLabel3){
                    private final /* synthetic */ StandardDialog val$frame;
                    private final /* synthetic */ JLabel val$fLabel;
                    private final /* synthetic */ IconListener this$1;
                    {
                        this.this$1 = iconListener;
                        this.val$frame = standardDialog;
                        this.val$fLabel = jLabel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$frame.setVisible(false);
                        this.val$frame.dispose();
                        SearchFrame.access$1800(IconListener.access$1700(this.this$1), this.val$fLabel.getText());
                    }
                });
                standardDialog.addRightButton(jButton);
                standardDialog.getCancelButton().setText("Close");
                standardDialog.addRightButton(standardDialog.getCancelButton());
                jButton.setFocusPainted(false);
                standardDialog.setDefaultBorder();
                standardDialog.addButtonPanel();
                standardDialog.setUndecorated(false);
                standardDialog.getRootPane().setDefaultButton(jButton);
                standardDialog.open();
            }
        }

        static /* synthetic */ SearchFrame access$1700(IconListener iconListener) {
            return iconListener.SearchFrame.this;
        }
    }
}

