/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jdomain.jdraw.Settings;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.jdraw.gui.FillTool;
import jdomain.jdraw.gui.MainFrame;
import jdomain.util.Util;
import jdomain.util.gui.LinesBorder;
import jdomain.util.gui.WidgetFactory;

public class SettingsDialog
extends DrawDialog
implements DocumentListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private final JSlider qualitySlider = this.createSlider();
    private final JTextField qualityField = new JTextField(4);
    private boolean qualitySliderChanged;
    private boolean qualityFieldChanged;
    private final JTextField redField = new JTextField(6);
    private final JTextField greenField = new JTextField(6);
    private final JTextField blueField = new JTextField(6);
    private final JTextField alphaField = new JTextField(6);

    public SettingsDialog() {
        super("Settings");
        this.setUndecorated(false);
        WidgetFactory.addFocusAdapter(this.qualityField);
        this.setDefaultBorder();
        this.setModal(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.initComponents();
        CompoundBorder compoundBorder = new CompoundBorder(new EmptyBorder(6, 0, 2, 0), new LinesBorder(true, false, false, false));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 6);
        gridBagConstraints.gridwidth = 1;
        JLabel jLabel = new JLabel("<html><b>JPEG Quality&nbsp;<b></html>");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.qualitySlider, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.qualityField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(compoundBorder);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        JLabel jLabel2 = new JLabel("<html><b>Fill Tolerance</b></html>");
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        jLabel2 = new JLabel("<html><small>(0=none, 255=highest)</small>&nbsp;</html>", 4);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jLabel2 = new JLabel("<html>Red Tolerance:&nbsp;</html>", 4);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.redField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jLabel2 = new JLabel("<html>Green Tolerance:&nbsp;</html>", 4);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.greenField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jLabel2 = new JLabel("<html>Blue Tolerance:&nbsp;</html>", 4);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.blueField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jLabel2 = new JLabel("<html>Alpha Tolerance:&nbsp;</html>", 4);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.alphaField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        jPanel2 = new JPanel();
        jPanel2.setBorder(compoundBorder);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.main.add((Component)jPanel, "Center");
        this.addRightButton(this.getApproveButton());
        this.getRootPane().setDefaultButton(this.getApproveButton());
        this.addRightButton(this.getCancelButton());
        this.addButtonPanel();
        this.setFirstFocusComponent(this.qualityField);
    }

    private void initComponents() {
        this.qualitySlider.setValue((int)(Settings.INSTANCE.getJPEGQuality() * 100.0f));
        this.qualityField.setText(String.valueOf(this.qualitySlider.getValue()));
        this.qualitySlider.addChangeListener(this);
        this.qualityField.getDocument().addDocumentListener(this);
        FillTool.Tolerance tolerance = FillTool.INSTANCE.getTolerance();
        this.redField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.redField.setText(String.valueOf(tolerance.redDiff));
        this.redField.getDocument().addDocumentListener(this);
        this.greenField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.greenField.setText(String.valueOf(tolerance.greenDiff));
        this.greenField.getDocument().addDocumentListener(this);
        this.blueField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.blueField.setText(String.valueOf(tolerance.blueDiff));
        this.blueField.getDocument().addDocumentListener(this);
        this.alphaField.addFocusListener(WidgetFactory.TEXTFIELD_FOCUS_ADAPTER);
        this.alphaField.setText(String.valueOf(tolerance.alphaDiff));
        this.alphaField.getDocument().addDocumentListener(this);
    }

    public float getQuality() {
        float f = (float)this.qualitySlider.getValue() / 100.0f;
        return f;
    }

    public FillTool.Tolerance getTolerance() {
        int n = Util.asInt(this.redField.getText().trim());
        int n2 = Util.asInt(this.greenField.getText().trim());
        int n3 = Util.asInt(this.blueField.getText().trim());
        int n4 = Util.asInt(this.alphaField.getText().trim());
        return new FillTool.Tolerance(n, n2, n3, n4);
    }

    private JLabel createLabel(String string, int n) {
        JLabel jLabel = new JLabel();
        jLabel.setFont(MainFrame.TINY_FONT);
        if (string == null) {
            jLabel.setText(String.valueOf(n));
        } else {
            jLabel.setText(string);
        }
        return jLabel;
    }

    private JSlider createSlider() {
        JSlider jSlider = new JSlider(0, 0, 100, 100);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        jSlider.setMajorTickSpacing(10);
        jSlider.setMinorTickSpacing(5);
        jSlider.setPaintTicks(true);
        hashtable.put(new Integer(0), this.createLabel("Lowest", 0));
        hashtable.put(new Integer(50), this.createLabel("Medium", 50));
        hashtable.put(new Integer(100), this.createLabel("Highest", 100));
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintLabels(true);
        return jSlider;
    }

    private void checkInput() {
        boolean bl;
        String string = this.qualityField.getText().trim();
        if (!Util.isNumber(string)) {
            bl = false;
        } else {
            bl = Util.isIn(Util.asInt(string), 0, 100);
            if (!this.qualitySliderChanged && this.getApproveButton().isEnabled()) {
                this.qualityFieldChanged = true;
                this.qualitySlider.setValue(Util.asInt(string));
                this.qualityFieldChanged = false;
            }
        }
        String[] stringArray = new String[]{this.redField.getText().trim(), this.greenField.getText().trim(), this.blueField.getText().trim(), this.alphaField.getText().trim()};
        for (int i = 0; i < 4; ++i) {
            if (Util.isNumber(stringArray[i]) && Util.isIn(Util.asInt(stringArray[i]), 0, 255)) continue;
            bl = false;
            break;
        }
        this.getApproveButton().setEnabled(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkInput();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.qualityFieldChanged) {
            return;
        }
        this.qualitySliderChanged = true;
        this.qualityField.setText(String.valueOf(this.qualitySlider.getValue()));
        this.qualitySliderChanged = false;
    }
}

