/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.action.ToggleAntialiasAction;
import jdomain.jdraw.action.ToggleGradientFillAction;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gui.DrawMouseListener;
import jdomain.jdraw.gui.DrawPanel;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.FramePanel;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.PreviewPanel;
import jdomain.jdraw.gui.StatusPanel;
import jdomain.jdraw.gui.ToolPanel;
import jdomain.util.Log;
import jdomain.util.Util;

public abstract class Tool
implements KeyEventDispatcher,
DrawMouseListener {
    private static final int CLICKED = 5;
    protected static final int DRAG_LEFT = 16;
    protected static final int DRAG_MIDDLE = 8;
    protected static final int DRAG_RIGHT = 4;
    private static final int DRAGGED = 3;
    private static final int ENTERED = 0;
    private static final int EXITED = 1;
    public static final int LEFT_BUTTON = 0;
    private static final int MOVED = 4;
    protected static final int NO_BUTTON = 2;
    private static final int NONE = -1;
    private static final int PRESSED = 2;
    private static final int RELEASED = 6;
    public static final int RIGHT_BUTTON = 1;
    private boolean isDragged = false;
    protected int lastEventType = -1;
    protected int lastModifiers = 0;
    protected Point lastPoint = null;
    private boolean swallowKeys = false;
    protected boolean isActive = false;
    static /* synthetic */ Class class$jdomain$jdraw$action$ToggleAntialiasAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ToggleGradientFillAction;

    protected static final void drawInfo(Point point) {
        if (point == null) {
            StatusPanel.INSTANCE.drawInfo(null);
        } else {
            StringBuffer stringBuffer = new StringBuffer("(");
            stringBuffer.append(point.x);
            stringBuffer.append(",");
            stringBuffer.append(point.y);
            stringBuffer.append(") #");
            stringBuffer.append(Tool.getCurrentFrame().getPixel(point.x, point.y));
            StatusPanel.INSTANCE.drawInfo(stringBuffer.toString());
        }
    }

    protected static final int getButton(int n) {
        switch (n &= 0x1F) {
            case 1: 
            case 16: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return 1;
            }
        }
        return 2;
    }

    public static final PreviewPanel getPreview() {
        return PreviewPanel.INSTANCE;
    }

    public static final Frame getCurrentFrame() {
        return Tool.getPicture().getCurrentFrame();
    }

    public static final FramePanel getCurrentFramePanel() {
        return FolderPanel.INSTANCE.getCurrentFramePanel();
    }

    public static final Palette getCurrentPalette() {
        return Tool.getCurrentFrame().getPalette();
    }

    public static final Tool getCurrentTool() {
        return ToolPanel.INSTANCE.getCurrentTool();
    }

    protected static final Rectangle getDrawBounds(int n, int n2, int n3, int n4) {
        int n5 = Tool.getGrid();
        return new Rectangle(n *= n5, n2 *= n5, n3 *= n5, n4 *= n5);
    }

    protected static final Rectangle getDrawBounds(Rectangle rectangle) {
        return Tool.getDrawBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final DrawPanel getDrawPanel() {
        return Tool.getCurrentFramePanel().getDrawPanel();
    }

    protected static final Point getDrawPixel(int n, int n2) {
        int n3 = Tool.getGrid();
        return new Point(n *= n3, n2 *= n3);
    }

    public static final int getPictureHeight() {
        return Tool.getPicture().getHeight();
    }

    public static final int getPictureWidth() {
        return Tool.getPicture().getWidth();
    }

    public static final Dimension getPictureDimension() {
        return new Dimension(Tool.getPictureWidth(), Tool.getPictureHeight());
    }

    public static final int getGrid() {
        return FolderPanel.getGrid();
    }

    public static final Picture getPicture() {
        return MainFrame.INSTANCE.getPicture();
    }

    public static final Rectangle getRealBounds(int n, int n2, int n3, int n4) {
        int n5 = Tool.getGrid();
        return new Rectangle(n /= n5, n2 /= n5, n3 /= n5, n4 /= n5);
    }

    public static final Rectangle getRealBounds(Rectangle rectangle) {
        return Tool.getRealBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final Point getRealPixel(int n, int n2) {
        int n3 = Tool.getGrid();
        int n4 = Tool.getPictureWidth() - 1;
        int n5 = Tool.getPictureHeight() - 1;
        if ((n /= n3) < 0 || (n2 /= n3) < 0 || n > n4 || n2 > n5) {
            return null;
        }
        return new Point(n, n2);
    }

    protected static final Point getRealPixel(MouseEvent mouseEvent) {
        return Tool.getRealPixel(mouseEvent.getX(), mouseEvent.getY());
    }

    public static final Point getViewPoint() {
        return Tool.getCurrentFramePanel().getScrollPane().getViewport().getViewPosition();
    }

    public static final boolean isAntialiasOn() {
        boolean bl = ToolPanel.INSTANCE.getCurrentTool().supportsAntialias();
        ToggleAntialiasAction toggleAntialiasAction = (ToggleAntialiasAction)DrawAction.getAction(class$jdomain$jdraw$action$ToggleAntialiasAction == null ? (class$jdomain$jdraw$action$ToggleAntialiasAction = Tool.class$("jdomain.jdraw.action.ToggleAntialiasAction")) : class$jdomain$jdraw$action$ToggleAntialiasAction);
        return bl && toggleAntialiasAction.antialiasOn();
    }

    public static final boolean isGradientFillOn() {
        boolean bl = ToolPanel.INSTANCE.getCurrentTool().supportsGradientFill();
        ToggleGradientFillAction toggleGradientFillAction = (ToggleGradientFillAction)DrawAction.getAction(class$jdomain$jdraw$action$ToggleGradientFillAction == null ? (class$jdomain$jdraw$action$ToggleGradientFillAction = Tool.class$("jdomain.jdraw.action.ToggleGradientFillAction")) : class$jdomain$jdraw$action$ToggleGradientFillAction);
        return bl && toggleGradientFillAction.gradientFillOn();
    }

    public void activate() {
        if (!this.isActive) {
            if (Log.DEBUG) {
                Log.debug("- activated " + Util.shortClassName(this.getClass()));
            }
            this.isActive = true;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            this.attach();
        }
    }

    protected final void attach() {
        this.lastPoint = null;
    }

    public void deactivate() {
        if (this.isActive) {
            if (Log.DEBUG) {
                Log.debug("- deactivated " + Util.shortClassName(this.getClass()));
            }
            this.isActive = false;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            this.detach();
        }
    }

    protected final void detach() {
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return this.swallowKeys;
    }

    public boolean isDragged() {
        return this.isDragged;
    }

    private boolean isValidMousePressing(MouseEvent mouseEvent) {
        return this.lastModifiers == 0 && (mouseEvent.getModifiers() == 16 || mouseEvent.getModifiers() == 8 || mouseEvent.getModifiers() == 4);
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        this.isDragged = false;
        Point point = Tool.getRealPixel(mouseEvent);
        int n = Tool.getButton(mouseEvent.getButton());
        if (!this.skipPoint(5, point)) {
            Tool.drawInfo(point);
            this.clicked(n, point, mouseEvent.getModifiers());
        }
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        this.isDragged = true;
        Point point = Tool.getRealPixel(mouseEvent);
        int n = Tool.getButton(mouseEvent.getModifiers());
        if (!this.skipPoint(3, point)) {
            if (point != null) {
                Tool.drawInfo(point);
            }
            this.pressed(n, point, mouseEvent.getModifiers());
        }
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        Point point = Tool.getRealPixel(mouseEvent);
        int n = Tool.getButton(mouseEvent.getButton());
        if (!this.skipPoint(0, point)) {
            Tool.drawInfo(point);
            this.entered(n, point);
        }
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        Point point = Tool.getRealPixel(mouseEvent);
        int n = Tool.getButton(mouseEvent.getButton());
        if (!this.skipPoint(1, point)) {
            Tool.drawInfo(point);
            this.exited(n, point);
        }
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        this.isDragged = false;
        Point point = Tool.getRealPixel(mouseEvent);
        int n = Tool.getButton(mouseEvent.getButton());
        if (!this.skipPoint(4, point)) {
            Tool.drawInfo(point);
            this.moved(n, point);
        }
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        if (this.isValidMousePressing(mouseEvent)) {
            this.lastModifiers = mouseEvent.getModifiers();
            this.isDragged = false;
            Point point = Tool.getRealPixel(mouseEvent);
            int n = Tool.getButton(mouseEvent.getButton());
            if (!this.skipPoint(2, point)) {
                Tool.drawInfo(point);
                this.pressed(n, point, mouseEvent.getModifiers());
            }
        }
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & this.lastModifiers) > 0) {
            this.lastModifiers = 0;
            this.isDragged = false;
            Point point = Tool.getRealPixel(mouseEvent);
            int n = Tool.getButton(mouseEvent.getButton());
            if (!this.skipPoint(6, point)) {
                Tool.drawInfo(point);
                this.released(n, point);
            }
        }
    }

    protected void moved(int n, Point point) {
    }

    protected void pressed(int n, Point point, int n2) {
    }

    protected void clicked(int n, Point point, int n2) {
    }

    protected void released(int n, Point point) {
    }

    protected void entered(int n, Point point) {
    }

    protected void exited(int n, Point point) {
    }

    public void setSwallowKeys(boolean bl) {
        this.swallowKeys = bl;
    }

    private boolean skipPoint(int n, Point point) {
        boolean bl = true;
        if (this.lastEventType != n) {
            bl = false;
        } else if (point != null && !point.equals(this.lastPoint)) {
            bl = false;
        } else if (this.lastPoint != null && !this.lastPoint.equals(point)) {
            bl = false;
        }
        this.lastEventType = n;
        this.lastPoint = point;
        return bl;
    }

    public boolean supportsAntialias() {
        return false;
    }

    public boolean supportsGradientFill() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

