/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.gui.PixelTool;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Assert;
import jdomain.util.ResourceLoader;
import jdomain.util.gui.AntialiasPanel;

public final class ToolPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Insets INSETS = new Insets(1, 1, 0, 0);
    public static final int ICON_SIZE = 28;
    public static final ToolPanel INSTANCE = new ToolPanel();
    private static final Dimension BUTTON_DIMENSION = new Dimension(38, 38);
    private static final int SKIP = 8;
    private final HashMap toolMap = new HashMap();
    private Tool currentTool;
    public final ButtonGroup toolGroup = new ButtonGroup();
    private ToolButton antialiasButton;
    private ToolButton gradientFillButton;
    static /* synthetic */ Class class$jdomain$jdraw$action$ToggleAntialiasAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ToggleGradientFillAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SaveAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$LoadAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$UndoAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$RedoAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$AddFrameAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$RemoveFrameAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$ViewAnimationAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$CropAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetPixelToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetFillToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetColourPickerToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetLineToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetRectangleToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetFilledRectangleToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetOvalToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetFilledOvalToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetClipToolAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$SetTextToolAction;

    private ToolPanel() {
        super(new BorderLayout(6, 0));
        this.setBorder(new EmptyBorder(0, 0, 4, 0));
        this.currentTool = PixelTool.INSTANCE;
        this.createGui();
    }

    public Tool getCurrentTool() {
        return this.currentTool;
    }

    public void setCurrentTool(Tool tool, DrawAction drawAction) {
        if (this.currentTool != tool) {
            if (this.currentTool != null) {
                this.currentTool.deactivate();
            }
            this.currentTool = tool;
            ToolButton toolButton = (ToolButton)this.toolMap.get(drawAction);
            Assert.notNull(toolButton, "gui: tool button not found!");
            toolButton.setSelected(true);
            this.currentTool.activate();
            DrawAction.getAction(class$jdomain$jdraw$action$ToggleAntialiasAction == null ? (class$jdomain$jdraw$action$ToggleAntialiasAction = ToolPanel.class$("jdomain.jdraw.action.ToggleAntialiasAction")) : class$jdomain$jdraw$action$ToggleAntialiasAction).setEnabled(this.currentTool.supportsAntialias());
            DrawAction.getAction(class$jdomain$jdraw$action$ToggleGradientFillAction == null ? (class$jdomain$jdraw$action$ToggleGradientFillAction = ToolPanel.class$("jdomain.jdraw.action.ToggleGradientFillAction")) : class$jdomain$jdraw$action$ToggleGradientFillAction).setEnabled(this.currentTool.supportsGradientFill());
        }
    }

    private void createGui() {
        JPanel jPanel = this.createClickBar();
        this.add((Component)jPanel, "West");
        JScrollPane jScrollPane = new JScrollPane(Tool.getPreview());
        Border border = jScrollPane.getBorder();
        jScrollPane.setBorder(new CompoundBorder(new TitledBorder("Preview"), border));
        jScrollPane.setPreferredSize(new Dimension(10, 10));
        this.add((Component)jScrollPane, "Center");
    }

    private JPanel createClickBar() {
        AntialiasPanel antialiasPanel = new AntialiasPanel(new GridBagLayout());
        JPanel jPanel = this.createTools();
        JPanel jPanel2 = this.createActions();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        antialiasPanel.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        antialiasPanel.add((Component)jPanel, gridBagConstraints);
        return antialiasPanel;
    }

    private JPanel createActions() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Shortcuts"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = INSETS;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ActionButton actionButton = new ActionButton(DrawAction.getAction(class$jdomain$jdraw$action$SaveAction == null ? (class$jdomain$jdraw$action$SaveAction = ToolPanel.class$("jdomain.jdraw.action.SaveAction")) : class$jdomain$jdraw$action$SaveAction), "save.png");
        jPanel.add((Component)actionButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        actionButton = new ActionButton(DrawAction.getAction(class$jdomain$jdraw$action$LoadAction == null ? (class$jdomain$jdraw$action$LoadAction = ToolPanel.class$("jdomain.jdraw.action.LoadAction")) : class$jdomain$jdraw$action$LoadAction), "open.png");
        jPanel.add((Component)actionButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        actionButton = new ActionButton(DrawAction.getAction(class$jdomain$jdraw$action$UndoAction == null ? (class$jdomain$jdraw$action$UndoAction = ToolPanel.class$("jdomain.jdraw.action.UndoAction")) : class$jdomain$jdraw$action$UndoAction), "undo.png");
        jPanel.add((Component)actionButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        actionButton = new ActionButton(DrawAction.getAction(class$jdomain$jdraw$action$RedoAction == null ? (class$jdomain$jdraw$action$RedoAction = ToolPanel.class$("jdomain.jdraw.action.RedoAction")) : class$jdomain$jdraw$action$RedoAction), "redo.png");
        jPanel.add((Component)actionButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        actionButton = new ActionButton(DrawAction.getAction(class$jdomain$jdraw$action$AddFrameAction == null ? (class$jdomain$jdraw$action$AddFrameAction = ToolPanel.class$("jdomain.jdraw.action.AddFrameAction")) : class$jdomain$jdraw$action$AddFrameAction), "frame_new.png");
        jPanel.add((Component)actionButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        actionButton = new ActionButton(DrawAction.getAction(class$jdomain$jdraw$action$RemoveFrameAction == null ? (class$jdomain$jdraw$action$RemoveFrameAction = ToolPanel.class$("jdomain.jdraw.action.RemoveFrameAction")) : class$jdomain$jdraw$action$RemoveFrameAction), "delete_frame.png");
        jPanel.add((Component)actionButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        actionButton = new ActionButton(DrawAction.getAction(class$jdomain$jdraw$action$ViewAnimationAction == null ? (class$jdomain$jdraw$action$ViewAnimationAction = ToolPanel.class$("jdomain.jdraw.action.ViewAnimationAction")) : class$jdomain$jdraw$action$ViewAnimationAction), "view_anim.png");
        jPanel.add((Component)actionButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        actionButton = new ActionButton(DrawAction.getAction(class$jdomain$jdraw$action$CropAction == null ? (class$jdomain$jdraw$action$CropAction = ToolPanel.class$("jdomain.jdraw.action.CropAction")) : class$jdomain$jdraw$action$CropAction), "crop.png");
        jPanel.add((Component)actionButton, gridBagConstraints);
        return jPanel;
    }

    public void selectAntialias(boolean bl) {
        this.antialiasButton.setSelected(bl);
    }

    public void selectGradientFill(boolean bl) {
        this.gradientFillButton.setSelected(bl);
    }

    private JPanel createTools() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Tools"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = INSETS;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ToolButton toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetPixelToolAction == null ? (class$jdomain$jdraw$action$SetPixelToolAction = ToolPanel.class$("jdomain.jdraw.action.SetPixelToolAction")) : class$jdomain$jdraw$action$SetPixelToolAction), "pixel_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        this.toolGroup.setSelected(toolButton.getModel(), true);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetFillToolAction == null ? (class$jdomain$jdraw$action$SetFillToolAction = ToolPanel.class$("jdomain.jdraw.action.SetFillToolAction")) : class$jdomain$jdraw$action$SetFillToolAction), "fill_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetColourPickerToolAction == null ? (class$jdomain$jdraw$action$SetColourPickerToolAction = ToolPanel.class$("jdomain.jdraw.action.SetColourPickerToolAction")) : class$jdomain$jdraw$action$SetColourPickerToolAction), "colorpicker.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetLineToolAction == null ? (class$jdomain$jdraw$action$SetLineToolAction = ToolPanel.class$("jdomain.jdraw.action.SetLineToolAction")) : class$jdomain$jdraw$action$SetLineToolAction), "line_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add(Box.createHorizontalStrut(8), gridBagConstraints);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$ToggleGradientFillAction == null ? (class$jdomain$jdraw$action$ToggleGradientFillAction = ToolPanel.class$("jdomain.jdraw.action.ToggleGradientFillAction")) : class$jdomain$jdraw$action$ToggleGradientFillAction), "gradient_fill.png");
        jPanel.add((Component)toolButton, gridBagConstraints);
        this.gradientFillButton = toolButton;
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$ToggleAntialiasAction == null ? (class$jdomain$jdraw$action$ToggleAntialiasAction = ToolPanel.class$("jdomain.jdraw.action.ToggleAntialiasAction")) : class$jdomain$jdraw$action$ToggleAntialiasAction), "antialias_on.png");
        jPanel.add((Component)toolButton, gridBagConstraints);
        this.antialiasButton = toolButton;
        toolButton.setSelected(true);
        toolButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                if (jToggleButton.isSelected()) {
                    jToggleButton.setIcon(ResourceLoader.getImage("jdomain/jdraw/images/antialias_on.png", 28));
                } else {
                    jToggleButton.setIcon(ResourceLoader.getImage("jdomain/jdraw/images/antialias_off.png", 28));
                }
            }
        });
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetRectangleToolAction == null ? (class$jdomain$jdraw$action$SetRectangleToolAction = ToolPanel.class$("jdomain.jdraw.action.SetRectangleToolAction")) : class$jdomain$jdraw$action$SetRectangleToolAction), "rectangle_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetFilledRectangleToolAction == null ? (class$jdomain$jdraw$action$SetFilledRectangleToolAction = ToolPanel.class$("jdomain.jdraw.action.SetFilledRectangleToolAction")) : class$jdomain$jdraw$action$SetFilledRectangleToolAction), "filled_rectangle_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetOvalToolAction == null ? (class$jdomain$jdraw$action$SetOvalToolAction = ToolPanel.class$("jdomain.jdraw.action.SetOvalToolAction")) : class$jdomain$jdraw$action$SetOvalToolAction), "oval_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetFilledOvalToolAction == null ? (class$jdomain$jdraw$action$SetFilledOvalToolAction = ToolPanel.class$("jdomain.jdraw.action.SetFilledOvalToolAction")) : class$jdomain$jdraw$action$SetFilledOvalToolAction), "filled_oval_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add(Box.createHorizontalStrut(8), gridBagConstraints);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetClipToolAction == null ? (class$jdomain$jdraw$action$SetClipToolAction = ToolPanel.class$("jdomain.jdraw.action.SetClipToolAction")) : class$jdomain$jdraw$action$SetClipToolAction), "clip_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        toolButton = new ToolButton(DrawAction.getAction(class$jdomain$jdraw$action$SetTextToolAction == null ? (class$jdomain$jdraw$action$SetTextToolAction = ToolPanel.class$("jdomain.jdraw.action.SetTextToolAction")) : class$jdomain$jdraw$action$SetTextToolAction), "text_tool.png");
        this.toolGroup.add(toolButton);
        jPanel.add((Component)toolButton, gridBagConstraints);
        return jPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class ActionButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public ActionButton(DrawAction drawAction, String string) {
            super(drawAction);
            this.setFocusPainted(false);
            this.setToolTipText(drawAction.getToolTipText());
            this.setText(null);
            this.setIcon(ResourceLoader.getImage("jdomain/jdraw/images/" + string, 28));
        }

        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        public Dimension getPreferredSize() {
            return BUTTON_DIMENSION;
        }
    }

    public final class ToolButton
    extends JToggleButton {
        private static final long serialVersionUID = 1L;

        public ToolButton(DrawAction drawAction, String string) {
            super(drawAction);
            ToolPanel.this.toolMap.put(drawAction, this);
            this.setFocusPainted(false);
            this.setToolTipText(drawAction.getToolTipText());
            this.setText(null);
            this.setIcon(ResourceLoader.getImage("jdomain/jdraw/images/" + string, 28));
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        public Dimension getPreferredSize() {
            return BUTTON_DIMENSION;
        }
    }
}

