/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.filechooser.FileFilter;

public class BrowserFilter
extends FileFilter {
    private String prefix;
    private String description;
    protected final TreeSet extensions = new TreeSet();

    protected BrowserFilter(String string, String[] stringArray) {
        this.setExtensions(stringArray);
        this.setPrefix(string);
    }

    public static final BrowserFilter createFilter(String string, String[] stringArray) {
        return new BrowserFilter(string, stringArray);
    }

    public final ArrayList getExtensions() {
        return new ArrayList(this.extensions);
    }

    private final void setExtensions(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.extensions.add(stringArray[i]);
        }
    }

    public void addExtensions(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.extensions.add(stringArray[i]);
        }
        this.updateDescription();
    }

    public final boolean accept(File file) {
        boolean bl = this.doAccept(file);
        return bl;
    }

    public final String getFirstExtension() {
        return (String)this.extensions.iterator().next();
    }

    protected boolean doAccept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName();
        String string2 = null;
        int n = string.length();
        Iterator iterator = this.extensions.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            int n2 = string2.length();
            if (n <= n2 || !string.substring(n - n2).equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setPrefix(String string) {
        this.prefix = string;
        this.updateDescription();
    }

    private final void updateDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.prefix);
        stringBuffer.append("  (");
        Iterator iterator = this.extensions.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" *");
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append(" )");
        this.description = stringBuffer.toString();
    }

    public final String toString() {
        return this.getDescription();
    }
}

