/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import jdomain.util.BrowserLauncher;

public final class LinkLabel
extends JLabel {
    private static final long serialVersionUID = 0L;
    private static final ActionListener BROWSER_ACTION = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BrowserLauncher.openURL(((LinkLabel)actionEvent.getSource()).getURL());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    };
    private ActionListener actionListener = BROWSER_ACTION;
    private boolean underline;
    private String url;

    public LinkLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.setup();
    }

    public LinkLabel(String string, int n) {
        super(string, n);
        this.setup();
    }

    public LinkLabel(String string) {
        super(string);
        this.setup();
    }

    public LinkLabel(Icon icon, int n) {
        super(icon, n);
        this.setup();
    }

    public LinkLabel(Icon icon) {
        super(icon);
        this.setup();
    }

    public LinkLabel() {
        this.setup();
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    private void setup() {
        this.url = this.getText();
        this.setForeground(Color.BLUE);
        this.setHorizontalAlignment(2);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                LinkLabel.this.underline = true;
                LinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
                LinkLabel.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                LinkLabel.this.underline = false;
                LinkLabel.this.setCursor(Cursor.getPredefinedCursor(0));
                LinkLabel.this.repaint();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (LinkLabel.this.actionListener != null && mouseEvent.getButton() == 1) {
                    LinkLabel.this.actionListener.actionPerformed(new ActionEvent(LinkLabel.this, 0, ""));
                }
            }
        });
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.underline) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            Rectangle rectangle = new Rectangle(dimension);
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            SwingUtilities.layoutCompoundLabel(fontMetrics, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, this.getIconTextGap());
            graphics.setColor(this.getForeground());
            int n = rectangle3.x;
            int n2 = rectangle3.y + rectangle3.height - 1;
            int n3 = n + rectangle3.width - 1;
            graphics.drawLine(n, n2, n3, n2);
        }
    }
}

