/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.BorderLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jdomain.util.Log;
import jdomain.util.Util;
import jdomain.util.gui.GUIUtil;

public class StandardMainFrame
extends JFrame
implements KeyEventDispatcher,
WindowFocusListener {
    private static final long serialVersionUID = 0L;
    private boolean ignoreKeys = true;

    public StandardMainFrame(String string) {
        super(string);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.setupSize();
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                StandardMainFrame.this.opened();
            }

            public void windowClosing(WindowEvent windowEvent) {
                StandardMainFrame.this.closing();
            }
        };
        this.addWindowListener(windowAdapter);
        this.addWindowFocusListener(this);
        this.initGui();
        this.setDefaultCloseOperation(3);
    }

    protected void setupSize() {
        Rectangle rectangle = GUIUtil.getGeometry();
        this.setSize(rectangle.width, rectangle.height);
        this.setLocation(rectangle.x, rectangle.y);
    }

    protected void opened() {
        if (System.getProperty("geometry") == null) {
            this.setExtendedState(6);
        }
    }

    protected void closing() {
        Log.close();
    }

    private final void initGui() {
        ((JComponent)this.getContentPane()).setLayout(new BorderLayout(4, 0));
    }

    protected void createGui() {
    }

    protected final String keyDesc(char c, int n) {
        return "'" + c + "' (0x" + Util.hexString(c) + "), modifiers = " + "0x" + Util.hexString(n);
    }

    public final boolean isIconfied() {
        return (this.getExtendedState() & 1) != 0;
    }

    protected boolean handleKey(KeyEvent keyEvent) {
        return false;
    }

    public final boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.ignoreKeys || !this.isActive()) {
            return false;
        }
        return this.handleKey(keyEvent);
    }

    private final void setIgnoreKeys(boolean bl) {
        this.ignoreKeys = bl;
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        this.setIgnoreKeys(false);
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        this.setIgnoreKeys(true);
    }
}

