/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.text.NumberFormat;
import java.util.Locale;

class ScanGui
extends CloseableFrame {
    static final int XORIG = 50;
    static final int YORIG = 100;
    static final int XPREV = 300;
    static final int YPREV = 100;
    static final int TFLEN = 30;
    static final String tmp_scan_file = "tmp.pnm";
    static ScanGui reference;
    ScanParam param;
    ScanParameters sps;
    ScanFile sf;
    Show sw;
    Settings st;
    Configure cfg;
    Viewer vw;
    DcxFile dc;
    DiscreteOption scanMode;
    String pcx_base;
    String full_base;
    String pcx_file;
    String save_path;
    String viewer_path = new String("D:\\PMVIEW\\PMVIEW.EXE");
    String viewer_options = new String("/Wpos(30p,10p,40p,70p,For)");
    String device = new String("hp");
    Checkbox units = new Checkbox("  Metric");
    Checkbox chk_apnd;
    boolean preview;
    boolean pending = false;
    TextField tf_file;
    TextField tf_dir;
    TextField tf_page;
    Label lbl_file;
    Label lbl_dir;
    TextField tf_bright;
    TextField tf_contrast;
    TextField[] tf_orig;
    TextField[] tf_size;
    TextField[] tf_res;
    TextField tf_status = new TextField(60);
    Font tffont;
    ScanGuiListener sl;
    RestoreListener rl;
    DeleteListener dl;
    SetFontListener fl;
    Menu restore_menu;
    Menu delete_menu;
    Menu help_font_menu;
    String help_font = "SansSerif";
    Font mfnt;
    TextField tf_fname = new TextField("");
    Panel pright;
    BoxedPanel p3right;
    Color bgcolor = new Color(110, 140, 160);
    Color ltcolor = this.bgcolor.brighter();

    public static ScanGui getReference() {
        return reference;
    }

    void compose(Panel panel) {
        panel.removeAll();
        panel.add(new Label(""));
        panel.add(new Label("x"));
        panel.add(new Label("y"));
        String string = this.units.getState() ? "mm" : "in.";
        panel.add(new Label("Size(" + string + ")"));
        panel.add(this.tf_size[0]);
        panel.add(this.tf_size[1]);
        panel.add(new Label("Origen(" + string + ")"));
        panel.add(this.tf_orig[0]);
        panel.add(this.tf_orig[1]);
        panel.add(new Label("Res.(dpi)"));
        panel.add(this.tf_res[0]);
        panel.add(this.tf_res[1]);
        panel.invalidate();
    }

    void refreshSettings() {
        this.pright.removeAll();
        this.pright.add(this.scanMode);
        this.pright.add(this.sps);
        this.pright.add(this.p3right);
        this.pright.validate();
    }

    TextField[] xyTextFields(String string, String string2) {
        TextField[] textFieldArray = new TextField[2];
        int n = 3;
        textFieldArray[0] = new TextField(string, n);
        textFieldArray[1] = new TextField(string2, n);
        textFieldArray[0].setFont(this.tffont);
        textFieldArray[1].setFont(this.tffont);
        return textFieldArray;
    }

    void addbtn(Container container, String string, ScanGuiListener scanGuiListener) {
        Button button = new Button(string);
        button.addActionListener(scanGuiListener);
        container.add(button);
    }

    static void addmiTo(Menu menu, String string, Font font, ActionListener actionListener) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setFont(font);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
    }

    static Menu subMenuFor(Menu menu, String string, Font font) {
        Menu menu2 = new Menu(string);
        menu2.setFont(font);
        menu.add(menu2);
        return menu2;
    }

    void addSettingsTo(Menu menu, Menu menu2) {
        File file = new File(".");
        ScanGui scanGui = this;
        if (scanGui == null) {
            throw null;
        }
        FilenameFilter filenameFilter = new FilenameFilter(scanGui){
            private final /* synthetic */ ScanGui this$0;

            public boolean accept(File file, String string) {
                return string.endsWith(".set");
            }
            {
                this.this$0 = scanGui;
                this.constructor$0(scanGui);
            }

            private final void constructor$0(ScanGui scanGui) {
            }
        };
        String[] stringArray = file.list(filenameFilter);
        menu.removeAll();
        menu2.removeAll();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].substring(0, stringArray[n].indexOf(46));
            ScanGui.addmiTo(menu, string, this.mfnt, this.rl);
            ScanGui.addmiTo(menu2, string, this.mfnt, this.dl);
            ++n;
        }
    }

    void addFontsTo(Menu menu) {
        String[] stringArray = this.getToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            ScanGui.addmiTo(menu, stringArray[n], this.mfnt, this.fl);
            ++n;
        }
    }

    boolean exists(String string, String string2) {
        File file = new File(string + "." + string2);
        return file.exists();
    }

    void setPage(int n) {
        ((TextComponent)this.tf_page).setText(Integer.toString(n));
    }

    void increment(TextField textField, int n) {
        ((TextComponent)textField).setText(String.valueOf(Integer.parseInt(textField.getText().trim()) + n));
    }

    String getResponse(String string, String string2) {
        TextField textField = new TextField(30);
        ((TextComponent)textField).setText(string2);
        PopupDialog popupDialog = new PopupDialog((Frame)this, textField, string);
        return textField.getText();
    }

    boolean pathValid(String string) {
        File file = new File(string);
        if (file.exists()) {
            return true;
        }
        String[] stringArray = new String[]{string, "Directory does not exist.", "Create?"};
        String[] stringArray2 = new String[]{"Yes", "No"};
        ButtonDialog buttonDialog = new ButtonDialog((Frame)this, stringArray, stringArray2);
        if (buttonDialog.getButtonLabel().equals("Yes")) {
            file.mkdir();
            return true;
        }
        return false;
    }

    void changePath() {
        int n;
        String string = this.getResponse("Image directory", this.save_path);
        if (string.charAt(n = string.length() - 1) == File.separatorChar) {
            string = string.substring(0, n);
        }
        if (this.pathValid(string)) {
            this.setPath(string);
        }
    }

    void setPath(String string) {
        this.save_path = string;
        this.lbl_dir.setText(this.save_path);
        this.validate();
    }

    void setStatusText(String string) {
        ((TextComponent)this.tf_status).setText(string);
    }

    void preview() {
        this.preview = true;
        this.pending = false;
        this.pcx_base = "";
        this.do_scan();
    }

    void scan() {
        this.preview = false;
        this.pending = false;
        this.pcx_base = "";
        this.do_scan();
    }

    void scansave() {
        if (this.vw != null) {
            this.vw.kill();
        }
        this.pcx_base = this.tf_file.getText().trim();
        if (this.pcx_base.length() == 0) {
            PopupDialog popupDialog = new PopupDialog((Frame)this, this.tf_fname, "Save file name");
            String string = this.tf_fname.getText().trim();
            if (string.length() > 0) {
                ((TextComponent)this.tf_file).setText(string);
                this.scansave();
            }
        } else {
            this.full_base = this.save_path + File.separator + this.pcx_base;
            if (!this.chk_apnd.getState()) {
                this.pending = false;
                if (this.exists(this.full_base, "pcx") | this.exists(this.pcx_base, "dcx")) {
                    String[] stringArray = new String[]{"Overwrite file?"};
                    String[] stringArray2 = new String[]{"No", "Yes"};
                    ButtonDialog buttonDialog = new ButtonDialog((Frame)this, stringArray, stringArray2);
                    if (buttonDialog.getButtonLabel().equals("No")) {
                        return;
                    }
                }
            } else {
                if (this.scanMode.getItemLabel().toUpperCase().indexOf("BLACK") == -1) {
                    String[] stringArray = new String[]{"Appended scans that are not", "Black and White", "may not be viewable"};
                    String[] stringArray3 = new String[]{"Continue", "Cancel"};
                    ButtonDialog buttonDialog = new ButtonDialog((Frame)this, stringArray, stringArray3);
                    if (buttonDialog.getButtonLabel().equals("Cancel")) {
                        return;
                    }
                }
                this.pending = true;
                this.dc = new DcxFile(this.full_base);
                if (!this.exists(this.full_base, "dcx")) {
                    this.dc.make_dcx();
                    if (this.exists(this.full_base, "pcx")) {
                        this.setPage(this.dc.add_pcx());
                    }
                }
            }
            this.preview = false;
            this.do_scan();
        }
    }

    void do_scan() {
        if (this.preview) {
            this.vw.setFile(null);
        } else {
            this.vw.setFile(tmp_scan_file);
        }
        if (this.sw != null) {
            this.sw.dispose();
        }
        if (this.preview) {
            ((TextComponent)this.tf_status).setText("Preview scan");
        } else {
            ((TextComponent)this.tf_status).setText("Scanning at " + this.tf_res[0].getText() + " x " + this.tf_res[1].getText() + " resolution");
        }
        this.param = new ScanParam(this);
        this.sf = new ScanFile(this.param, this.sps, this);
        if (!this.sf.scanImage()) {
            return;
        }
        this.sf.readScannedImage();
        if (this.pending) {
            this.pending = false;
            this.setPage(this.dc.add_pcx());
        } else {
            this.setPage(0);
        }
        this.sw = new Show(this, this.sf, this.param);
        this.sw.pack();
        ((Component)this.sw).setLocation(350, 200);
        this.sw.show();
        ((TextComponent)this.tf_status).setText("Finished");
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.quit();
    }

    void quit() {
        this.vw.kill();
        System.exit(0);
    }

    public void setCoordinates(int n, int n2, int n3, int n4) {
        double d = this.sf.reduce.width * n;
        double d2 = this.sf.reduce.width * n3;
        double d3 = this.sf.reduce.height * n2;
        double d4 = this.sf.reduce.height * n4;
        double d5 = d / (double)this.param.resolution.width * this.param.resScale;
        double d6 = d3 / (double)this.param.resolution.height * this.param.resScale;
        d5 += this.param.origmm.width / this.param.mm;
        d6 += this.param.origmm.height / this.param.mm;
        double d7 = (d2 - d) / (double)this.param.resolution.width * this.param.resScale;
        double d8 = (d4 - d3) / (double)this.param.resolution.height * this.param.resScale;
        double d9 = 0.2;
        d7 = Math.max(d9, d7);
        d8 = Math.max(d9, d8);
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(2);
        ((TextComponent)this.tf_orig[0]).setText(numberFormat.format(d5));
        ((TextComponent)this.tf_orig[1]).setText(numberFormat.format(d6));
        ((TextComponent)this.tf_size[0]).setText(numberFormat.format(d7));
        ((TextComponent)this.tf_size[1]).setText(numberFormat.format(d8));
    }

    public ScanGui() {
        super("JSane");
        reference = this;
        this.cfg = new Configure(this);
        this.tf_status.setFont(new Font("SansSerif", 1, 12));
        ((Component)this.tf_status).setBackground(this.ltcolor);
        this.tffont = new Font("SansSerif", 1, 12);
        ((Component)this).setBackground(this.bgcolor);
        ((Component)this).setFont(new Font("SansSerif", 1, 16));
        ScanGui scanGui = this;
        if (scanGui == null) {
            throw null;
        }
        this.sl = scanGui.new ScanGuiListener();
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu menu = new Menu("Settings");
        this.mfnt = new Font("SansSerif", 1, 12);
        menu.setFont(this.mfnt);
        menuBar.add(menu);
        ScanGui scanGui2 = this;
        if (scanGui2 == null) {
            throw null;
        }
        MenuListener menuListener = scanGui2.new MenuListener();
        ScanGui.addmiTo(menu, "Default", this.mfnt, menuListener);
        ScanGui.addmiTo(menu, "Fax", this.mfnt, menuListener);
        menu.addSeparator();
        ScanGui.addmiTo(menu, "Save Settings", this.mfnt, menuListener);
        this.restore_menu = ScanGui.subMenuFor(menu, "Restore", this.mfnt);
        this.delete_menu = ScanGui.subMenuFor(menu, "Delete", this.mfnt);
        ScanGui scanGui3 = this;
        if (scanGui3 == null) {
            throw null;
        }
        this.rl = scanGui3.new RestoreListener();
        ScanGui scanGui4 = this;
        if (scanGui4 == null) {
            throw null;
        }
        this.dl = scanGui4.new DeleteListener();
        this.addSettingsTo(this.restore_menu, this.delete_menu);
        menu.addSeparator();
        ScanGui.addmiTo(menu, "Change Directory", this.mfnt, menuListener);
        menu.addSeparator();
        ScanGui.addmiTo(menu, "Quit", this.mfnt, menuListener);
        Menu menu2 = new Menu("Configure");
        menu2.setFont(this.mfnt);
        menuBar.add(menu2);
        ScanGui.addmiTo(menu2, "Viewer path", this.mfnt, menuListener);
        ScanGui.addmiTo(menu2, "Viewer options", this.mfnt, menuListener);
        ScanGui.addmiTo(menu2, "Device", this.mfnt, menuListener);
        ScanGui.addmiTo(menu2, "Units", this.mfnt, menuListener);
        menu2.addSeparator();
        ScanGui.addmiTo(menu2, "Save", this.mfnt, menuListener);
        Menu menu3 = new Menu("Help");
        menu3.setFont(this.mfnt);
        menuBar.add(menu3);
        ScanGui.addmiTo(menu3, "Notes", this.mfnt, menuListener);
        ScanGui.addmiTo(menu3, "About", this.mfnt, menuListener);
        menu3.addSeparator();
        this.help_font_menu = ScanGui.subMenuFor(menu3, "Font", this.mfnt);
        ScanGui scanGui5 = this;
        if (scanGui5 == null) {
            throw null;
        }
        this.fl = scanGui5.new SetFontListener();
        this.addFontsTo(this.help_font_menu);
        Panel panel = new Panel(new ArrayLayout(2, 0, 0, 1, true, true));
        panel.setBackground(this.ltcolor);
        this.add((Component)panel, "Center");
        Panel panel2 = new Panel(new ArrayLayout(1, 0, 0));
        panel.add(panel2);
        this.pright = new Panel(new ArrayLayout(1, 0, 5));
        panel.add(this.pright);
        BoxedPanel boxedPanel = new BoxedPanel();
        boxedPanel.setLayout(new ArrayLayout(1, 5, 5));
        panel2.add(boxedPanel);
        Panel panel3 = new Panel(new GridLayout(4, 2));
        panel2.add(panel3);
        this.save_path = System.getProperty("user.dir") + File.separator + "Images";
        this.lbl_dir = new ZLabel(this.save_path);
        this.lbl_dir.setFont(this.tffont);
        this.tf_dir = new TextField(30);
        this.lbl_file = new Label("File name");
        this.tf_file = new TextField(20);
        this.tf_page = new TextField("0", 2);
        this.tf_file.setFont(this.tffont);
        this.tf_dir.setFont(this.tffont);
        this.tf_page.setFont(this.tffont);
        this.chk_apnd = new Checkbox("Append", false);
        boxedPanel.add(this.lbl_dir);
        Panel panel4 = new Panel();
        panel4.add(this.lbl_file);
        panel4.add(this.tf_file);
        boxedPanel.add(panel4);
        Panel panel5 = new Panel();
        panel5.add(this.chk_apnd);
        panel5.add(new Label("  No. of pages"));
        panel5.add(this.tf_page);
        boxedPanel.add(panel5);
        this.addbtn(panel3, "Preview", this.sl);
        this.addbtn(panel3, "Scan", this.sl);
        this.addbtn(panel3, "Scan/Save", this.sl);
        this.addbtn(panel3, "Redisplay", this.sl);
        this.addbtn(panel3, "View/Print", this.sl);
        this.addbtn(panel3, "Browse", this.sl);
        this.device = this.device.trim();
        String string = this.device + ".options";
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " does not exist");
            this.device = this.getResponse("Replace with a valid device name", this.device);
            this.device = this.device.trim();
            file = new File(this.device + ".options");
            if (!file.exists()) {
                System.exit(1);
            } else {
                this.cfg.save();
            }
        }
        OptionFile optionFile = new OptionFile(file);
        this.sps = new ScanParameters(optionFile);
        this.scanMode = this.sps.mode;
        this.p3right = new BoxedPanel();
        this.p3right.setLayout(new ArrayLayout(3, 5, 5));
        this.add((Component)this.tf_status, "South");
        ((Component)this).setLocation(50, 100);
        this.st = new Settings();
        this.vw = new Viewer(this);
        this.tf_size = this.units.getState() ? this.xyTextFields("215.8", "279.3") : this.xyTextFields("8.5", "11.0");
        this.tf_orig = this.xyTextFields("0.0", "0.0");
        this.tf_res = this.xyTextFields("300", "300");
        this.st.load("Default.set");
        if (!this.pathValid(this.save_path)) {
            this.setPath(System.getProperty("user.dir"));
        }
        this.compose(this.p3right);
        this.refreshSettings();
    }

    class ScanGuiListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Redisplay")) {
                if (ScanGui.this.sf != null && ScanGui.this.param != null && ScanGui.this.sw == null) {
                    ScanGui.this.sw = new Show(ScanGui.this, ScanGui.this.sf, ScanGui.this.param);
                    ScanGui.this.sw.pack();
                    ((Component)ScanGui.this.sw).setLocation(350, 200);
                    ScanGui.this.sw.show();
                }
            } else if (string.equals("Preview")) {
                ScanGui.this.preview();
            } else if (string.equals("Scan")) {
                ScanGui.this.scan();
            } else if (string.equals("Scan/Save")) {
                ScanGui.this.scansave();
            } else if (string.equals("View/Print")) {
                ScanGui.this.vw.view();
            } else if (string.equals("Browse")) {
                ScanGui.this.vw.browse();
            } else if (string.equals("Quit")) {
                ScanGui.this.quit();
            } else if (string.equals("<0")) {
                ScanGui.this.increment(ScanGui.this.tf_bright, -10);
            } else if (string.equals(">0")) {
                ScanGui.this.increment(ScanGui.this.tf_bright, 10);
            } else if (string.equals("<1")) {
                ScanGui.this.increment(ScanGui.this.tf_contrast, -10);
            } else if (string.equals(">1")) {
                ScanGui.this.increment(ScanGui.this.tf_contrast, 10);
            }
        }

        ScanGuiListener() {
        }
    }

    class MenuListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("Quit")) {
                ScanGui.this.vw.kill();
                System.exit(0);
            } else if (actionEvent.getActionCommand().equals("Save Settings")) {
                TextField textField = new TextField(10);
                PopupDialog popupDialog = new PopupDialog((Frame)ScanGui.this, textField, "Setting identifier");
                String string = textField.getText();
                if (string.length() > 0) {
                    ScanGui.this.st.save(string + ".set");
                }
                ScanGui.this.addSettingsTo(ScanGui.this.restore_menu, ScanGui.this.delete_menu);
            } else if (actionEvent.getActionCommand().equals("Restore")) {
                ScanGui.this.st.load("this.set");
            } else if (actionEvent.getActionCommand().equals("Fax")) {
                ScanGui.this.st.load("Fax.set");
            } else if (actionEvent.getActionCommand().equals("Default")) {
                ScanGui.this.st.load("Default.set");
            } else if (actionEvent.getActionCommand().equals("Change Directory")) {
                ScanGui.this.changePath();
            } else if (actionEvent.getActionCommand().equals("Viewer path")) {
                ScanGui.this.viewer_path = ScanGui.this.getResponse("Viewer path", ScanGui.this.viewer_path);
            } else if (actionEvent.getActionCommand().equals("Viewer options")) {
                ScanGui.this.viewer_options = ScanGui.this.getResponse("Viewer options", ScanGui.this.viewer_options);
            } else if (actionEvent.getActionCommand().equals("Device")) {
                ScanGui.this.device = ScanGui.this.getResponse("Scanner device", ScanGui.this.device);
            } else if (actionEvent.getActionCommand().equals("Save")) {
                ScanGui.this.cfg.save();
            } else if (actionEvent.getActionCommand().equals("Units")) {
                UnitsDialog unitsDialog = new UnitsDialog((Frame)ScanGui.this, ScanGui.this.units);
                ScanGui.this.compose(ScanGui.this.p3right);
                ScanGui.this.refreshSettings();
            } else if (actionEvent.getActionCommand().equals("Notes")) {
                ShowFile showFile = new ShowFile("Notes", "notes.doc", new Font(ScanGui.this.help_font, 0, 17));
            } else if (actionEvent.getActionCommand().equals("About")) {
                ShowFile showFile = new ShowFile("About", "about.doc", new Font(ScanGui.this.help_font, 0, 17));
            }
        }

        MenuListener() {
        }
    }

    class RestoreListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ScanGui.this.st.load(actionEvent.getActionCommand() + ".set");
        }

        RestoreListener() {
        }
    }

    class DeleteListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            File file = new File(actionEvent.getActionCommand() + ".set");
            if (file.isFile()) {
                file.delete();
                ScanGui.this.addSettingsTo(ScanGui.this.restore_menu, ScanGui.this.delete_menu);
            }
        }

        DeleteListener() {
        }
    }

    class SetFontListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ScanGui.this.help_font = ((MenuItem)actionEvent.getSource()).getLabel();
        }

        SetFontListener() {
        }
    }
}

