/*
 * Decompiled with CFR 0.152.
 */
package com.saic.isd.swing.filechooser;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class SimpleFileFilter
extends FileFilter {
    String myExtension;
    String myDescription;
    boolean iAmCaseSensitive = false;

    public SimpleFileFilter(String extension) {
        this(extension, null, false);
    }

    public SimpleFileFilter(String extension, String description) {
        this(extension, description, false);
    }

    public SimpleFileFilter(String extension, String description, boolean caseSensitive) {
        if (extension == null) {
            throw new IllegalArgumentException("Extension required");
        }
        this.myExtension = extension;
        this.myDescription = description;
        this.iAmCaseSensitive = caseSensitive;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = SimpleFileFilter.getExtension(f);
            if (extension != null) {
                if (this.iAmCaseSensitive && extension.equals(this.myExtension)) {
                    return true;
                }
                return extension.equalsIgnoreCase(this.myExtension);
            }
        }
        return false;
    }

    public String getExtension() {
        return this.myExtension;
    }

    public File attachExtension(File file) {
        if (this.accept(file)) {
            return file;
        }
        return new File(file.getPath() + "." + this.myExtension);
    }

    public static String getExtension(File f) {
        String filename = f.getName();
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1);
        }
        return null;
    }
}

