/*
 * Decompiled with CFR 0.152.
 */
package com.saic.isd.util.report;

import com.saic.isd.printscreen.Util;
import com.saic.isd.swing.filechooser.SimpleFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.gerhardb.lib.print.PrintableText;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.startup.AppStarter;

public class Report
extends JFrame {
    protected JEditorPane myEditorPane = new JEditorPane();
    protected String myHTML = null;

    public static void showReport(String title, String report, boolean html) {
        String type = "text/plain";
        if (html) {
            type = "text/html";
        }
        new Report(title, report, type);
    }

    public static void showReport(String appTitle, String reportTitle, String report) {
        String title = reportTitle + " " + AppStarter.getString("report");
        String reportHTML = "<html><body><center><strong><big>" + appTitle + "<br>" + reportTitle + " " + AppStarter.getString("report") + "</big></strong><br>" + "<strong>" + new Date() + "</strong></center>" + "<hr>" + report + "</body></html>";
        new Report(title, reportHTML, "text/html");
    }

    public Report(String title, String report, String type) {
        this(title, type);
        this.myEditorPane.setText(report);
        this.setVisible(true);
    }

    public Report(String title, String type) {
        super(title);
        Dimension size = new Dimension(700, 400);
        this.setSize(size);
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setDisabledTextColor(Color.black);
        this.myEditorPane.setEditorKit(JEditorPane.createEditorKitForContentType(type));
        JScrollPane center = new JScrollPane(this.myEditorPane, 20, 31);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)center, "Center");
        this.setJMenuBar(this.makeMenus());
        SwingUtils.centerOnScreen(this);
    }

    private JMenuBar makeMenus() {
        JMenu fileMenu = new JMenu(AppStarter.getString("SortScreen.menu.file.label"));
        JMenu editMenu = new JMenu(AppStarter.getString("SortScreen.menu.edit.label"));
        JMenuItem closeMenu = new JMenuItem(AppStarter.getString("close"));
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Report.this.dispose();
            }
        });
        JMenuItem saveMenu = new JMenuItem(AppStarter.getString("SortScreen.menu.file.saveas.label"));
        saveMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String contents = Report.this.myEditorPane.getText();
                Util.saveToFile(contents, new SimpleFileFilter("html", AppStarter.getString("report")), Report.this.myEditorPane);
            }
        });
        JMenuItem printPreviewMenu = new JMenuItem(AppStarter.getString("preview") + "...");
        printPreviewMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Util.previewHTML(Report.this, AppStarter.getString("preview"), Report.this.myEditorPane.getText());
            }
        });
        JMenuItem printImageMenu = new JMenuItem(AppStarter.getString("print") + "...", 80);
        printImageMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                new PrintableText(Report.this.myEditorPane).printContent();
            }
        });
        JMenuItem printTextMenu = new JMenuItem(AppStarter.getString("Report.22"), 84);
        printTextMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Report.this.printWithService();
            }
        });
        JMenuItem copyMenu = new JMenuItem(AppStarter.getString("Report.23"));
        copyMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String contents = Report.this.myEditorPane.getText();
                Util.copyToClipboard(contents);
            }
        });
        fileMenu.add(saveMenu);
        fileMenu.add(printPreviewMenu);
        fileMenu.add(printImageMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(closeMenu);
        editMenu.add(copyMenu);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        return menuBar;
    }

    private void printWithService() {
        PrintableText printable = new PrintableText(this.myEditorPane);
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] allServices = PrintServiceLookup.lookupPrintServices(flavor, pras);
        if (allServices.length == 0) {
            return;
        }
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService service = ServiceUI.printDialog(null, 200, 200, allServices, defaultService, flavor, pras);
        if (service == null) {
            return;
        }
        DocPrintJob job = service.createPrintJob();
        HashDocAttributeSet das = new HashDocAttributeSet();
        SimpleDoc doc = new SimpleDoc(printable, flavor, das);
        try {
            job.print(doc, pras);
        }
        catch (PrintException pe) {
            pe.printStackTrace();
        }
    }
}

