/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.dirtools;

import com.saic.isd.printscreen.Util;
import com.saic.isd.util.report.Report;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.dirtools.DirectoryCopy;
import org.gerhardb.jibs.dirtools.WorkerCopy;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;

public class DirCopyPanel
extends JPanelRows {
    private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/dirtools/DirCopyPanel");
    private static String TO_DIR = "TO_DIR";
    private static final String FILE_DATE_FORMAT = "yyyy.MM.dd-HH.mm.ss";
    private static final SimpleDateFormat FILE_DATE = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");
    DirectoryCopy myDirTools;
    WorkerCopy myWorker;
    JLabel myCurrentAction = new JLabel("Idle");
    File myLogFile;
    private static final int DIR_COL_WIDTH = 50;
    JTextField toDirFld;
    JButton myStartBtn = new JButton(Jibs.getString("CameraPanel.3"));

    public DirCopyPanel(DirectoryCopy dirTools) {
        this.myDirTools = dirTools;
        String toDir = FileUtil.checkDirectory(clsPrefs.get(TO_DIR, System.getProperty("user.home")));
        if (toDir == null) {
            toDir = System.getProperty("user.home");
        }
        this.toDirFld = new JTextField(toDir);
        this.toDirFld.setColumns(50);
        JButton btnTo = new JButton("...");
        btnTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String dir = DirCopyPanel.this.toDirFld.getText();
                if (dir == null) {
                    dir = System.getProperty("user.home");
                }
                dir = DirCopyPanel.this.lookupDir("Copy To Directory", dir);
                DirCopyPanel.this.toDirFld.setText(dir);
                DirCopyPanel.setPrefsDirectory(TO_DIR, dir);
            }
        });
        final JButton btnStop = new JButton(Jibs.getString("CameraPanel.16"));
        final JButton btnReport = new JButton(Jibs.getString("report"));
        btnReport.setEnabled(false);
        this.myStartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirCopyPanel.this.doWork();
                btnReport.setEnabled(true);
                btnStop.setEnabled(true);
            }
        });
        btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirCopyPanel.this.myWorker.stop();
                btnStop.setEnabled(false);
            }
        });
        btnReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    String text = Util.getTextFromFile(DirCopyPanel.this.myLogFile);
                    Report.showReport(Jibs.getString("CameraPanel.30"), text, false);
                }
                catch (Exception ex) {
                    Report.showReport(Jibs.getString("CameraPanel.20"), ex.getMessage(), false);
                }
            }
        });
        JPanel currentRow = super.topRow();
        currentRow.add(new JLabel("To Directory: "));
        currentRow.add(this.toDirFld);
        currentRow.add(btnTo);
        currentRow = super.nextRow();
        currentRow.add(this.myStartBtn);
        currentRow.add(btnStop);
        currentRow.add(btnReport);
        currentRow = super.nextRow();
        currentRow.add(new JLabel("  " + Jibs.getString("CameraPanel.18") + Jibs.getString("colon") + " "));
        currentRow.add(this.myCurrentAction);
    }

    private String lookupDir(String msg, String prior) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(msg);
        chooser.setFileSelectionMode(1);
        chooser.setCurrentDirectory(new File(prior));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                return chooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private void doWork() {
        String toDir = this.toDirFld.getText();
        String date = FILE_DATE.format(new Date());
        String logFileName = this.toDirFld.getText() + System.getProperty("file.separator") + "jibsLog_" + date + ".txt";
        this.myLogFile = new File(logFileName);
        try {
            this.myWorker = new WorkerCopy(this, toDir);
            Thread t = new Thread(this.myWorker);
            t.start();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("CameraPanel.25"), 0);
            ex.printStackTrace();
        }
    }

    static void setPrefsDirectory(String pref, String dir) {
        String validated = FileUtil.safeValidateDirectory(dir);
        if (validated != null) {
            clsPrefs.put(pref, validated);
        } else {
            clsPrefs.remove(pref);
        }
    }
}

