/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.dirtools;

import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.dirtools.DirDedupPanel;
import org.gerhardb.lib.io.EzLogger;

public class WorkerDedup
implements Runnable {
    static final SimpleDateFormat LONG_DATE = new SimpleDateFormat("yyyy.MMMMM.dd HH:mm:ss");
    static final String FAILED = "FAILED\t";
    static final String SKIPPED = "SKIPPED\t";
    static final String ABORTED = "==> ABORTED <==";
    private static final String FILE_DATE_FORMAT = "yyyy.MM.dd-HH.mm.ss";
    private static final SimpleDateFormat FILE_DATE = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");
    boolean iStop;
    DirDedupPanel myPanel;
    EzLogger myLog;
    File mySacredStableDir;
    File myDedupTargetDir;
    File myLogFile;
    boolean iCheckFileContents = true;
    boolean iAmRunningOnWindows = false;

    public WorkerDedup(DirDedupPanel panel, String sacredStableDir, String dedupTargetDir, boolean checkFileContents) throws Exception {
        this.myPanel = panel;
        this.mySacredStableDir = new File(sacredStableDir);
        this.myDedupTargetDir = new File(dedupTargetDir);
        this.iCheckFileContents = checkFileContents;
        if (this.mySacredStableDir.equals(this.myDedupTargetDir)) {
            throw new WorkerDedupException("Target directory must be different than stable directory");
        }
        if (this.mySacredStableDir.getAbsolutePath().startsWith(this.myDedupTargetDir.getAbsolutePath())) {
            throw new WorkerDedupException("Stable directory may not be child of target directory");
        }
        String date = FILE_DATE.format(new Date());
        String logFileName = sacredStableDir + System.getProperty("file.separator") + "jibsLog_" + date + ".txt";
        this.myLogFile = new File(logFileName);
        this.myLog = new EzLogger(this.myLogFile);
        this.myLog.logLine("Stable Directory (leave alone): " + this.mySacredStableDir);
        this.myLog.logLine("Dedup Directory (remove from here): " + this.myDedupTargetDir);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            this.iAmRunningOnWindows = true;
        }
    }

    void stop() {
        this.iStop = true;
    }

    public void run() {
        this.iStop = false;
        Date startDate = new Date();
        this.myLog.logLine("Started" + Jibs.getString("colon") + " " + LONG_DATE.format(startDate) + "");
        this.myLog.logLine("===========================================================================================");
        this.myPanel.myCurrentAction.setText("Started");
        this.processDirectory(this.mySacredStableDir, this.myDedupTargetDir);
        this.myLog.logLine("===========================================================================================");
        Date stopDate = new Date();
        this.myLog.logLine("Completed" + Jibs.getString("colon") + " " + LONG_DATE.format(stopDate) + "");
        this.myPanel.myCurrentAction.setText("Stopped");
        try {
            this.myLog.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myPanel.myStopBtn.setEnabled(false);
    }

    private void processDirectory(File stableDir, File dedupTargeDir) {
        if (this.iStop) {
            this.myLog.logLine(ABORTED);
            return;
        }
        if (stableDir == null || !stableDir.isDirectory()) {
            this.myLog.logLine("FAILED\tStable is null or not a directory: " + stableDir);
            return;
        }
        if (dedupTargeDir == null || !dedupTargeDir.isDirectory()) {
            this.myLog.logLine("FAILED\tTarget is null or not a directory: " + dedupTargeDir);
            return;
        }
        this.myLog.logLine("===========================================================================================");
        this.myLog.logLine("Stable Directory: " + stableDir.getAbsolutePath());
        this.myLog.logLine("Dedup Directory: " + dedupTargeDir.getAbsolutePath());
        this.myPanel.myCurrentAction.setText(stableDir.getAbsolutePath());
        File[] stableFiles = null;
        try {
            stableFiles = stableDir.listFiles();
        }
        catch (Exception ex) {
            this.myLog.logLine("FAILED\tCould not LOOK UP files in STABLE directory: " + stableDir.getAbsolutePath());
            return;
        }
        if (stableFiles == null) {
            this.myLog.logLine("FAILED\tCould not LOOK UP files in STABLE directory: " + stableDir.getAbsolutePath());
            return;
        }
        File[] targetDedupFiles = null;
        try {
            targetDedupFiles = dedupTargeDir.listFiles();
        }
        catch (Exception ex) {
            this.myLog.logLine("FAILED\tCould not LOOK UP files in TARGET directory: " + dedupTargeDir.getAbsolutePath());
            return;
        }
        if (targetDedupFiles == null) {
            this.myLog.logLine("FAILED\tCould not LOOK UP files in TARGET directory: " + dedupTargeDir.getAbsolutePath());
            return;
        }
        String[] targetDedupFileNames = new String[targetDedupFiles.length];
        for (int i = 0; i < targetDedupFileNames.length; ++i) {
            targetDedupFileNames[i] = targetDedupFiles[i].getName();
        }
        for (int stableIndex = 0; stableIndex < stableFiles.length; ++stableIndex) {
            if (this.iStop) {
                this.myLog.logLine(ABORTED);
                return;
            }
            for (int targetIndex = 0; targetIndex < targetDedupFileNames.length; ++targetIndex) {
                if (!this.isNameSame(stableFiles[stableIndex].getName(), targetDedupFileNames[targetIndex])) continue;
                if (stableFiles[stableIndex].isDirectory() && targetDedupFiles[targetIndex].isDirectory()) {
                    try {
                        this.processDirectory(stableFiles[stableIndex], targetDedupFiles[targetIndex]);
                    }
                    catch (Exception ex) {
                        this.myLog.logLine("FAILED\tCould not PROCESS directory: " + stableFiles[stableIndex] + "    BECAUSE: " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    if (targetDedupFiles[targetIndex].list().length != 0) continue;
                    targetDedupFiles[targetIndex].delete();
                    this.myLog.logLine("REMOVED EMPTY DIRECTORY: " + targetDedupFiles[targetIndex]);
                    continue;
                }
                if (!stableFiles[stableIndex].isFile() || !targetDedupFiles[targetIndex].isFile()) continue;
                if (this.iCheckFileContents) {
                    try {
                        if (stableFiles[stableIndex].length() != targetDedupFiles[targetIndex].length()) continue;
                        if (this.duplicateFiles(stableFiles[stableIndex], targetDedupFiles[targetIndex])) {
                            targetDedupFiles[targetIndex].delete();
                            this.myLog.logLine("REMOVED - identical file CONTENTS: " + targetDedupFiles[targetIndex]);
                            continue;
                        }
                        this.myLog.logLine(SKIPPED + targetDedupFiles[targetIndex]);
                    }
                    catch (Exception ex) {
                        this.myLog.logLine(FAILED + targetDedupFiles[targetIndex] + "    BECAUSE: " + ex.getMessage());
                    }
                    continue;
                }
                targetDedupFiles[targetIndex].delete();
                this.myLog.logLine("REMOVED - identical file NAME: " + targetDedupFiles[targetIndex]);
            }
        }
    }

    boolean isNameSame(String a, String b) {
        if (this.iAmRunningOnWindows) {
            return a.equalsIgnoreCase(b);
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean duplicateFiles(File a, File b) throws Exception {
        int aRead = 0;
        char[] aChar = new char[1000];
        FileReader aReader = new FileReader(a);
        int bRead = 0;
        char[] bChar = new char[aChar.length];
        FileReader bReader = new FileReader(b);
        try {
            aRead = aReader.read(aChar, 0, aChar.length);
            while (aRead > -1) {
                bRead = bReader.read(bChar, 0, bChar.length);
                if (aRead != bRead) {
                    boolean bl = false;
                    return bl;
                }
                for (int i = 0; i < aRead; ++i) {
                    if (aChar[i] == bChar[i]) continue;
                    boolean bl = false;
                    return bl;
                }
                aRead = aReader.read(aChar, 0, aChar.length);
            }
        }
        finally {
            aReader.close();
            bReader.close();
        }
        return true;
    }

    class WorkerDedupException
    extends Exception {
        WorkerDedupException(String msg) {
            super(msg);
        }
    }
}

