/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.editor.ColorPanel;
import org.gerhardb.jibs.editor.PicturePanel;
import org.gerhardb.lib.io.FileSaveAs;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

public class Editor
extends JFrame {
    private static final String PREF_PATH = "/org/gerhardb/jibs/lib/filetree/Editor";
    private static final Preferences myPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/lib/filetree/Editor");
    private static final String PRIOR_DIR = "priorDir";
    private boolean iExitOnClose;
    private PicturePanel myPicturePanel = new PicturePanel();
    JLabel myInfo = new JLabel(Jibs.getString("Editor.1"));

    public Editor(boolean standAlone) {
        this.iExitOnClose = standAlone;
        if (this.iExitOnClose) {
            super.setDefaultCloseOperation(3);
        }
        if (this.iExitOnClose) {
            JMenu fileMenu = new JMenu(Jibs.getString("Editor.2"));
            fileMenu.add(new JMenuItem(new OpenAction()));
            fileMenu.add(new JMenuItem(new SaveAction()));
            fileMenu.addSeparator();
            fileMenu.add(new JMenuItem(new CloseAction()));
            JMenuBar bar = new JMenuBar();
            bar.add(fileMenu);
            super.setJMenuBar(bar);
        }
        ColorPanel colorPanel = new ColorPanel();
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)colorPanel, "West");
        contentPanel.add((Component)this.myPicturePanel, "Center");
        contentPanel.add((Component)this.infoPanel(), "South");
        super.getContentPane().add(contentPanel);
        this.setIconImage(Icons.icon(26).getImage());
        int size = 700;
        super.setSize(size, size);
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
        this.myPicturePanel.setPictureFile(new File("d:/testpics/grindstone-PAINT.GIF"));
        this.repaint();
    }

    JPanel infoPanel() {
        JPanelRows leftPanel = new JPanelRows();
        JPanel aRow = leftPanel.topRow();
        aRow.add(this.myInfo);
        JPanel rtnMe = new JPanel(new BorderLayout());
        rtnMe.add((Component)leftPanel, "East");
        return rtnMe;
    }

    public static void main(String[] args) {
        new Editor(true);
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            if (Editor.this.iExitOnClose) {
                super.putValue("Name", Jibs.getString("Editor.10"));
            } else {
                super.putValue("Name", Jibs.getString("Editor.11"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (Editor.this.iExitOnClose) {
                System.exit(0);
            } else {
                Editor.this.dispose();
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super.putValue("Name", Jibs.getString("Editor.6"));
        }

        public void actionPerformed(ActionEvent e) {
            String priorDir = myPrefs.get(Editor.PRIOR_DIR, null);
            if (priorDir == null) {
                priorDir = System.getProperty("user.home");
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File(priorDir));
            chooser.setDialogTitle(Jibs.getString("Editor.7"));
            chooser.setFileSelectionMode(2);
            int returnVal = chooser.showSaveDialog(Editor.this);
            if (returnVal == 0) {
                try {
                    File saveAsFile = chooser.getSelectedFile();
                    if (FileSaveAs.PossibleDuplicateNameOK(saveAsFile, Editor.this)) {
                        ImageIO.write((RenderedImage)((Editor)Editor.this).myPicturePanel.myImage, "gif", saveAsFile);
                        System.out.println("Wrote GIF");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super.putValue("Name", Jibs.getString("Editor.4"));
        }

        public void actionPerformed(ActionEvent e) {
            File picFile = null;
            try {
                String priorDir = myPrefs.get(Editor.PRIOR_DIR, null);
                if (priorDir == null) {
                    priorDir = System.getProperty("user.home");
                }
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle(Jibs.getString("Editor.5"));
                chooser.setFileSelectionMode(2);
                chooser.setCurrentDirectory(new File(priorDir));
                int returnVal = chooser.showOpenDialog(Editor.this);
                if (returnVal == 0) {
                    File picked = chooser.getSelectedFile();
                    if (picked.isDirectory()) {
                        myPrefs.put(Editor.PRIOR_DIR, picked.getAbsolutePath());
                    } else {
                        picFile = picked;
                        myPrefs.put(Editor.PRIOR_DIR, picked.getParentFile().getAbsolutePath());
                    }
                    myPrefs.flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Editor.this.myPicturePanel.setPictureFile(picFile);
            Editor.this.repaint();
        }
    }
}

