/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.games.missingTile;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.swing.JPanel;
import org.gerhardb.jibs.games.missingTile.MissingTile;
import org.gerhardb.jibs.games.missingTile.Tile;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.image.ImageUtil;

class TilePanel
extends JPanel
implements DropTargetListener {
    MissingTile myFrame;
    int myCount = 4;
    Tile[] myTiles;
    BufferedImage[] myTileImages;
    boolean isGameInProgress = false;
    int myOriginalEmptyPlayIndex;
    int myEmptyTile;
    int myMovesMade;
    int myMaxImageSize;

    public TilePanel(MissingTile frame, int count) {
        int height;
        this.myFrame = frame;
        if (count > 2) {
            this.myCount = count;
        }
        super.setBackground(Color.green);
        super.setLayout(new TileLayout());
        int tileCount = this.myCount * this.myCount;
        this.myTileImages = new BufferedImage[tileCount];
        this.myTiles = new Tile[tileCount];
        for (int i = 0; i < this.myTiles.length; ++i) {
            this.myTiles[i] = new Tile(i + 1, this);
            super.add(this.myTiles[i]);
        }
        int tileIndex = 0;
        int lastRow = this.myCount - 1;
        for (int row = 0; row < this.myCount; ++row) {
            for (int col = 0; col < this.myCount; ++col) {
                this.myTiles[tileIndex].tileNorth = row == 0 ? 0 : this.myTiles[tileIndex - this.myCount].myIndex;
                this.myTiles[tileIndex].tileSouth = row == lastRow ? 0 : this.myTiles[tileIndex + this.myCount].myIndex;
                this.myTiles[tileIndex].tileWest = col == 0 ? 0 : this.myTiles[tileIndex - 1].myIndex;
                this.myTiles[tileIndex].tileEast = col == lastRow ? 0 : this.myTiles[tileIndex + 1].myIndex;
                ++tileIndex;
            }
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode ddm = ge.getDefaultScreenDevice().getDisplayMode();
        int width = ddm.getWidth();
        this.myMaxImageSize = width < (height = ddm.getHeight()) ? width : height;
        new DropTarget(this, this);
    }

    public void dragEnter(DropTargetDragEvent event) {
        if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            System.out.println("TilePanel.dragEnter ACCEPTING");
            event.acceptDrag(1);
        } else if (event.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            System.out.println("TilePanel.dragEnter ACCEPTING");
            event.acceptDrag(1);
        } else {
            System.out.println("TilePanel.dragEnter REJECTING");
            event.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent event) {
    }

    public void dragOver(DropTargetDragEvent event) {
    }

    public void drop(DropTargetDropEvent event) {
        if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            System.out.println("TilePanel Accepting Drop: javaFileListFlavor");
            event.acceptDrop(1);
            try {
                Transferable transfer = event.getTransferable();
                Object moveObj = transfer.getTransferData(DataFlavor.javaFileListFlavor);
                if (moveObj == null || !(moveObj instanceof List)) {
                    event.dropComplete(false);
                    return;
                }
                List fileList = (List)moveObj;
                if (fileList.size() < 1) {
                    event.dropComplete(false);
                    return;
                }
                File imgFile = (File)fileList.get(0);
                IOImage ioImage = ImageFactory.getImageFactory().makeImage(imgFile);
                this.setImage(ioImage.getImage());
                event.dropComplete(true);
                MissingTile.clsPrefs.put("lastImage", imgFile.getAbsolutePath());
                MissingTile.clsPrefs.put("lastDirectory", imgFile.getAbsolutePath());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                event.dropComplete(false);
                return;
            }
        } else if (event.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            System.out.println("TilePanel Accepting Drop: imageFlavor");
            event.acceptDrop(1);
            try {
                Transferable transfer = event.getTransferable();
                Object moveObj = transfer.getTransferData(DataFlavor.imageFlavor);
                if (moveObj == null || !(moveObj instanceof Image)) {
                    event.dropComplete(false);
                    return;
                }
                this.setImage((Image)moveObj);
                event.dropComplete(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                event.dropComplete(false);
                return;
            }
        } else {
            System.out.println("TilePanel Rejecting Drop, Bad Flavor.");
            event.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent event) {
    }

    void setImage(Image image) {
        BufferedImage buffImage = ImageUtil.toBufferedImage(image);
        this.setImage(buffImage);
    }

    void setImage(BufferedImage wholeImage) {
        this.myFrame.quit();
        if (wholeImage == null) {
            for (int i = 0; i < this.myTileImages.length; ++i) {
                this.myTileImages[i] = null;
            }
            this.repaint();
            return;
        }
        float horizontalXScale = 1.0f;
        float vertcialYScale = 1.0f;
        horizontalXScale = (float)this.myMaxImageSize / (float)wholeImage.getWidth();
        vertcialYScale = (float)this.myMaxImageSize / (float)wholeImage.getHeight();
        BufferedImage tileImage = wholeImage;
        try {
            AffineTransform at = AffineTransform.getScaleInstance(horizontalXScale, vertcialYScale);
            AffineTransformOp op = new AffineTransformOp(at, null);
            tileImage = op.filter(wholeImage, null);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        int index = 0;
        int x = 0;
        int y = 0;
        int tileSize = this.myMaxImageSize / this.myCount;
        for (int row = 0; row < this.myCount; ++row) {
            y = tileSize * row;
            for (int col = 0; col < this.myCount; ++col) {
                BufferedImage tile;
                x = tileSize * col;
                this.myTileImages[index] = tile = tileImage.getSubimage(x, y, tileSize, tileSize);
                ++index;
            }
        }
        this.repaint();
    }

    BufferedImage getImage(int index) {
        return this.myTileImages[index];
    }

    void emptySeed(int emptyTile) {
        this.myOriginalEmptyPlayIndex = this.myTiles[emptyTile - 1].myPlayIndex;
        this.setEmpty(emptyTile);
        this.isGameInProgress = true;
    }

    void setEmpty(int emptyTile) {
        this.myEmptyTile = emptyTile;
        for (int i = 0; i < this.myTiles.length; ++i) {
            this.myTiles[i].updateTileDisplay(this.myEmptyTile);
        }
    }

    void moveMade(Tile fromTile) {
        Tile toTile = this.myTiles[this.myEmptyTile - 1];
        toTile.myPlayIndex = fromTile.myPlayIndex;
        fromTile.myPlayIndex = 0;
        this.setEmpty(fromTile.myIndex);
        this.myFrame.updateMovesMade(++this.myMovesMade);
        this.checkVictory();
    }

    void checkVictory() {
        if (this.myOriginalEmptyPlayIndex != this.myEmptyTile) {
            return;
        }
        for (int i = 0; i < this.myTiles.length; ++i) {
            if (this.myOriginalEmptyPlayIndex == i + 1 || this.myTiles[i].myPlayIndex == this.myTiles[i].myIndex) continue;
            return;
        }
        this.myFrame.victory();
    }

    void resetGame() {
        this.isGameInProgress = false;
        this.myOriginalEmptyPlayIndex = 0;
        this.myMovesMade = 0;
        this.myFrame.updateMovesMade(this.myMovesMade);
        for (int i = 0; i < this.myTiles.length; ++i) {
            this.myTiles[i].resetTile();
        }
    }

    void scramble() {
        Random random = new Random();
        for (int i = 0; i < this.myTiles.length; ++i) {
            int candidate = random.nextInt(this.myTiles.length + 1);
            if (candidate == 0) {
                candidate = 1;
            }
            this.myTiles[i].myPlayIndex = candidate;
        }
        this.dedupScramble();
        if (this.myEmptyTile > 0) {
            this.myTiles[this.myEmptyTile - 1].myPlayIndex = 1;
        }
        this.dedupScramble();
        this.repaint();
    }

    void dedupScramble() {
        boolean[] used = new boolean[this.myTiles.length];
        ArrayList<Tile> needsNewNumbers = new ArrayList<Tile>(this.myTiles.length);
        for (int i = 0; i < this.myTiles.length; ++i) {
            int usedIndex = this.myTiles[i].myPlayIndex - 1;
            if (used[usedIndex]) {
                needsNewNumbers.add(this.myTiles[i]);
                continue;
            }
            used[usedIndex] = true;
        }
        Iterator it = needsNewNumbers.iterator();
        block1: while (it.hasNext()) {
            Tile theTile = (Tile)it.next();
            for (int i = 0; i < used.length; ++i) {
                int newIndex;
                if (used[i]) continue;
                used[i] = true;
                theTile.myPlayIndex = newIndex = i + 1;
                continue block1;
            }
        }
    }

    class TileLayout
    implements LayoutManager {
        TileLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            int baseX = 0;
            int baseY = 0;
            int parentX = parent.getWidth();
            int parentY = parent.getHeight();
            int size = parentX;
            if (parentY < parentX) {
                size = parentY;
                baseX = (parentX - size) / 2;
            } else {
                baseY = (parentY - size) / 2;
            }
            int xOffset = 0;
            int yOffset = 0;
            int tileIndex = 0;
            int tileSize = size / TilePanel.this.myCount;
            int lastRow = TilePanel.this.myCount - 1;
            for (int row = 0; row < TilePanel.this.myCount; ++row) {
                yOffset = baseY + row * tileSize;
                for (int col = 0; col < TilePanel.this.myCount; ++col) {
                    xOffset = baseX + col * tileSize;
                    if (row == 0) {
                        TilePanel.this.myTiles[tileIndex].outsideNorth = true;
                    } else if (row == lastRow) {
                        TilePanel.this.myTiles[tileIndex].outsideSouth = true;
                    }
                    if (col == 0) {
                        TilePanel.this.myTiles[tileIndex].outsideWest = true;
                    } else if (col == lastRow) {
                        TilePanel.this.myTiles[tileIndex].outsideEast = true;
                    }
                    TilePanel.this.myTiles[tileIndex].setBounds(xOffset, yOffset, tileSize, tileSize);
                    ++tileIndex;
                }
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(100, 100);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(500, 500);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

