/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.optimizer;

import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.Date;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.optimizer.NoDirectories;
import org.gerhardb.jibs.util.FileLoopHelper;
import org.gerhardb.lib.util.Killer;

public class Deduper {
    FileLoopHelper myHelper;
    File[] myWorkingFiles;
    File[] myStableDirs;
    Killer myKiller;
    long[] myWorkingLengths = null;
    int myMaxSameSize = 0;
    int myDuplicate = 0;
    int myDuplicateNot = 0;
    int mySampleHelped = 0;
    long myKiloBytesDeleted = 0L;

    Deduper(FileLoopHelper helper, File[] stableDirs, Killer killer) {
        this.myHelper = helper;
        this.myStableDirs = stableDirs;
        this.myKiller = killer;
        this.myHelper.setIndeterminate(false);
    }

    int getRemovedCount() {
        return this.myDuplicate;
    }

    int getMaxSameSize() {
        return this.myMaxSameSize;
    }

    boolean setWorking(File[] workingFiles) {
        this.myWorkingFiles = workingFiles;
        if (workingFiles == null || workingFiles.length == 0) {
            this.myHelper.getLog().logLine("     " + Jibs.getString("Deduper.0"));
            return false;
        }
        this.myWorkingLengths = new long[this.myWorkingFiles.length];
        for (int i = 0; i < this.myWorkingFiles.length; ++i) {
            this.myWorkingLengths[i] = this.myWorkingFiles[i].length();
        }
        return true;
    }

    void dedupStable() {
        long stableFileCount = 0L;
        Date startTime = new Date();
        this.myHelper.getLog().logLine("===========================================================================================");
        this.myHelper.setValue(0);
        this.myHelper.setMaximum(this.myStableDirs.length - 1);
        NoDirectories noDirectories = new NoDirectories();
        for (int i = 0; i < this.myStableDirs.length && !this.myKiller.die(); ++i) {
            this.myHelper.setValue(i);
            String progress = Jibs.getString("Deduper.1") + i + ": " + this.myStableDirs[i];
            this.myHelper.getLabel().setText(progress);
            this.myHelper.getLog().logLine(progress);
            File[] stableFiles = this.myStableDirs[i].listFiles(noDirectories);
            for (int j = 0; j < stableFiles.length; ++j) {
                this.dedup(stableFiles[j], stableFiles[j].length(), 0);
            }
            stableFileCount += (long)stableFiles.length;
        }
        Date stopTime = new Date();
        this.myHelper.getLog().logLine("===========================================================================================");
        this.myHelper.getLog().logTime(Jibs.getString("Deduper.3"), startTime, stopTime);
        DecimalFormat formatter = new DecimalFormat();
        this.myHelper.getLog().logLine(Jibs.getString("Deduper.4") + " " + formatter.format(stableFileCount) + " " + Jibs.getString("Deduper.5") + " " + formatter.format(this.myWorkingFiles.length) + " " + Jibs.getString("Deduper.6"));
        this.myHelper.getLog().logLine(Jibs.getString("Deduper.7") + Jibs.getString("colon") + " " + formatter.format(this.mySampleHelped) + " " + Jibs.getString("Deduper.8") + Jibs.getString("colon") + " " + formatter.format(this.myDuplicateNot) + " " + Jibs.getString("Deduper.9") + Jibs.getString("colon") + " " + formatter.format(this.myDuplicate));
        this.myHelper.getLog().logLine(Jibs.getString("Deduper.10") + Jibs.getString("colon") + " " + formatter.format(this.myKiloBytesDeleted / 1024L));
        this.myHelper.getLog().logLine("===========================================================================================");
    }

    void dedupWorking() {
        this.myHelper.setValue(0);
        this.myHelper.setMaximum(this.myWorkingFiles.length - 1);
        for (int i = 0; i < this.myWorkingFiles.length && !this.myKiller.die(); ++i) {
            this.myHelper.setValue(i);
            if (this.myWorkingFiles[i] == null || this.myWorkingLengths[i] <= 0L) continue;
            this.dedup(this.myWorkingFiles[i], this.myWorkingLengths[i], i + 1);
        }
        this.myHelper.getLog().logLine("===========================================================================================");
        DecimalFormat formatter = new DecimalFormat();
        this.myHelper.getLog().logLine(Jibs.getString("Deduper.11") + Jibs.getString("colon") + " " + formatter.format(this.mySampleHelped) + " " + Jibs.getString("Deduper.12") + Jibs.getString("colon") + " " + formatter.format(this.myDuplicateNot) + " " + Jibs.getString("Deduper.13") + Jibs.getString("colon") + " " + formatter.format(this.myDuplicate));
        this.myHelper.getLog().logLine(Jibs.getString("Deduper.14") + Jibs.getString("colon") + " " + formatter.format(this.myKiloBytesDeleted / 1024L));
        this.myHelper.getLog().logLine("===========================================================================================");
    }

    private void dedup(File keeper, long keeperLength, int dedupStart) {
        if (keeper == null || keeperLength < 1L) {
            return;
        }
        int sameSizeCount = 0;
        for (int i = dedupStart; i < this.myWorkingLengths.length; ++i) {
            if (keeperLength != this.myWorkingLengths[i]) continue;
            ++sameSizeCount;
        }
        if (sameSizeCount == 0) {
            return;
        }
        if (sameSizeCount > this.myMaxSameSize) {
            this.myMaxSameSize = sameSizeCount;
        }
        char[] keepTest = this.getSample(keeper, keeperLength);
        for (int kill = dedupStart; kill < this.myWorkingLengths.length; ++kill) {
            if (this.myKiller.die()) {
                return;
            }
            if (keeperLength != this.myWorkingLengths[kill]) continue;
            char[] killTest = this.getSample(this.myWorkingFiles[kill], this.myWorkingLengths[kill]);
            if (this.duplicate(keepTest, killTest)) {
                char[] killChar;
                char[] keepChar = this.readFile(keeper, keeperLength);
                if (this.duplicate(keepChar, killChar = this.readFile(this.myWorkingFiles[kill], this.myWorkingLengths[kill]))) {
                    this.myKiloBytesDeleted += this.myWorkingFiles[kill].length() / 1024L;
                    this.myHelper.getLog().logLine(Jibs.getString("Deduper.15") + Jibs.getString("colon") + " " + this.myWorkingFiles[kill].getAbsolutePath() + "");
                    this.myWorkingFiles[kill].delete();
                    this.myWorkingFiles[kill] = null;
                    this.myWorkingLengths[kill] = 0L;
                    ++this.myDuplicate;
                    continue;
                }
                ++this.myDuplicateNot;
                continue;
            }
            ++this.mySampleHelped;
        }
    }

    private boolean duplicate(char[] keep, char[] kill) {
        if (keep.length < kill.length) {
            return false;
        }
        for (int i = 0; i < kill.length; ++i) {
            if (kill[i] == keep[i]) continue;
            return false;
        }
        return true;
    }

    private char[] getSample(File file, long length) {
        int intLength = 1024;
        if (length < 1024L) {
            intLength = (int)length;
        }
        char[] rtnMe = new char[intLength];
        try {
            FileReader reader = new FileReader(file);
            reader.read(rtnMe, 0, rtnMe.length);
            reader.close();
        }
        catch (Exception e) {
            this.myHelper.getLog().logLine(Jibs.getString("Deduper.17") + Jibs.getString("colon") + " " + file.getAbsolutePath() + "");
            return new char[0];
        }
        return rtnMe;
    }

    private char[] readFile(File file, long length) {
        int intLength = Integer.MAX_VALUE;
        if (length < Integer.MAX_VALUE) {
            intLength = (int)length;
        }
        char[] rtnMe = new char[intLength];
        try {
            FileReader reader = new FileReader(file);
            reader.read(rtnMe, 0, rtnMe.length);
            reader.close();
        }
        catch (Exception e) {
            this.myHelper.getLog().logLine(Jibs.getString("Deduper.19") + Jibs.getString("colon") + " " + file.getAbsolutePath() + "");
            return new char[0];
        }
        return rtnMe;
    }
}

