/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textPad.ranker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gerhardb.jibs.textPad.ranker.CountAndRankPanel;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

public class AppRanker
extends JFrame {
    private boolean iExitOnClose;
    private CountAndRankPanel myCountAndRankUI = new CountAndRankPanel();

    public AppRanker(boolean exitOnClose) {
        this.iExitOnClose = exitOnClose;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AppRanker.this.exit();
            }
        });
        this.setIconImage(Icons.icon(26).getImage());
        this.setTitle("JIBS Text: Count Words & Rank Files");
        this.setJMenuBar(this.makeMenus());
        JTabbedPane jTabbed = new JTabbedPane();
        jTabbed.addTab("Count & Rank", this.myCountAndRankUI);
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)jTabbed, "Center");
        this.setContentPane(thePanel);
        this.pack();
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
    }

    private void exit() {
        this.myCountAndRankUI.exit();
        if (this.iExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    JMenuBar makeMenus() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem closeMenu = new JMenuItem("Close");
        if (this.iExitOnClose) {
            closeMenu.setText("Exit");
        }
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AppRanker.this.exit();
                AppRanker.this.dispose();
            }
        });
        fileMenu.add(closeMenu);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        return menuBar;
    }

    public static void main(String[] args) {
        new AppRanker(true);
    }
}

