/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textPad.ranker;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.JProgressBar;
import org.gerhardb.lib.io.FileUtil;

class WordCount {
    private static final String[] ENDINGS = new String[]{"txt", "htm", "html", "nat"};
    static final String FILE_TOKEN = "=!:,";
    JProgressBar myProgress;
    boolean iStop;

    WordCount(JProgressBar progress) {
        this.myProgress = progress;
    }

    void count(String[] words, File dirToScan, File outputFile) throws Exception {
        this.iStop = false;
        this.myProgress.setString("");
        this.myProgress.setValue(0);
        if (!dirToScan.exists()) {
            throw new Exception("Could not find: " + dirToScan);
        }
        if (!dirToScan.isDirectory()) {
            throw new Exception("Root file must be a directory");
        }
        System.out.println("RootString: " + dirToScan);
        System.out.println("outputFile: " + outputFile);
        if (this.iStop) {
            return;
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            out.print("File");
            out.print(FILE_TOKEN);
            for (int wordIndex = 0; wordIndex < words.length; ++wordIndex) {
                if (wordIndex > 0) {
                    out.print(',');
                }
                out.print(words[wordIndex]);
            }
            out.println("");
            this.doDirectory(out, dirToScan, words);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Problem writing to: " + outputFile);
        }
        finally {
            try {
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Completed outputFile: " + outputFile);
        this.myProgress.setString("Done");
    }

    void doDirectory(PrintWriter out, File dirToScan, String[] words) throws Exception {
        File[] files = dirToScan.listFiles();
        this.myProgress.setMaximum(files.length);
        block0: for (int i = 0; i < files.length; ++i) {
            this.myProgress.setValue(i + 1);
            if (files[i].isDirectory()) {
                if (this.iStop) {
                    return;
                }
                this.doDirectory(out, files[i], words);
                continue;
            }
            if (!files[i].isFile()) continue;
            if (this.iStop) {
                return;
            }
            String ending = FileUtil.getExtension(files[i].getName());
            if (ending == null) continue;
            ending = ending.toLowerCase();
            for (int j = 0; j < ENDINGS.length; ++j) {
                if (!ENDINGS[j].equals(ending)) continue;
                this.doFile(out, files[i], words);
                continue block0;
            }
        }
    }

    void doFile(PrintWriter out, File aFile, String[] words) throws Exception {
        int[] counts = new int[words.length];
        this.myProgress.setString(aFile.getAbsolutePath());
        String text = FileUtil.getStringFromFile(aFile);
        String[] result = text.split("\\W+");
        for (int i = 0; i < result.length; ++i) {
            for (int wordIndex = 0; wordIndex < words.length; ++wordIndex) {
                if (this.iStop) {
                    return;
                }
                if (!result[i].toLowerCase().equals(words[wordIndex])) continue;
                int n = wordIndex;
                counts[n] = counts[n] + 1;
            }
        }
        out.print(aFile.getAbsolutePath());
        out.print(FILE_TOKEN);
        for (int wordIndex = 0; wordIndex < words.length; ++wordIndex) {
            if (wordIndex > 0) {
                out.print(',');
            }
            out.print(counts[wordIndex]);
        }
        out.println("");
    }
}

