/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.util;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.lib.dirtree.DTNReader;
import org.gerhardb.lib.dirtree.DTNReaderWriter;
import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.rdp.PathManager;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.StopCheck;
import org.gerhardb.lib.util.startup.ILoadingMessage;

public class RecreateDirectories
extends JFrame
implements StopCheck {
    private static final String LAST_FILE = "LastFile";
    private static final String LAST_ROOT = "LastRoot";
    private static final String APP_NAME = "RecreateDirectories";
    private static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/util/RecreateDirectories");
    JTextField myFileName = new JTextField(60);
    JTextField myRootDir = new JTextField(60);
    JLabel myProgress = new JLabel("                                                                                       ");
    DTNReaderWriter myReaderWriter;
    boolean iStop = false;
    JButton myStopBtn = new JButton(Jibs.getString("RecreateDirectories.4"));

    public RecreateDirectories(String targetType) {
        super(Jibs.getString("RecreateDirectories.5"));
        this.myFileName.setText(clsPrefs.get(LAST_FILE, null));
        this.myRootDir.setText(clsPrefs.get(LAST_ROOT, null));
        this.myReaderWriter = new DTNReaderWriter(targetType, ViewerPreferences.countImageFilesInNodes(), PathManager.getStartingJibsFile());
        this.layoutComponents();
        this.setIconImage(Icons.icon(26).getImage());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RecreateDirectories.this.pack();
                SwingUtils.centerOnScreen(RecreateDirectories.this);
                RecreateDirectories.this.setVisible(true);
            }
        });
    }

    public boolean isStopped() {
        return this.iStop;
    }

    private void layoutComponents() {
        this.setSize(new Dimension(600, 600));
        JButton goBtn = new JButton(Jibs.getString("RecreateDirectories.6"));
        goBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecreateDirectories.this.go();
            }
        });
        this.myStopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecreateDirectories.this.iStop = true;
            }
        });
        JButton fileBtn = new JButton("...");
        fileBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecreateDirectories.this.selectFile();
            }
        });
        JButton rootBtn = new JButton("...");
        rootBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecreateDirectories.this.selectRoot();
            }
        });
        JPanelRows topPanel = new JPanelRows(1);
        JPanel aRow = topPanel.topRow();
        aRow.add(new JLabel(Jibs.getString("RecreateDirectories.9")));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(Jibs.getString("RecreateDirectories.10")));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(Jibs.getString("RecreateDirectories.11")));
        aRow.add(new JLabel(Jibs.getString("RecreateDirectories.12")));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(" "));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(Jibs.getString("RecreateDirectories.14")));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(this.myReaderWriter.getFileName() + Jibs.getString("colon") + " "));
        aRow.add(this.myFileName);
        aRow.add(fileBtn);
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(" "));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(Jibs.getString("RecreateDirectories.17")));
        aRow = topPanel.nextRow();
        aRow.add(new JLabel(Jibs.getString("RecreateDirectories.18") + Jibs.getString("colon") + " "));
        aRow.add(this.myRootDir);
        aRow.add(rootBtn);
        aRow = topPanel.nextRow();
        aRow.add(goBtn);
        aRow.add(this.myStopBtn);
        aRow = topPanel.nextRow();
        aRow.add(this.myProgress);
        this.setContentPane(topPanel);
    }

    void selectFile() {
        File picked;
        JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_FILE, null));
        chooser.setSaveName(APP_NAME, this.myReaderWriter.getFileName());
        chooser.setDialogTitle(Jibs.getString("RecreateDirectories.20") + this.myReaderWriter.getFileName());
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new JibsTreeFileFilter());
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (picked = chooser.getSelectedFile()) != null) {
            this.myFileName.setText(picked.toString());
            try {
                clsPrefs.put(LAST_FILE, picked.toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void selectRoot() {
        File picked;
        JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_ROOT, null));
        chooser.setSaveName(APP_NAME, Jibs.getString("RecreateDirectories.21"));
        chooser.setApproveButtonText(Jibs.getString("RecreateDirectories.22"));
        chooser.setDialogTitle(Jibs.getString("RecreateDirectories.23"));
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (picked = chooser.getSelectedFile()) != null) {
            this.myRootDir.setText(picked.toString());
            try {
                clsPrefs.put(LAST_ROOT, picked.toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void go() {
        String fileName = this.myFileName.getText();
        File treeFile = new File(fileName);
        if (!treeFile.exists()) {
            JOptionPane.showMessageDialog(this, Jibs.getString("RecreateDirectories.24"), Jibs.getString("RecreateDirectories.25"), 0);
            return;
        }
        String rootString = this.myRootDir.getText();
        File rootFile = new File(rootString);
        if (!rootFile.exists()) {
            JOptionPane.showMessageDialog(this, Jibs.getString("RecreateDirectories.26"), Jibs.getString("RecreateDirectories.27"), 0);
            return;
        }
        if (this.iStop) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            DirectoryTree tree = null;
            DTNReader reader = this.myReaderWriter.getReader(treeFile, tree, new Message());
            DirectoryTreeNode rootNode = reader.getRootNode();
            this.makeChildern(rootNode, rootString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("RecreateDirectories.28"), 0);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.myProgress.setText(Jibs.getString("RecreateDirectories.29"));
    }

    private void makeChildern(DirectoryTreeNode node, String rootString) throws Exception {
        if (this.iStop) {
            return;
        }
        if (!rootString.endsWith("/") && !rootString.endsWith("\\")) {
            rootString = rootString + File.separator;
        }
        Enumeration<TreeNode> kids = node.children();
        while (kids.hasMoreElements()) {
            DirectoryTreeNode aChild = (DirectoryTreeNode)kids.nextElement();
            String name = aChild.getName();
            String dirName = rootString + name;
            File dir = new File(dirName);
            dir.mkdirs();
            this.makeChildern(aChild, dirName);
        }
    }

    class Message
    implements ILoadingMessage {
        private int myIncrement = 1;

        Message() {
        }

        public void setText(String msg) {
            RecreateDirectories.this.myProgress.setText(msg);
        }

        public void setMessage(String msg) {
        }

        public int getNextIncrement() {
            return this.myIncrement++;
        }
    }

    class JibsTreeFileFilter
    extends FileFilter {
        JibsTreeFileFilter() {
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.startsWith("JibsTree", 0);
        }

        public String getDescription() {
            return "JibsTree";
        }
    }
}

