/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.frame;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.LicenseBox;
import org.gerhardb.jibs.camera.Camera;
import org.gerhardb.jibs.concatenater.AutoConcatenate;
import org.gerhardb.jibs.concatenater.Concatenater;
import org.gerhardb.jibs.concatenater.Splitter;
import org.gerhardb.jibs.dirtools.DirectoryCopy;
import org.gerhardb.jibs.dirtools.DirectoryDedup;
import org.gerhardb.jibs.games.missingTile.MissingTile;
import org.gerhardb.jibs.optimizer.Optimizer;
import org.gerhardb.jibs.textCompare.TextCompareGUI;
import org.gerhardb.jibs.textPad.TextPad;
import org.gerhardb.jibs.textPad.ranker.AppRanker;
import org.gerhardb.jibs.util.CheckSumChecker;
import org.gerhardb.jibs.util.FileRenameWithDirName;
import org.gerhardb.jibs.util.ListDirectoryContents;
import org.gerhardb.jibs.util.RecreateDirectories;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.contact.ContactSheetOptions;
import org.gerhardb.jibs.viewer.frame.SaverActions;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.jibs6.Jibs6Hacks;
import org.gerhardb.jibs6.KeyChangerDialog;
import org.gerhardb.jibs6.diskUsage.JibsDiskUsage;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.playlist.IScroll;
import org.gerhardb.lib.playlist.Scroller;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.app.AboutBox;
import org.gerhardb.lib.util.app.Info;
import org.gerhardb.lib.util.startup.ActiveActions;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.FactoryDefaultActions;

public class ViewerActions
extends ActiveActions {
    SortScreen mySortScreen;
    private SaverActions mySaverActions;

    public ViewerActions(SortScreen ss) {
        this.mySortScreen = ss;
        this.mySaverActions = new SaverActions(this.mySortScreen);
    }

    public Action getAction(String menu, String item) {
        menu = "SortScreen.menu." + menu;
        return super.getAction(menu, item);
    }

    protected FactoryDefaultActions getFactoryDefaultActions() {
        return new ViewerStartupActions();
    }

    public SaverActions getSaverActions() {
        return this.mySaverActions;
    }

    public JButton makeSaveButton() {
        JButton rtnMe = this.getToolBarButton("file", "save");
        rtnMe.setToolTipText(Jibs.getString("Actions.94"));
        return rtnMe;
    }

    public JButton getToolBarButton(String menu, String item) {
        JButton rtnMe = this.getAccelleratedToolBarButton(menu, item);
        return rtnMe;
    }

    JMenu getFileMenu() {
        JMenu move = ActionHelpers.makeMenu("move");
        move.add(this.makeMenuItem("file", "repeat"));
        move.add(this.makeMenuItem("file", "park"));
        move.add(this.makeMenuItem("file", "trash"));
        move.add(this.makeMenuItem("file", "directoryList"));
        JMenu menu = ActionHelpers.makeMenu("file");
        menu.add(this.makeMenuItem("file", "openview"));
        menu.add(this.mySortScreen.getPathManager().getRecentDirMenu());
        menu.add(this.makeMenuItem("file", "opentree"));
        menu.add(this.mySortScreen.getPathManager().getRecentTreeMenu());
        Action action = this.getAction("file", "defaultFileView");
        if (action != null) {
            menu.add(new JMenuItem(action));
        }
        menu.addSeparator();
        menu.add(move);
        menu.add(this.makeMenuItem("file", "empty"));
        menu.add(this.makeMenuItem("contact", "dir"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("file", "save"));
        menu.add(this.makeMenuItem("file", "saveas"));
        menu.add(this.makeMenuItem("file", "rename"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("file", "preview"));
        menu.add(this.makeMenuItem("file", "print"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("file", "exit"));
        return menu;
    }

    JMenu getEditMenu() {
        JMenu menu = ActionHelpers.makeMenu("edit");
        menu.add(this.makeMenuItem("edit", "undo"));
        menu.add(this.makeMenuItem("edit", "redo"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("edit", "copy"));
        menu.add(this.makeMenuItem("edit", "all"));
        menu.add(this.makeMenuItem("edit", "clear"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("edit", "right"));
        menu.add(this.makeMenuItem("edit", "left"));
        menu.add(this.makeMenuItem("edit", "shrink"));
        menu.add(this.makeMenuItem("edit", "grow"));
        return menu;
    }

    JMenu getViewMenu(IFrame frame) {
        JCheckBox sorter = this.makeCheckBox("view", "sorter");
        sorter.setSelected(ViewerPreferences.isShowSorterShowing());
        JMenu menu = ActionHelpers.makeMenu("view");
        menu.add(this.makeMenuItem("view", "reload"));
        menu.add(this.makeMenuItem("view", "back"));
        menu.add(this.makeMenuItem("view", "forward"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("view", "full"));
        menu.add(this.makeMenuItem("view", "fullmovie"));
        menu.add(this.makeMenuItem("view", "movie"));
        menu.add(this.makeMenuItem("view", "comic"));
        menu.addSeparator();
        ViewerPreferences.makeViewMenu(frame, menu);
        menu.addSeparator();
        menu.add(sorter);
        menu.addSeparator();
        return menu;
    }

    JMenu getToolsMenu() {
        JMenu textMenu = ActionHelpers.makeMenu("text");
        textMenu.add(this.makeMenuItem("text", "textPad"));
        textMenu.add(this.makeMenuItem("text", "textDedup"));
        textMenu.add(this.makeMenuItem("text", "textRank"));
        JMenu randomMenu = ActionHelpers.makeMenu("random");
        randomMenu.add(this.makeMenuItem("tools", "recreateDirs"));
        randomMenu.add(this.makeMenuItem("tools", "dirCopy"));
        randomMenu.add(this.makeMenuItem("tools", "dirDedup"));
        randomMenu.add(this.makeMenuItem("tools", "dirTreeList"));
        JMenu otherMenu = ActionHelpers.makeMenu("other");
        otherMenu.add(textMenu);
        otherMenu.add(randomMenu);
        otherMenu.add(this.makeMenuItem("tools", "diskUsage"));
        otherMenu.add(this.makeMenuItem("tools", "checkSumChecker"));
        otherMenu.add(this.makeMenuItem("tools", "renameSubdirsNames"));
        JMenu setupMenu = ActionHelpers.makeMenu("setup");
        setupMenu.add(this.makeMenuItem("tools", "options"));
        setupMenu.add(this.makeMenuItem("tools", "menu"));
        JMenu splitMenu = ActionHelpers.makeMenu("split");
        splitMenu.add(this.makeMenuItem("tools", "splitter"));
        splitMenu.add(this.makeMenuItem("tools", "concatenater"));
        splitMenu.add(this.makeMenuItem("tools", "autoconcat"));
        JMenu menu = ActionHelpers.makeMenu("tools");
        menu.add(this.makeMenuItem("contact", "dir"));
        menu.add(this.makeMenuItem("tools", "group"));
        menu.add(this.makeMenuItem("tools", "camera"));
        menu.add(this.makeMenuItem("tools", "treestats"));
        menu.add(splitMenu);
        menu.add(otherMenu);
        menu.add(setupMenu);
        return menu;
    }

    JMenu getToysMenu() {
        JMenu toysMenu = ActionHelpers.makeMenu("toys");
        toysMenu.add(this.makeMenuItem("toys", "tile"));
        return toysMenu;
    }

    JMenu getHelpMenu() {
        JMenu acceleratorsMenu = ActionHelpers.makeMenu("accelerators");
        acceleratorsMenu.add(this.makeMenuItem("accelerators", "focus"));
        JMenu menu = ActionHelpers.makeMenu("help");
        menu.add(this.makeMenuItem("help", "help"));
        menu.add(this.makeMenuItem("help", "about"));
        menu.add(acceleratorsMenu);
        menu.add(this.makeMenuItem("help", "license"));
        menu.add(this.makeMenuItem("help", "info"));
        return menu;
    }

    class LicenseAction
    extends AbstractAction {
        LicenseAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new LicenseBox(ViewerActions.this.mySortScreen);
        }
    }

    class InfoAction
    extends AbstractAction {
        InfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new Info(ViewerActions.this.mySortScreen, ViewerActions.this.mySortScreen.getShow());
        }
    }

    class AboutAction
    extends AbstractAction {
        AboutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new AboutBox(ViewerActions.this.mySortScreen);
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.showHelp();
        }
    }

    class SwapFocusAction
    extends AbstractAction {
        SwapFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.myShow.swapPictureFocus();
        }
    }

    class ShowTileGameAction
    extends AbstractAction {
        ShowTileGameAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                new MissingTile(false);
            }
            catch (NoClassDefFoundError ex) {
                JOptionPane.showMessageDialog(ViewerActions.this.mySortScreen, Jibs.getString("Actions.91"), Jibs.getString("Actions.90"), 1);
            }
            catch (UnsupportedClassVersionError ex) {
                JOptionPane.showMessageDialog(ViewerActions.this.mySortScreen, Jibs.getString("Actions.89"), Jibs.getString("Actions.88"), 1);
            }
        }
    }

    class DirDedupAction
    extends AbstractAction {
        DirDedupAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new DirectoryDedup(false);
        }
    }

    class DirCopyAction
    extends AbstractAction {
        DirCopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new DirectoryCopy(false);
        }
    }

    class ShowTreeStatsAction
    extends AbstractAction {
        ShowTreeStatsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.getRDPmanager().showStats(ViewerActions.this.mySortScreen.getTree().getRootNode(), ViewerPreferences.countImageFilesInNodes());
        }
    }

    class ShowSetupMenuAction
    extends AbstractAction {
        ShowSetupMenuAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (AppStarter.isJava6Enabled()) {
                    new KeyChangerDialog(ViewerActions.this.mySortScreen);
                }
            }
            catch (NoClassDefFoundError ex) {
                JOptionPane.showMessageDialog(ViewerActions.this.mySortScreen, Jibs.getString("Actions.85"), Jibs.getString("Actions.84"), 1);
            }
            catch (UnsupportedClassVersionError ex) {
                JOptionPane.showMessageDialog(ViewerActions.this.mySortScreen, Jibs.getString("Actions.83"), Jibs.getString("Actions.82"), 1);
            }
        }
    }

    class ShowSetupOptionsAction
    extends AbstractAction {
        ShowSetupOptionsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.myPopups.showSetup(0);
        }
    }

    class ShowAutoConcatenatorAction
    extends AbstractAction {
        ShowAutoConcatenatorAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new AutoConcatenate(false);
        }
    }

    class ShowConcatenatorAction
    extends AbstractAction {
        ShowConcatenatorAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new Concatenater(false);
        }
    }

    class ShowSplitterAction
    extends AbstractAction {
        ShowSplitterAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new Splitter(false);
        }
    }

    class ShowCameraAction
    extends AbstractAction {
        ShowCameraAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new Camera(false);
        }
    }

    class ShowOptimizerAction
    extends AbstractAction {
        ShowOptimizerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new Optimizer(false, ViewerActions.this.mySortScreen.getRDPplugins());
        }
    }

    class RenameAction
    extends AbstractAction {
        RenameAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.getFileList().renameSomeFiles();
        }
    }

    class SorterAction
    extends AbstractAction {
        SorterAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.mySorterPanel.flipSorter();
        }
    }

    class ComicAction
    extends AbstractAction {
        ComicAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.gotoComicScreen();
        }
    }

    class MovieAction
    extends AbstractAction {
        MovieAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.mySlideShowManager.flipSlideShow();
        }
    }

    class FullMovieAction
    extends AbstractAction {
        FullMovieAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            System.out.println("FULL MOVIE ACTION PRESSED");
            ViewerActions.this.mySortScreen.gotoFullScreen(true);
        }
    }

    class FullAction
    extends AbstractAction {
        FullAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.gotoFullScreen(ViewerPreferences.immediateShow());
        }
    }

    class ForwardAction
    extends AbstractAction {
        ForwardAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.getFileListManager().forward();
        }
    }

    class BackAction
    extends AbstractAction {
        BackAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.getFileListManager().back();
        }
    }

    class ReloadAction
    extends AbstractAction {
        ReloadAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.setCursor(Cursor.getPredefinedCursor(3));
            ViewerActions.this.mySortScreen.myShow.reloadScroller();
            ViewerActions.this.mySortScreen.setCursor(Cursor.getDefaultCursor());
        }
    }

    class ClearSelectionAction
    extends AbstractAction {
        ClearSelectionAction() {
        }

        public void actionPerformed(ActionEvent e) {
            FileList list = ViewerActions.this.mySortScreen.getFileList();
            list.clearSelection();
            ViewerActions.this.mySortScreen.myShow.showPageFromScroller();
        }
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
        }

        public void actionPerformed(ActionEvent e) {
            FileList list = ViewerActions.this.mySortScreen.getFileList();
            list.clearSelection();
            list.addSelectionInterval(0, list.getModel().getSize() - 1);
            ViewerActions.this.mySortScreen.myShow.showPageFromScroller();
        }
    }

    class CopyAction
    extends AbstractAction {
        CopyAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.myShow.getSaver().copy();
        }
    }

    class RedoAction
    extends AbstractAction {
        RedoAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.getRDPmanager().getMoveManager().getUndoManager().redo();
            ViewerActions.this.mySortScreen.getRDPmanager().getMoveManager().updateUndoRedoButtons();
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.getRDPmanager().getMoveManager().getUndoManager().undo();
            ViewerActions.this.mySortScreen.getRDPmanager().getMoveManager().updateUndoRedoButtons();
        }
    }

    class DiskUsageAction
    extends AbstractAction {
        DiskUsageAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                new JibsDiskUsage(false, (IScroll)ViewerActions.this.mySortScreen.getScroller());
            }
            catch (NoClassDefFoundError ex) {
                JOptionPane.showMessageDialog(ViewerActions.this.mySortScreen, Jibs.getString("Actions.91"), Jibs.getString("Actions.90"), 1);
            }
            catch (UnsupportedClassVersionError ex) {
                JOptionPane.showMessageDialog(ViewerActions.this.mySortScreen, Jibs.getString("Actions.89"), Jibs.getString("Actions.88"), 1);
            }
        }
    }

    class ListDirectoryTreeAction
    extends AbstractAction {
        ListDirectoryTreeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new ListDirectoryContents();
        }
    }

    class CheckSumCheckerAction
    extends AbstractAction {
        CheckSumCheckerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new CheckSumChecker();
        }
    }

    class RenameSubdirsNamesAction
    extends AbstractAction {
        RenameSubdirsNamesAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new FileRenameWithDirName(false);
        }
    }

    class TextDedupAction
    extends AbstractAction {
        TextDedupAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new TextCompareGUI(false);
        }
    }

    class TextPadAction
    extends AbstractAction {
        TextPadAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Runnable runMe = new Runnable(){

                public void run() {
                    new TextPad(false);
                }
            };
            new Thread(runMe).start();
        }
    }

    class TextRankerAction
    extends AbstractAction {
        TextRankerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new AppRanker(false);
        }
    }

    class RecreateDirsAction
    extends AbstractAction {
        RecreateDirsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new RecreateDirectories(ViewerActions.this.mySortScreen.getAppIDandTargetType());
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.exit();
        }
    }

    class ShowContactSheetDirAction
    extends AbstractAction {
        ShowContactSheetDirAction() {
        }

        public void actionPerformed(ActionEvent e) {
            new ContactSheetOptions(ViewerActions.this.mySortScreen, ViewerActions.this.mySortScreen.getFileList().getSelectedFiles(), 0, ViewerActions.this.mySortScreen.getScroller());
        }
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.myShow.getSaver().print();
        }
    }

    class PreviewAction
    extends AbstractAction {
        PreviewAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.myShow.getSaver().preview();
        }
    }

    class EmptyTrashAction
    extends AbstractAction {
        EmptyTrashAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.getRDPmanager().emptyTrash();
        }
    }

    class TreeDirectoryAction
    extends AbstractAction {
        TreeDirectoryAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.getTreeManager().setTreeDirectory();
        }
    }

    class ViewDirectoryAction
    extends AbstractAction {
        ViewDirectoryAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ViewerActions.this.mySortScreen.getFileListManager().askUserForViewDirectory(ViewerActions.this.mySortScreen);
        }
    }

    class DirectoryListAction
    extends AbstractAction {
        DirectoryListAction() {
            super(null, Icons.icon(29));
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.getRDPmanager().clickDirectoryList();
        }
    }

    class RepeatAction
    extends AbstractAction {
        RepeatAction() {
            super(null, Icons.icon(15));
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.getRDPmanager().clickRepeat();
        }
    }

    class ParkAction
    extends AbstractAction {
        ParkAction() {
            super(null, Icons.icon(14));
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.getRDPmanager().clickPark();
        }
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            super(null, Icons.icon(3));
        }

        public void actionPerformed(ActionEvent ae) {
            ViewerActions.this.mySortScreen.getRDPmanager().clickTrash();
        }
    }

    private class ViewerStartupActions
    extends FactoryDefaultActions {
        public ViewerStartupActions() {
            this.addStartupAction("SortScreen.menu", "file", "repeat", new RepeatAction(), Icons.icon(15));
            this.addStartupAction("SortScreen.menu", "file", "park", new ParkAction(), Icons.icon(14));
            this.addStartupAction("SortScreen.menu", "file", "trash", new DeleteAction(), Icons.icon(3));
            this.addStartupAction("SortScreen.menu", "file", "directoryList", new DirectoryListAction(), Icons.icon(29));
            this.addStartupAction("SortScreen.menu", "contact", "dir", new ShowContactSheetDirAction(), null);
            this.addStartupAction("SortScreen.menu", "file", "openview", new ViewDirectoryAction(), null);
            this.addStartupAction("SortScreen.menu", "file", "opentree", new TreeDirectoryAction(), null);
            try {
                Action defaultFileViewerAction;
                if (AppStarter.isJava6Enabled() && (defaultFileViewerAction = Jibs6Hacks.getDefaultFileViewerAction((Scroller)ViewerActions.this.mySortScreen.getScroller())) != null) {
                    this.addStartupAction("SortScreen.menu", "file", "defaultFileView", defaultFileViewerAction, null);
                }
            }
            catch (NoClassDefFoundError ex) {
                ex.printStackTrace();
            }
            this.addStartupAction("SortScreen.menu", "file", "empty", new EmptyTrashAction(), null);
            this.addStartupAction("SortScreen.menu", "file", "save", ViewerActions.this.mySaverActions.getSavePictureAction(), Icons.icon(0));
            this.addStartupAction("SortScreen.menu", "file", "saveas", ViewerActions.this.mySaverActions.getSaveAsPictureAction(), Icons.icon(22));
            this.addStartupAction("SortScreen.menu", "file", "rename", new RenameAction(), Icons.icon(13));
            this.addStartupAction("SortScreen.menu", "file", "preview", new PreviewAction(), null);
            this.addStartupAction("SortScreen.menu", "file", "print", new PrintAction(), null);
            this.addStartupAction("SortScreen.menu", "file", "exit", new ExitAction(), null);
            this.addStartupAction("SortScreen.menu", "edit", "undo", new UndoAction(), Icons.icon(4));
            this.addStartupAction("SortScreen.menu", "edit", "redo", new RedoAction(), Icons.icon(5));
            this.addStartupAction("SortScreen.menu", "edit", "copy", new CopyAction(), null);
            this.addStartupAction("SortScreen.menu", "edit", "all", new SelectAllAction(), null);
            this.addStartupAction("SortScreen.menu", "edit", "clear", new ClearSelectionAction(), Icons.icon(30));
            this.addStartupAction("SortScreen.menu", "edit", "right", ViewerActions.this.mySaverActions.getRotateRightAction(), Icons.icon(1));
            this.addStartupAction("SortScreen.menu", "edit", "left", ViewerActions.this.mySaverActions.getRotateLeftAction(), Icons.icon(2));
            this.addStartupAction("SortScreen.menu", "edit", "shrink", ViewerActions.this.mySaverActions.getShrinkAction(), Icons.icon(12));
            this.addStartupAction("SortScreen.menu", "edit", "grow", ViewerActions.this.mySaverActions.getGrowAction(), Icons.icon(11));
            this.addStartupAction("SortScreen.menu", "view", "reload", new ReloadAction(), Icons.icon(6));
            this.addStartupAction("SortScreen.menu", "view", "back", new BackAction(), Icons.icon(24));
            this.addStartupAction("SortScreen.menu", "view", "forward", new ForwardAction(), Icons.icon(25));
            this.addStartupAction("SortScreen.menu", "view", "fullmovie", new FullMovieAction(), Icons.icon(21));
            this.addStartupAction("SortScreen.menu", "view", "movie", new MovieAction(), Icons.icon(19));
            this.addStartupAction("SortScreen.menu", "view", "full", new FullAction(), Icons.icon(10));
            this.addStartupAction("SortScreen.menu", "view", "comic", new ComicAction(), Icons.icon(31));
            this.addStartupAction("SortScreen.menu", "view", "sorter", new SorterAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "group", new ShowOptimizerAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "camera", new ShowCameraAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "splitter", new ShowSplitterAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "concatenater", new ShowConcatenatorAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "autoconcat", new ShowAutoConcatenatorAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "recreateDirs", new RecreateDirsAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "checkSumChecker", new CheckSumCheckerAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "dirTreeList", new ListDirectoryTreeAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "diskUsage", new DiskUsageAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "options", new ShowSetupOptionsAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "menu", new ShowSetupMenuAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "treestats", new ShowTreeStatsAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "dirCopy", new DirCopyAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "dirDedup", new DirDedupAction(), null);
            this.addStartupAction("SortScreen.menu", "tools", "renameSubdirsNames", new RenameSubdirsNamesAction(), null);
            this.addStartupAction("SortScreen.menu", "text", "textPad", new TextPadAction(), null);
            this.addStartupAction("SortScreen.menu", "text", "textRank", new TextRankerAction(), null);
            this.addStartupAction("SortScreen.menu", "text", "textDedup", new TextDedupAction(), null);
            this.addStartupAction("SortScreen.menu", "accelerators", "focus", new SwapFocusAction(), null);
            this.addStartupAction("SortScreen.menu", "toys", "tile", new ShowTileGameAction(), null);
            this.addStartupAction("SortScreen.menu", "help", "help", new HelpAction(), Icons.icon(7));
            this.addStartupAction("SortScreen.menu", "help", "about", new AboutAction(), Icons.icon(9));
            this.addStartupAction("SortScreen.menu", "help", "license", new LicenseAction(), null);
            this.addStartupAction("SortScreen.menu", "help", "info", new InfoAction(), null);
        }
    }
}

