/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.classic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.shows.classic.SingleNoResize;
import org.gerhardb.jibs.viewer.sorter.TilePanel;

public class SingleNoResizeScrollControl
extends SingleNoResize {
    int myOffsetWidth;
    int myOffsetHeight;
    private JScrollPane myScrollPane = new JScrollPane(this, 20, 30);

    public SingleNoResizeScrollControl(IFrame mf) {
        super(mf);
    }

    public JComponent getImageDisplay() {
        return this.myScrollPane;
    }

    public void showImage(Graphics g) {
        Color backgroundColor = OK_COLOR;
        BufferedImage showMe = this.mySaver.getCurrentImage();
        if (showMe == null) {
            showMe = this.myViewerFrame.getScroller().getBeyondBounds();
            if (showMe == null) {
                super.showNoPicture(g);
                return;
            }
            backgroundColor = EMPTY_COLOR;
        }
        this.myShownWidth = showMe.getWidth();
        this.myShownHeight = showMe.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        this.myOffsetWidth = (int)((float)(this.getWidth() - this.myShownWidth) * this.myOffsetWidthPercentage);
        this.myOffsetHeight = (int)((float)(this.getHeight() - this.myShownHeight) * this.myOffsetHeightPercentage);
        Dimension size = new Dimension(this.myShownWidth, this.myShownHeight);
        this.setPreferredSize(size);
        this.revalidate();
        super.setBackground(backgroundColor);
        super.paintComponent(g);
        g2.drawImage(showMe, null, this.myOffsetWidth, this.myOffsetHeight);
        if (this.iNeedToRepositionScrollBars) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SingleNoResizeScrollControl.this.positionPicture();
                }
            });
            this.iNeedToRepositionScrollBars = false;
        }
        if (this.myViewerFrame.getScroller().getCurrentIOImage() != null) {
            File file = this.myViewerFrame.getScroller().getCurrentIOImage().getFile();
            TilePanel.clsTilePanel.clip(file, g2, super.getWidth(), super.getHeight());
        }
        this.myViewerFrame.statusCurrentPage();
    }

    void positionPicture() {
        JViewport vp = this.myScrollPane.getViewport();
        Rectangle vpRect = vp.getViewRect();
        Dimension vpExtent = vp.getExtentSize();
        Dimension vpViewSize = vp.getViewSize();
        JScrollBar hBar = this.myScrollPane.getHorizontalScrollBar();
        JScrollBar vBar = this.myScrollPane.getVerticalScrollBar();
        if (vpExtent.width != vpViewSize.width) {
            this.myOffsetWidth = (int)((float)(hBar.getMaximum() - (int)vpRect.getWidth()) * this.myOffsetWidthPercentage);
        }
        if (vpExtent.height != vpViewSize.height) {
            this.myOffsetHeight = (int)((float)(vBar.getMaximum() - (int)vpRect.getHeight()) * this.myOffsetHeightPercentage);
        }
        Point newPosition = new Point(this.myOffsetWidth, this.myOffsetHeight);
        vp.setViewPosition(newPosition);
    }

    KeyListener getKeyListener() {
        return new KeyActions();
    }

    private class KeyActions
    implements KeyListener {
        private KeyActions() {
        }

        public void keyTyped(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 10: {
                    if ((event.getModifiersEx() & 0x80) == 128) {
                        SingleNoResizeScrollControl.this.revert();
                    }
                    if ((event.getModifiersEx() & 0x200) == 512) {
                        SingleNoResizeScrollControl.this.revert();
                    }
                    event.consume();
                    return;
                }
            }
        }

        public void keyReleased(KeyEvent event) {
            if (!event.isConsumed()) {
                if (event.isAltDown()) {
                    SingleNoResizeScrollControl.this.processNumPad(event);
                } else {
                    this.processFuncitionKeys(event);
                }
            }
        }

        private void processFuncitionKeys(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 113: {
                    SingleNoResizeScrollControl.this.myViewerFrame.gotoFullScreen(false);
                    event.consume();
                    return;
                }
                case 115: {
                    SingleNoResizeScrollControl.this.myOptions.setFullSizeTileTo(5);
                    SingleNoResizeScrollControl.this.showImage();
                    event.consume();
                    return;
                }
            }
        }
    }
}

