/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.optimizer.Optimizer;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTreePopUp;

public class FileTreePopUp
extends ExtendedDirectoryTreePopUp {
    public FileTreePopUp(ExtendedDirectoryTree tree, TreePath path, boolean countImageFilesInNodes) {
        super(tree, path, countImageFilesInNodes);
    }

    protected void addExtensions() {
        this.addSeparator();
        JMenuItem optimizeSingle = this.add(Jibs.getString("FileTreePopUp.8"));
        JMenuItem optimizeTree = this.add(Jibs.getString("FileTreePopUp.9"));
        JMenuItem optimizeSelected = this.add(Jibs.getString("FileTreePopUp.10"));
        if (this.myDirectoryNode == null) {
            optimizeSingle.setEnabled(false);
            return;
        }
        optimizeTree.setEnabled(false);
        if (this.myDirectoryNode.getChildCount() > 0) {
            optimizeTree.setEnabled(true);
        }
        optimizeSelected.setEnabled(false);
        if (this.myTree.getSelectionCount() > 0) {
            optimizeSelected.setEnabled(true);
        }
        optimizeSingle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                File[] file = new File[]{FileTreePopUp.this.myDirectoryNode.getFile()};
                new Optimizer(file, FileTreePopUp.this.myTree.getPlugins().getRDPplugins());
            }
        });
        optimizeTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Enumeration<TreeNode> depth = FileTreePopUp.this.myDirectoryNode.depthFirstEnumeration();
                ArrayList<File> list = new ArrayList<File>();
                while (depth.hasMoreElements()) {
                    DirectoryTreeNode aNode = (DirectoryTreeNode)depth.nextElement();
                    list.add(aNode.getFile());
                }
                File[] files = new File[list.size()];
                list.toArray(files);
                new Optimizer(files, FileTreePopUp.this.myTree.getPlugins().getRDPplugins());
            }
        });
        optimizeSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TreePath[] paths = FileTreePopUp.this.myTree.getSelectionPaths();
                File[] files = new File[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    DirectoryTreeNode aNode = (DirectoryTreeNode)paths[i].getLastPathComponent();
                    files[i] = aNode.getFile();
                }
                new Optimizer(files, FileTreePopUp.this.myTree.getPlugins().getRDPplugins());
            }
        });
    }
}

