/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.gerhardb.lib.dirtree.DTNFile;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.io.FilenameFileFilter;
import org.gerhardb.lib.io.FilesOnlyFileFilter;
import org.gerhardb.lib.playlist.ListMaker;

public class DTNListFactory
implements ListMaker {
    DirectoryTreeNode[] myNodes;
    boolean iShowNonImages;
    FilenameFileFilter myFilter;

    public DTNListFactory(DirectoryTreeNode[] nodes, boolean nonImage, FilenameFileFilter filter) {
        if (nodes == null || nodes.length == 0) {
            throw new IllegalArgumentException("DTNListFactory requires non-null DirectoryTreeNode.");
        }
        this.myNodes = nodes;
        this.iShowNonImages = nonImage;
        this.myFilter = filter;
    }

    public String getDescription() {
        switch (this.myNodes.length) {
            case 1: {
                return this.myNodes[0].getAbsolutePath();
            }
            case 2: {
                return this.myNodes[0].getAbsolutePath() + " and " + this.myNodes[1].getAbsolutePath();
            }
        }
        return "Various directories selected";
    }

    public File[] getFileList() {
        File[] fileList = null;
        ArrayList<DTNFile> pageList = new ArrayList<DTNFile>(400);
        for (int i = 0; i < this.myNodes.length; ++i) {
            File directory = this.myNodes[i].getFile();
            fileList = this.iShowNonImages ? directory.listFiles(FilesOnlyFileFilter.FILES_ONLY) : directory.listFiles(this.myFilter);
            if (fileList == null) continue;
            for (int j = 0; j < fileList.length; ++j) {
                pageList.add(new DTNFile(fileList[j].getAbsolutePath(), this.myNodes[i]));
            }
        }
        File[] pages = new DTNFile[pageList.size()];
        pageList.toArray(pages);
        return pages;
    }

    public boolean nodesUpdated(DirectoryTreeNode parent) {
        boolean rtnMe = false;
        Enumeration<TreeNode> kids = parent.breadthFirstEnumeration();
        while (kids.hasMoreElements()) {
            DirectoryTreeNode aNode = (DirectoryTreeNode)kids.nextElement();
            for (int i = 0; i < this.myNodes.length; ++i) {
                if (!this.myNodes[i].getDirectory().equals(aNode.getDirectory())) continue;
                this.myNodes[i] = aNode;
                rtnMe = true;
            }
        }
        return rtnMe;
    }
}

