/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileSystemView;
import org.gerhardb.lib.dirtree.DTNReaderWriter;
import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.ILoadingMessage;

public class DTNReader {
    private static final String VERSION_TOKEN_TARGET_COUNTED = "# v2i ";
    private static final String VERSION_TOKEN_NO_TARGET_COUNT = "# v2x ";
    private static final String DATE_MARKER = "# Date: ";
    private static final String ROOT_NAME_MARKER = "# Root Name: ";
    private static final String ROOT_PATH_MARKER = "# Root Path: ";
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private DTNReaderWriter myBase;
    private DirectoryTree myTree;
    private ILoadingMessage myLoadingMsg;
    private boolean iCountTargets = false;
    private Date myLastReadDate;
    private String myStoredRootPath;
    private String myStoredVolumeName;
    private String myRootPath;
    boolean iNeedToShowMissingDirectoryMessage = true;
    DirectoryTreeNode[] levels = new DirectoryTreeNode[100];

    public DTNReader(File file, DirectoryTree tree, ILoadingMessage loadingMsg, DTNReaderWriter base) {
        this.myTree = tree;
        this.myLoadingMsg = loadingMsg;
        this.myBase = base;
        try {
            BufferedReader reader = this.openFileReader(file);
            if (reader != null) {
                this.readFile(reader);
            }
            this.levels[0].iAmPopulating = false;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public DirectoryTreeNode getRootNode() {
        return this.levels[0];
    }

    public boolean getImagesCounted() {
        return this.iCountTargets;
    }

    public Date getLastReadDate() {
        return this.myLastReadDate;
    }

    public String getStoredRootPath() {
        return this.myStoredRootPath;
    }

    public String getStoredVolumeName() {
        return this.myStoredVolumeName;
    }

    public static String getNameOfDrive(String path) {
        File dir;
        FileSystemView view = FileSystemView.getFileSystemView();
        String name = view.getSystemDisplayName(dir = new File(path));
        if (name == null) {
            return null;
        }
        if ((name = name.trim()) == null || name.length() < 1) {
            return null;
        }
        int index = name.lastIndexOf(" (");
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    private BufferedReader openFileReader(File file) throws Exception {
        File passedInFile = this.myBase.myFileFromPathManagerStartingJibsFile;
        if (passedInFile != null && passedInFile.exists() && passedInFile.isFile()) {
            this.myRootPath = passedInFile.getParentFile().getAbsolutePath();
            file = passedInFile;
        } else {
            if (file.isDirectory()) {
                this.myRootPath = file.getAbsolutePath();
                String fileName = this.myRootPath + "/" + this.myBase.getFileName();
                file = new File(fileName);
            } else {
                this.myRootPath = file.getParentFile().getAbsolutePath();
            }
            if (file.exists()) {
                this.myLoadingMsg.setText(AppStarter.getString("TreeManager.13") + AppStarter.getString("colon") + " " + file);
            } else {
                String msg = AppStarter.getString("TreeManager.14") + AppStarter.getString("colon") + " " + file;
                this.myLoadingMsg.setText(msg);
                System.out.println(msg);
                throw new Exception("File not found: " + file);
            }
        }
        try {
            return new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException ex) {
            System.out.println(AppStarter.getString("TreeManager.22") + AppStarter.getString("colon") + " " + file);
            System.out.println(AppStarter.getString("TreeManager.23"));
            this.myLoadingMsg.setText(AppStarter.getString("TreeManager.24"));
            return null;
        }
    }

    private void readFile(BufferedReader reader) {
        try {
            String aLine = reader.readLine();
            if (aLine == null) {
                this.myLoadingMsg.setText(AppStarter.getString("DTNReaderWriter.20"));
                return;
            }
            if (aLine.startsWith(VERSION_TOKEN_TARGET_COUNTED)) {
                this.iCountTargets = true;
            } else {
                if (this.myBase.iCountTargetFiles) {
                    this.myLoadingMsg.setText(AppStarter.getString("DTNReaderWriter.19"));
                    return;
                }
                if (!aLine.startsWith(VERSION_TOKEN_NO_TARGET_COUNT)) {
                    this.myLoadingMsg.setText(AppStarter.getString("DTNReaderWriter.18"));
                    return;
                }
            }
            aLine = reader.readLine();
            while (aLine != null) {
                StringTokenizer tokens;
                if (aLine.startsWith(DATE_MARKER)) {
                    String strDate = aLine.substring(DATE_MARKER.length());
                    try {
                        this.myLastReadDate = DATE_FORMAT.parse(strDate);
                        AppStarter.log(strDate);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (aLine.startsWith(ROOT_PATH_MARKER)) {
                    this.myStoredRootPath = aLine.substring(ROOT_PATH_MARKER.length());
                    AppStarter.log(this.myStoredRootPath);
                } else if (aLine.startsWith(ROOT_NAME_MARKER)) {
                    this.myStoredVolumeName = aLine.substring(ROOT_PATH_MARKER.length());
                    AppStarter.log(this.myStoredVolumeName);
                } else if (!aLine.startsWith("#") && (tokens = new StringTokenizer(aLine, "\t")).countTokens() > 5) {
                    try {
                        this.useLine(tokens);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.myLoadingMsg.setText(AppStarter.getString("TreeManager.21"));
                    }
                }
                aLine = reader.readLine();
            }
            reader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.myLoadingMsg.setText(AppStarter.getString("TreeManager.25"));
        }
    }

    private void useLine(StringTokenizer tokens) throws Exception {
        int depth = Integer.parseInt(tokens.nextToken());
        String fileName = tokens.nextToken();
        fileName = this.myRootPath + fileName.substring(1);
        File file = new File(fileName);
        try {
            DirectoryTreeNode node = new DirectoryTreeNode(this.myTree, file, this.myLoadingMsg);
            DTNReader.restoreANode(tokens, node);
            if (depth > 0) {
                this.levels[depth - 1].add(node);
                this.levels[depth] = node;
            } else if (depth == 0) {
                if (this.levels[0] == null) {
                    this.levels[0] = node;
                } else {
                    this.levels[0].add(node);
                }
            }
        }
        catch (FileNotFoundException ex) {
            if (this.iNeedToShowMissingDirectoryMessage) {
                this.iNeedToShowMissingDirectoryMessage = false;
                System.out.println(AppStarter.getString("TreeManager.16"));
                System.out.println(AppStarter.getString("TreeManager.17"));
                System.out.println(AppStarter.getString("TreeManager.18"));
                System.out.println(AppStarter.getString("TreeManager.19"));
            }
            System.out.println(ex.getMessage());
            this.myLoadingMsg.setText(AppStarter.getString("TreeManager.20"));
        }
    }

    private static void restoreANode(StringTokenizer tokens, DirectoryTreeNode node) throws Exception {
        node.myNodeDirCount = Integer.parseInt(tokens.nextToken());
        node.myNodeAllFileCount = Integer.parseInt(tokens.nextToken());
        node.myNodeAllFileSize = Long.parseLong(tokens.nextToken());
        node.myNodeTargetFileCount = Integer.parseInt(tokens.nextToken());
        node.myNodeTargetFileSize = Long.parseLong(tokens.nextToken());
    }
}

