/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.filelist;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.dirtree.filelist.LinklessDragListener;

public class FileDrag
implements Transferable {
    public static final DataFlavor FILE_DRAG_DATA_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=org.gerhardb.lib.dirtree.filelist.FileDrag", "Local FileDrag");
    protected DataFlavor[] myDataFlavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, FILE_DRAG_DATA_FLAVOR};
    private DragSourceListener myDSListener = new DSListener();
    private FileList myFileList;

    public FileDrag(FileList list) {
        this.myFileList = list;
        DragSource ds = new DragSource();
        LinklessDragListener dgl = new LinklessDragListener(this.myDSListener, this, ds);
        ds.createDefaultDragGestureRecognizer(list, 3, dgl);
    }

    public DragSourceListener getDragSourceListener() {
        return this.myDSListener;
    }

    public List getFileList() {
        this.myFileList.updateResetRecommendation();
        Object[] selected = this.myFileList.myDragSelections;
        if (selected == null) {
            selected = this.myFileList.getSelectedValues();
        }
        this.myFileList.myDragSelections = null;
        ArrayList<Object> droppedList = new ArrayList<Object>(selected.length);
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] == null) continue;
            try {
                if (!(selected[i] instanceof File)) continue;
                droppedList.add(selected[i]);
                continue;
            }
            catch (Exception ex) {
                System.out.println("EXCEPTION ************  FileList getTransferData");
                System.out.println(ex.getMessage());
            }
        }
        return droppedList;
    }

    public Object getTransferData(DataFlavor flavor) {
        if (FILE_DRAG_DATA_FLAVOR.equals(flavor)) {
            return this;
        }
        return this.getFileList();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.myDataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < this.myDataFlavors.length; ++i) {
            if (!this.myDataFlavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    class DSListener
    extends DragSourceAdapter {
        DSListener() {
        }

        public void dragDropEnd(DragSourceDropEvent event) {
            if (event.getDropSuccess()) {
                FileDrag.this.myFileList.updateResetRecommendation();
                final int returnToIndex = FileDrag.this.myFileList.getResetRecommendation();
                int index = ((FileDrag)FileDrag.this).myFileList.myPlugins.getScroller().getValueZeroBased();
                int[] indexes = FileDrag.this.myFileList.getSelectedIndices();
                if (indexes != null && index > 0) {
                    for (int i = 0; i < indexes.length; ++i) {
                        if (indexes[i] >= index) continue;
                        --index;
                    }
                }
                if (event.getDropSuccess()) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ((FileDrag)((DSListener)DSListener.this).FileDrag.this).myFileList.myPlugins.setWaitCursor(true);
                            ((FileDrag)((DSListener)DSListener.this).FileDrag.this).myFileList.myPlugins.reloadScroller(returnToIndex);
                            ((FileDrag)((DSListener)DSListener.this).FileDrag.this).myFileList.myPlugins.setWaitCursor(false);
                        }
                    });
                }
            }
            event.getDragSourceContext().setCursor(Cursor.getPredefinedCursor(0));
        }

        public void dropActionChanged(DragSourceDragEvent event) {
            switch (event.getUserAction()) {
                case 2: {
                    event.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                    break;
                }
                case 1: {
                    event.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
                    break;
                }
            }
        }
    }
}

