/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import javax.swing.JComponent;
import org.gerhardb.lib.print.PageablePreviewer;

class PreviewablePage
extends JComponent {
    Pageable myPageable;
    int myPageIndex;
    PageablePreviewer myPageablePreviewer;
    PageFormat myShrunkenPageFormat;

    public PreviewablePage(Pageable p, PageablePreviewer pp) {
        super.setOpaque(true);
        this.myPageable = p;
        this.myPageablePreviewer = pp;
        super.setDoubleBuffered(false);
    }

    public void setPageIndex(int index) {
        this.myPageIndex = index;
        super.revalidate();
    }

    PageFormat getCurrentPageFormat() {
        return this.myPageable.getPageFormat(this.myPageIndex);
    }

    public void paint(Graphics graphics) {
        final Graphics g2 = this.getGraphics();
        Thread show = new Thread(new Runnable(){

            public void run() {
                try {
                    g2.setColor(PreviewablePage.this.getBackground());
                    g2.fillRect(0, 0, PreviewablePage.this.getWidth(), PreviewablePage.this.getHeight());
                    PreviewablePage.this.myPageablePreviewer.painting(true);
                    Printable printMe = PreviewablePage.this.myPageable.getPrintable(PreviewablePage.this.myPageIndex);
                    printMe.print(g2, PreviewablePage.this.myShrunkenPageFormat, PreviewablePage.this.myPageIndex);
                    PreviewablePage.this.myPageablePreviewer.painting(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    g2.setColor(Color.GREEN);
                    g2.drawRect(0, 0, PreviewablePage.this.getWidth(), PreviewablePage.this.getHeight());
                }
            }
        });
        show.start();
    }
}

